/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rte;

import io.agora.rte.Canvas;
import io.agora.rte.Error;
import io.agora.rte.PlayerConfig;
import io.agora.rte.PlayerCustomSourceProvider;
import io.agora.rte.PlayerInfo;
import io.agora.rte.PlayerInitialConfig;
import io.agora.rte.PlayerObserver;
import io.agora.rte.Rte;
import io.agora.rte.Stream;
import io.agora.rte.callback.PlayerGetStatsCallback;
import io.agora.rte.callback.PlayerOpenCallback;
import io.agora.rte.callback.PlayerSetConfigsCallback;

public class Player {
    private long mNativeHandle = 0L;

    public Player(Rte rte, PlayerInitialConfig initialConfig, Error error) {
        this.mNativeHandle = this.nativeCreatePlayer(rte != null ? Long.valueOf(rte.GetNativeHandle()) : null, initialConfig != null ? Long.valueOf(initialConfig.GetNativeHandle()) : null, error != null ? Long.valueOf(error.GetNativeHandle()) : null);
    }

    public void Release() {
        this.nativeReleasePlayer(this.mNativeHandle);
        this.mNativeHandle = 0L;
    }

    protected void finalize() {
        this.Release();
    }

    public long GetNativeHandle() {
        return this.mNativeHandle;
    }

    public void PreloadWithUrl(String url, Error error) {
        this.nativePreloadWithUrl(this.mNativeHandle, url, error != null ? Long.valueOf(error.GetNativeHandle()) : null);
    }

    public void OpenWithUrl(String url, long startTime, PlayerOpenCallback callback, Object cbData) {
        this.nativeOpenWithUrl(this.mNativeHandle, url, startTime, callback, cbData);
    }

    public void OpenWithCustomSourceProvider(PlayerCustomSourceProvider provider, long startTime, PlayerOpenCallback callback, Object cbData) {
        this.nativeOpenWithCustomSourceProvider(this.mNativeHandle, provider.GetNativeHandle(), startTime, callback, cbData);
    }

    public void OpenWithStream(Stream stream, PlayerOpenCallback callback, Object cbData) {
        this.nativeOpenWithStream(this.mNativeHandle, stream.GetNativeHandle(), callback, cbData);
    }

    public void GetStats(PlayerGetStatsCallback callback, Object cbData) {
        this.nativeGetStats(this.mNativeHandle, callback, cbData);
    }

    public void SetCanvas(Canvas canvas, Error error) {
        this.nativeSetCanvas(this.mNativeHandle, canvas.GetNativeHandle(), error != null ? Long.valueOf(error.GetNativeHandle()) : null);
    }

    public void Play(Error error) {
        this.nativePlay(this.mNativeHandle, error != null ? Long.valueOf(error.GetNativeHandle()) : null);
    }

    public void Stop(Error error) {
        this.nativeStop(this.mNativeHandle, error != null ? Long.valueOf(error.GetNativeHandle()) : null);
    }

    public void Pause(Error error) {
        this.nativePause(this.mNativeHandle, error != null ? Long.valueOf(error.GetNativeHandle()) : null);
    }

    public void Seek(long newTime, Error error) {
        this.nativeSeek(this.mNativeHandle, newTime, error != null ? Long.valueOf(error.GetNativeHandle()) : null);
    }

    public void MuteAudio(boolean mute, Error error) {
        this.nativeMuteAudio(this.mNativeHandle, mute, error != null ? Long.valueOf(error.GetNativeHandle()) : null);
    }

    public void MuteVideo(boolean mute, Error error) {
        this.nativeMuteVideo(this.mNativeHandle, mute, error != null ? Long.valueOf(error.GetNativeHandle()) : null);
    }

    public long GetPosition(Error error) {
        return this.nativeGetPosition(this.mNativeHandle, error != null ? Long.valueOf(error.GetNativeHandle()) : null);
    }

    public void GetInfo(PlayerInfo info, Error error) {
        this.nativeGetInfo(this.mNativeHandle, info.GetNativeHandle(), error != null ? Long.valueOf(error.GetNativeHandle()) : null);
    }

    public void GetConfigs(PlayerConfig config, Error error) {
        this.nativeGetConfigs(this.mNativeHandle, config != null ? Long.valueOf(config.GetNativeHandle()) : null, error != null ? Long.valueOf(error.GetNativeHandle()) : null);
    }

    public void SetConfigs(PlayerConfig config, PlayerSetConfigsCallback callback, Object cbData) {
        this.nativeSetConfigs(this.mNativeHandle, config != null ? Long.valueOf(config.GetNativeHandle()) : null, callback, cbData);
    }

    public boolean RegisterObserver(PlayerObserver observer, Error error) {
        return this.nativeRegisterObserver(this.mNativeHandle, observer != null ? Long.valueOf(observer.GetNativeHandle()) : null, error != null ? Long.valueOf(error.GetNativeHandle()) : null);
    }

    public boolean UnregisterObserver(PlayerObserver observer, Error error) {
        return this.nativeUnregisterObserver(this.mNativeHandle, observer != null ? Long.valueOf(observer.GetNativeHandle()) : null, error != null ? Long.valueOf(error.GetNativeHandle()) : null);
    }

    private native long nativeCreatePlayer(long var1, long var3, long var5);

    private native void nativeReleasePlayer(long var1);

    private native void nativePreloadWithUrl(long var1, String var3, long var4);

    private native void nativeOpenWithUrl(long var1, String var3, long var4, PlayerOpenCallback var6, Object var7);

    private native void nativeOpenWithCustomSourceProvider(long var1, long var3, long var5, PlayerOpenCallback var7, Object var8);

    private native void nativeOpenWithStream(long var1, long var3, PlayerOpenCallback var5, Object var6);

    private native void nativeGetStats(long var1, PlayerGetStatsCallback var3, Object var4);

    private native void nativeSetCanvas(long var1, long var3, long var5);

    private native void nativePlay(long var1, long var3);

    private native void nativeStop(long var1, long var3);

    private native void nativePause(long var1, long var3);

    private native void nativeSeek(long var1, long var3, long var5);

    private native void nativeMuteAudio(long var1, boolean var3, long var4);

    private native void nativeMuteVideo(long var1, boolean var3, long var4);

    private native long nativeGetPosition(long var1, long var3);

    private native void nativeGetInfo(long var1, long var3, long var5);

    private native void nativeGetConfigs(long var1, long var3, long var5);

    private native void nativeSetConfigs(long var1, long var3, PlayerSetConfigsCallback var5, Object var6);

    private native boolean nativeRegisterObserver(long var1, long var3, long var5);

    private native boolean nativeUnregisterObserver(long var1, long var3, long var5);
}

