/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base;

import android.graphics.Matrix;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.agora.base.VideoFrame;
import io.agora.base.internal.Logging;
import io.agora.base.internal.RefCountDelegate;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.EglBaseFactory;
import io.agora.base.internal.video.IHandlerReplaceable;
import io.agora.base.internal.video.RendererCommon;
import io.agora.base.internal.video.TextureBufferPool;
import io.agora.base.internal.video.YuvConverter;
import javax.microedition.khronos.egl.EGLContext;

public class TextureBuffer
implements VideoFrame.TextureBuffer,
IHandlerReplaceable {
    private static final boolean VERBOSE = false;
    private static final String TAG = "TextureBuffer";
    private static final long DEFAULT_FENCE_VALUE = 0L;
    @NonNull
    private final EglBase.Context eglContext;
    private final int width;
    private final int height;
    private final VideoFrame.TextureBuffer.Type type;
    private final int id;
    private final Matrix transformMatrix;
    @Nullable
    private final Handler toI420Handler;
    @Nullable
    private final YuvConverter yuvConverter;
    @Nullable
    private final TextureBufferPool sourceTexturePool;
    private long fenceObject = 0L;
    private final RefCountDelegate refCountDelegate;
    private int sequence = -1;
    private boolean is10bitTexture = false;

    public TextureBuffer(@NonNull EGLContext sharedContext, int width, int height, VideoFrame.TextureBuffer.Type type, int id, Matrix transformMatrix, @Nullable Handler toI420Handler, @Nullable YuvConverter yuvConverter, @Nullable Runnable releaseCallback) {
        this(EglBaseFactory.createEgl10Context(sharedContext), width, height, type, id, transformMatrix, toI420Handler, yuvConverter, releaseCallback, null, 0L, -1, false);
    }

    public TextureBuffer(@NonNull android.opengl.EGLContext sharedContext, int width, int height, VideoFrame.TextureBuffer.Type type, int id, Matrix transformMatrix, @Nullable Handler toI420Handler, @Nullable YuvConverter yuvConverter, @Nullable Runnable releaseCallback) {
        this(EglBaseFactory.createEgl14Context(sharedContext), width, height, type, id, transformMatrix, toI420Handler, yuvConverter, releaseCallback, null, 0L, -1, false);
    }

    public TextureBuffer(@NonNull android.opengl.EGLContext sharedContext, int width, int height, VideoFrame.TextureBuffer.Type type, int id, long fenceObject, Matrix transformMatrix, @Nullable Handler toI420Handler, @Nullable YuvConverter yuvConverter, @Nullable Runnable releaseCallback) {
        this(EglBaseFactory.createEgl14Context(sharedContext), width, height, type, id, transformMatrix, toI420Handler, yuvConverter, releaseCallback, null, fenceObject, -1, false);
    }

    public TextureBuffer(@NonNull EglBase.Context eglContext, int width, int height, VideoFrame.TextureBuffer.Type type, int id, long fenceObject, Matrix transformMatrix, @NonNull Handler toI420Handler, @NonNull YuvConverter yuvConverter, @Nullable Runnable releaseCallback) {
        this(eglContext, width, height, type, id, transformMatrix, toI420Handler, yuvConverter, releaseCallback, null, fenceObject, -1, false);
    }

    public TextureBuffer(@NonNull EglBase.Context eglContext, int width, int height, VideoFrame.TextureBuffer.Type type, int id, Matrix transformMatrix, @NonNull Handler toI420Handler, @NonNull YuvConverter yuvConverter, @Nullable Runnable releaseCallback, boolean is10bitTexture) {
        this(eglContext, width, height, type, id, transformMatrix, toI420Handler, yuvConverter, releaseCallback, null, 0L, -1, is10bitTexture);
    }

    public TextureBuffer(@NonNull EglBase.Context eglContext, int width, int height, VideoFrame.TextureBuffer.Type type, int id, Matrix transformMatrix, @NonNull Handler toI420Handler, @NonNull YuvConverter yuvConverter, @Nullable Runnable releaseCallback) {
        this(eglContext, width, height, type, id, transformMatrix, toI420Handler, yuvConverter, releaseCallback, null, 0L, -1, false);
    }

    public TextureBuffer(@NonNull EglBase.Context eglContext, int width, int height, VideoFrame.TextureBuffer.Type type, int id, Matrix transformMatrix, @Nullable Handler toI420Handler, @Nullable YuvConverter yuvConverter, @Nullable Runnable releaseCallback, @Nullable TextureBufferPool sourceTexturePool, long fenceObject, int sequence, boolean is10bitTexture) {
        this.eglContext = eglContext;
        this.width = width;
        this.height = height;
        this.type = type;
        this.id = id;
        this.transformMatrix = transformMatrix;
        this.toI420Handler = toI420Handler;
        this.yuvConverter = yuvConverter;
        this.sourceTexturePool = sourceTexturePool;
        this.refCountDelegate = new RefCountDelegate(releaseCallback);
        this.sequence = sequence;
        this.fenceObject = fenceObject;
        this.is10bitTexture = is10bitTexture;
    }

    public TextureBuffer withSequence(int sequence) {
        this.sequence = sequence;
        return this;
    }

    @Override
    public VideoFrame.TextureBuffer.Type getType() {
        return this.type;
    }

    @Override
    public int getTextureId() {
        return this.id;
    }

    @Override
    public Matrix getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    @NonNull
    public EglBase.Context getEglBaseContext() {
        return this.eglContext;
    }

    @Override
    public Object getSourceTexturePool() {
        return this.sourceTexturePool;
    }

    @Override
    public long getNativeEglContext() {
        return this.eglContext.getNativeEglContext();
    }

    @Override
    public int getEglContextType() {
        return EglBaseFactory.isEglBase14(this.eglContext) ? VideoFrame.TextureBuffer.ContextType.EGL_CONTEXT_14.ordinal() : VideoFrame.TextureBuffer.ContextType.EGL_CONTEXT_10.ordinal();
    }

    @Override
    public float[] getTransformMatrixArray() {
        return RendererCommon.convertMatrixFromAndroidGraphicsMatrix(this.transformMatrix);
    }

    @Override
    public int getSequence() {
        return this.sequence;
    }

    @Override
    public boolean is10BitTexture() {
        return this.is10bitTexture;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    @Nullable
    public YuvConverter getYuvConverter() {
        return this.yuvConverter;
    }

    @Override
    @Nullable
    public Handler getToI420Handler() {
        return this.toI420Handler;
    }

    @Override
    public long getFenceObject() {
        return this.fenceObject;
    }

    @Override
    public VideoFrame.Buffer applyNewI420Handler(@NonNull Handler toI420Handler, @NonNull YuvConverter yuvConverter) {
        this.retain();
        return new TextureBuffer(this.eglContext, this.width, this.height, this.type, this.id, this.transformMatrix, toI420Handler, yuvConverter, new Runnable(){

            @Override
            public void run() {
                TextureBuffer.this.release();
            }
        }, this.sourceTexturePool, this.fenceObject, -1, this.is10bitTexture);
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        if (this.toI420Handler == null || this.yuvConverter == null) {
            throw new IllegalStateException("toI420Handler or yuvConverter is null");
        }
        final VideoFrame.I420Buffer[] i420Buffer = new VideoFrame.I420Buffer[]{null};
        try {
            ThreadUtils.invokeAtFrontUninterruptibly(this.toI420Handler, new Runnable(){

                @Override
                public void run() {
                    i420Buffer[0] = TextureBuffer.this.yuvConverter.convert(TextureBuffer.this);
                }
            });
        }
        catch (Exception e) {
            Logging.e(TAG, "toI420 failure:" + e.toString());
            return null;
        }
        return i420Buffer[0];
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        Matrix cropAndScaleMatrix = new Matrix();
        int cropYFromBottom = this.height - (cropY + cropHeight);
        cropAndScaleMatrix.preTranslate((float)cropX / (float)this.width, (float)cropYFromBottom / (float)this.height);
        cropAndScaleMatrix.preScale((float)cropWidth / (float)this.width, (float)cropHeight / (float)this.height);
        return this.applyTransformMatrix(cropAndScaleMatrix, scaleWidth, scaleHeight);
    }

    @Override
    public VideoFrame.Buffer mirror(int frameRotation) {
        Matrix transformMatrix = new Matrix();
        transformMatrix.preTranslate(0.5f, 0.5f);
        if (frameRotation == 90 || frameRotation == 270) {
            transformMatrix.preScale(1.0f, -1.0f);
        } else {
            transformMatrix.preScale(-1.0f, 1.0f);
        }
        transformMatrix.preTranslate(-0.5f, -0.5f);
        return this.applyTransformMatrix(transformMatrix, this.getWidth(), this.getHeight());
    }

    @Override
    public VideoFrame.Buffer rotate(int frameRotation) {
        Matrix transformMatrix = new Matrix();
        int width = frameRotation == 90 || frameRotation == 270 ? this.getHeight() : this.getWidth();
        int height = frameRotation == 90 || frameRotation == 270 ? this.getWidth() : this.getHeight();
        transformMatrix.preTranslate(0.5f, 0.5f);
        transformMatrix.preRotate((float)frameRotation);
        transformMatrix.preTranslate(-0.5f, -0.5f);
        return this.applyTransformMatrix(transformMatrix, width, height);
    }

    @Override
    @Nullable
    public VideoFrame.Buffer transform(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight, int rotation) {
        Matrix transformMatrix = new Matrix();
        int cropYFromBottom = this.height - (cropY + cropHeight);
        transformMatrix.preTranslate((float)cropX / (float)this.width, (float)cropYFromBottom / (float)this.height);
        transformMatrix.preScale((float)cropWidth / (float)this.width, (float)cropHeight / (float)this.height);
        if (scaleWidth > 0 && scaleHeight > 0 && rotation == 0) {
            return this.applyTransformMatrix(transformMatrix, scaleWidth, scaleHeight);
        }
        transformMatrix.preTranslate(0.5f, 0.5f);
        if (scaleWidth < 0) {
            transformMatrix.preScale(-1.0f, 1.0f);
            scaleWidth = -scaleWidth;
        }
        if (scaleHeight < 0) {
            transformMatrix.preScale(1.0f, -1.0f);
            scaleHeight = -scaleHeight;
        }
        if (rotation == 90 || rotation == 270) {
            int tmp = scaleWidth;
            scaleWidth = scaleHeight;
            scaleHeight = tmp;
        }
        if (rotation != 0) {
            transformMatrix.preRotate((float)rotation);
        }
        transformMatrix.preTranslate(-0.5f, -0.5f);
        return this.applyTransformMatrix(transformMatrix, scaleWidth, scaleHeight);
    }

    public TextureBuffer applyTransformMatrix(Matrix transformMatrix, int newWidth, int newHeight) {
        Matrix newMatrix = new Matrix(this.transformMatrix);
        newMatrix.preConcat(transformMatrix);
        this.retain();
        return new TextureBuffer(this.eglContext, newWidth, newHeight, this.type, this.id, newMatrix, this.toI420Handler, this.yuvConverter, new Runnable(){

            @Override
            public void run() {
                TextureBuffer.this.release();
            }
        }, this.sourceTexturePool, this.fenceObject, this.sequence, this.is10bitTexture);
    }

    public TextureBuffer applyNewTextureInfo(VideoFrame.TextureBuffer.Type newType, int newTextureId, long newFenceObject, Matrix newMatrix, int newWidth, int newHeight) {
        this.retain();
        return new TextureBuffer(this.eglContext, newWidth, newHeight, newType, newTextureId, newMatrix, this.toI420Handler, this.yuvConverter, new Runnable(){

            @Override
            public void run() {
                TextureBuffer.this.release();
            }
        }, this.sourceTexturePool, newFenceObject, this.sequence, this.is10bitTexture);
    }
}

