/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base;

import android.graphics.Matrix;
import androidx.annotation.Nullable;
import io.agora.base.VideoFrameMetaInfo;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.JniCommon;
import io.agora.base.internal.RefCounted;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.WrappedNativeColorSpace;
import java.nio.ByteBuffer;

public class VideoFrame
implements RefCounted {
    private Buffer buffer;
    private int rotation;
    private long timestampNs;
    private ColorSpace colorSpace;
    private SourceType sourceType;
    private float sampleAspectRatio;
    private VideoFrameMetaInfo metaInfo = new VideoFrameMetaInfo();
    @Nullable
    private ByteBuffer alphaBuffer;
    private int alphaStitchMode;
    private long nativeAlphaBuffer;

    public VideoFrame(Buffer buffer, int rotation, long timestampNs) {
        this(buffer, rotation, timestampNs, new WrappedNativeColorSpace(), null, 0L, 1.0f, SourceType.kUnspecified.ordinal());
    }

    @CalledByNative
    public VideoFrame(Buffer buffer, int rotation, long timestampNs, ColorSpace colorSpace, ByteBuffer alphaBuffer, long nativeAlphaBuffer, float sampleAspectRatio, int sourceType) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer not allowed to be null");
        }
        if (rotation % 90 != 0) {
            throw new IllegalArgumentException("rotation must be a multiple of 90");
        }
        this.buffer = buffer;
        this.rotation = rotation;
        this.timestampNs = timestampNs;
        this.colorSpace = colorSpace;
        this.alphaBuffer = alphaBuffer;
        this.nativeAlphaBuffer = nativeAlphaBuffer;
        this.sampleAspectRatio = sampleAspectRatio;
        this.sourceType = SourceType.values()[sourceType];
    }

    @CalledByNative
    public SourceType getSourceType() {
        return this.sourceType;
    }

    public float getSampleAspectRatio() {
        return this.sampleAspectRatio;
    }

    @CalledByNative
    public Buffer getBuffer() {
        return this.buffer;
    }

    @CalledByNative
    public int getRotation() {
        return this.rotation;
    }

    @CalledByNative
    public int getAlphaStitchMode() {
        return this.alphaStitchMode;
    }

    @CalledByNative
    public long getTimestampNs() {
        return this.timestampNs;
    }

    @CalledByNative
    public VideoFrameMetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public int getRotatedWidth() {
        if (this.rotation % 180 == 0) {
            return this.buffer.getWidth();
        }
        return this.buffer.getHeight();
    }

    public int getRotatedHeight() {
        if (this.rotation % 180 == 0) {
            return this.buffer.getHeight();
        }
        return this.buffer.getWidth();
    }

    public void replaceBuffer(Buffer buffer, int rotation, long timestampNs) {
        this.release();
        this.buffer = buffer;
        this.rotation = rotation;
        this.timestampNs = timestampNs;
    }

    public ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    @CalledByNative
    public ByteBuffer getAlphaBuffer() {
        return this.alphaBuffer;
    }

    public void retainAlphaBuffer() {
        JniCommon.nativeAddRef(this.nativeAlphaBuffer);
    }

    public void releaseAlphaBuffer() {
        JniCommon.nativeReleaseRef(this.nativeAlphaBuffer);
    }

    public void fillAlphaData(ByteBuffer buffer) {
        this.alphaBuffer = buffer;
    }

    public void setAlphaStitchMode(int mode) {
        this.alphaStitchMode = mode;
    }

    @Override
    public void retain() {
        this.buffer.retain();
    }

    @Override
    @CalledByNative
    public void release() {
        this.buffer.release();
    }

    public static enum SourceType {
        kFrontCamera,
        kBackCamera,
        kUnspecified;

    }

    public static interface HdrMetadata {
        public int getMaxContentLightLevel();

        public int getMaxFrameAverageLightLevel();

        public Chromaticity getprimaryR();

        public Chromaticity getprimaryG();

        public Chromaticity getprimaryB();

        public Chromaticity getWhitePoint();

        public int getLuminanceMax();

        public int getLuminanceMin();

        public static class Chromaticity {
            public int x;
            public int y;

            public Chromaticity(int x, int y) {
                this.x = x;
                this.y = y;
            }
        }
    }

    public static interface ColorSpace {
        public Range getRange();

        public Matrix getMatrix();

        public Transfer getTransfer();

        public Primary getPrimary();

        public HdrMetadata getHdrMetadata();

        public static enum Primary {
            BT709(1),
            Unspecified(2),
            BT470M(4),
            BT470BG(5),
            kSMPTE170M(6),
            kSMPTE240M(7),
            kFILM(8),
            kBT2020(9),
            kSMPTEST428(10),
            kSMPTEST431(11),
            kSMPTEST432(12),
            kJEDECP22(22);

            private final int primary;

            private Primary(int primary) {
                this.primary = primary;
            }

            public int getPrimary() {
                return this.primary;
            }
        }

        public static enum Transfer {
            BT709(1),
            Unspecified(2),
            GAMMA22(4),
            GAMMA28(5),
            SMPTE170M(6),
            SMPTE240M(7),
            LINEAR(8),
            LOG(9),
            LOG_SQRT(10),
            IEC61966_2_4(11),
            BT1361_ECG(12),
            IEC61966_2_1(13),
            BT2020_10(14),
            BT2020_12(15),
            SMPTEST2084(16),
            SMPTEST428(17),
            ARIB_STD_B67(18);

            private final int transfer;

            private Transfer(int transfer) {
                this.transfer = transfer;
            }

            public int getTransfer() {
                return this.transfer;
            }
        }

        public static enum Matrix {
            RGB(0),
            BT709(1),
            Unspecified(2),
            FCC(4),
            BT470BG(5),
            SMPTE170M(6),
            SMPTE240M(7),
            YCOCG(8),
            BT2020_NCL(9),
            BT2020_CL(10),
            SMPTE2085(11),
            CDNCLS(12),
            CDCLS(13),
            BT2100_ICTCP(14);

            private final int matrix;

            private Matrix(int matrix) {
                this.matrix = matrix;
            }

            public int getMatrix() {
                return this.matrix;
            }
        }

        public static enum Range {
            Invalid(0),
            Limited(1),
            Full(2),
            Derived(3);

            private final int range;

            private Range(int range) {
                this.range = range;
            }

            public int getRange() {
                return this.range;
            }
        }
    }

    public static interface TextureBuffer
    extends Buffer {
        public Type getType();

        @CalledByNative(value="TextureBuffer")
        public int getTextureId();

        public Matrix getTransformMatrix();

        @CalledByNative(value="TextureBuffer")
        public EglBase.Context getEglBaseContext();

        @CalledByNative(value="TextureBuffer")
        public Object getSourceTexturePool();

        @CalledByNative(value="TextureBuffer")
        public long getNativeEglContext();

        @CalledByNative(value="TextureBuffer")
        public int getEglContextType();

        @CalledByNative(value="TextureBuffer")
        public float[] getTransformMatrixArray();

        @CalledByNative(value="TextureBuffer")
        public int getSequence();

        @CalledByNative(value="TextureBuffer")
        public long getFenceObject();

        @CalledByNative(value="TextureBuffer")
        public boolean is10BitTexture();

        public static enum ContextType {
            EGL_CONTEXT_10,
            EGL_CONTEXT_14;

        }

        public static enum Type {
            OES(36197),
            RGB(3553);

            private final int glTarget;

            private Type(int glTarget) {
                this.glTarget = glTarget;
            }

            public int getGlTarget() {
                return this.glTarget;
            }
        }
    }

    public static interface RgbaBuffer
    extends Buffer {
        @CalledByNative(value="RgbaBuffer")
        public ByteBuffer getData();
    }

    public static interface I422Buffer
    extends Buffer {
        @CalledByNative(value="I422Buffer")
        public ByteBuffer getDataY();

        @CalledByNative(value="I422Buffer")
        public ByteBuffer getDataU();

        @CalledByNative(value="I422Buffer")
        public ByteBuffer getDataV();

        @CalledByNative(value="I422Buffer")
        public int getStrideY();

        @CalledByNative(value="I422Buffer")
        public int getStrideU();

        @CalledByNative(value="I422Buffer")
        public int getStrideV();
    }

    public static interface I420Buffer
    extends Buffer {
        @CalledByNative(value="I420Buffer")
        public ByteBuffer getDataY();

        @CalledByNative(value="I420Buffer")
        public ByteBuffer getDataU();

        @CalledByNative(value="I420Buffer")
        public ByteBuffer getDataV();

        @CalledByNative(value="I420Buffer")
        public int getStrideY();

        @CalledByNative(value="I420Buffer")
        public int getStrideU();

        @CalledByNative(value="I420Buffer")
        public int getStrideV();
    }

    public static interface Buffer
    extends RefCounted {
        @CalledByNative(value="Buffer")
        public int getWidth();

        @CalledByNative(value="Buffer")
        public int getHeight();

        @CalledByNative(value="Buffer")
        public I420Buffer toI420();

        @Override
        @CalledByNative(value="Buffer")
        public void release();

        @Override
        @CalledByNative(value="Buffer")
        public void retain();

        @CalledByNative(value="Buffer")
        public Buffer cropAndScale(int var1, int var2, int var3, int var4, int var5, int var6);

        @CalledByNative(value="Buffer")
        @Nullable
        public Buffer mirror(int var1);

        @CalledByNative(value="Buffer")
        @Nullable
        public Buffer rotate(int var1);

        @CalledByNative(value="Buffer")
        @Nullable
        public Buffer transform(int var1, int var2, int var3, int var4, int var5, int var6, int var7);
    }
}

