/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2;

import io.agora.base.internal.CalledByNative;
import io.agora.rtc2.video.VideoEncoderConfiguration;

public class SimulcastConfig {
    public final StreamLayerConfig[] configs = new StreamLayerConfig[StreamLayerIndex.STREAM_LAYER_COUNT_MAX.getValue()];

    public SimulcastConfig() {
        for (int i = 0; i < StreamLayerIndex.STREAM_LAYER_COUNT_MAX.getValue(); ++i) {
            this.configs[i] = new StreamLayerConfig();
        }
    }

    public class StreamLayerConfig {
        public VideoEncoderConfiguration.VideoDimensions dimensions;
        public int framerate;
        public boolean enable;

        public StreamLayerConfig() {
            this.dimensions = new VideoEncoderConfiguration.VideoDimensions(0, 0);
            this.framerate = 0;
            this.enable = false;
        }

        public StreamLayerConfig(VideoEncoderConfiguration.VideoDimensions dimensions, int framerate, boolean enable) {
            this.dimensions = dimensions;
            this.framerate = framerate;
            this.enable = enable;
        }

        @CalledByNative(value="StreamLayerConfig")
        public int getFramerate() {
            return this.framerate;
        }

        @CalledByNative(value="StreamLayerConfig")
        public int getDimensionsWidth() {
            return this.dimensions.width;
        }

        @CalledByNative(value="StreamLayerConfig")
        public int getDimensionsHeight() {
            return this.dimensions.height;
        }

        @CalledByNative(value="StreamLayerConfig")
        public boolean isEnabled() {
            return this.enable;
        }
    }

    public static enum StreamLayerIndex {
        STREAM_LAYER_1(0),
        STREAM_LAYER_2(1),
        STREAM_LAYER_3(2),
        STREAM_LAYER_4(3),
        STREAM_LAYER_5(4),
        STREAM_LAYER_6(5),
        STREAM_LOW(6),
        STREAM_LAYER_COUNT_MAX(7);

        private int value;

        private StreamLayerIndex(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }
    }
}

