/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.video;

public class VideoEncoderConfiguration {
    public static final VideoDimensions VD_120x120 = new VideoDimensions(120, 120);
    public static final VideoDimensions VD_160x120 = new VideoDimensions(160, 120);
    public static final VideoDimensions VD_180x180 = new VideoDimensions(180, 180);
    public static final VideoDimensions VD_240x180 = new VideoDimensions(240, 180);
    public static final VideoDimensions VD_320x180 = new VideoDimensions(320, 180);
    public static final VideoDimensions VD_240x240 = new VideoDimensions(240, 240);
    public static final VideoDimensions VD_320x240 = new VideoDimensions(320, 240);
    public static final VideoDimensions VD_424x240 = new VideoDimensions(424, 240);
    public static final VideoDimensions VD_360x360 = new VideoDimensions(360, 360);
    public static final VideoDimensions VD_480x360 = new VideoDimensions(480, 360);
    public static final VideoDimensions VD_640x360 = new VideoDimensions(640, 360);
    public static final VideoDimensions VD_480x480 = new VideoDimensions(480, 480);
    public static final VideoDimensions VD_640x480 = new VideoDimensions(640, 480);
    public static final VideoDimensions VD_840x480 = new VideoDimensions(840, 480);
    public static final VideoDimensions VD_960x540 = new VideoDimensions(960, 540);
    public static final VideoDimensions VD_960x720 = new VideoDimensions(960, 720);
    public static final VideoDimensions VD_1280x720 = new VideoDimensions(1280, 720);
    public static final VideoDimensions VD_1920x1080 = new VideoDimensions(1920, 1080);
    public static final VideoDimensions VD_2540x1440 = new VideoDimensions(2540, 1440);
    public static final VideoDimensions VD_3840x2160 = new VideoDimensions(3840, 2160);
    public static final int STANDARD_BITRATE = 0;
    public static final int COMPATIBLE_BITRATE = -1;
    public static final int DEFAULT_MIN_BITRATE = -1;
    public static final int DEFAULT_MIN_FRAMERATE = -1;
    public static final int DEFAULT_MIN_BITRATE_EQUAL_TO_TARGET_BITRATE = -2;
    public VideoDimensions dimensions;
    public int frameRate;
    public int minFrameRate;
    public int bitrate;
    public int minBitrate;
    public ORIENTATION_MODE orientationMode;
    public DEGRADATION_PREFERENCE degradationPrefer;
    public MIRROR_MODE_TYPE mirrorMode;
    public AdvanceOptions advanceOptions;
    public VIDEO_CODEC_TYPE codecType;

    public VideoEncoderConfiguration() {
        this.dimensions = new VideoDimensions(960, 540);
        this.frameRate = FRAME_RATE.FRAME_RATE_FPS_15.getValue();
        this.minFrameRate = -1;
        this.bitrate = 0;
        this.minBitrate = -1;
        this.orientationMode = ORIENTATION_MODE.ORIENTATION_MODE_ADAPTIVE;
        this.degradationPrefer = DEGRADATION_PREFERENCE.MAINTAIN_QUALITY;
        this.mirrorMode = MIRROR_MODE_TYPE.MIRROR_MODE_DISABLED;
        this.advanceOptions = new AdvanceOptions(ENCODING_PREFERENCE.PREFER_AUTO, COMPRESSION_PREFERENCE.PREFER_LOW_LATENCY, false);
        this.codecType = VIDEO_CODEC_TYPE.VIDEO_CODEC_NONE;
    }

    public VideoEncoderConfiguration(VideoDimensions dimensions, FRAME_RATE frameRate, int bitrate, ORIENTATION_MODE orientationMode) {
        this.dimensions = dimensions;
        this.frameRate = frameRate.getValue();
        this.minFrameRate = -1;
        this.bitrate = bitrate;
        this.minBitrate = -1;
        this.orientationMode = orientationMode;
        this.degradationPrefer = DEGRADATION_PREFERENCE.MAINTAIN_QUALITY;
        this.mirrorMode = MIRROR_MODE_TYPE.MIRROR_MODE_DISABLED;
        this.advanceOptions = new AdvanceOptions(ENCODING_PREFERENCE.PREFER_AUTO, COMPRESSION_PREFERENCE.PREFER_LOW_LATENCY, false);
        this.codecType = VIDEO_CODEC_TYPE.VIDEO_CODEC_NONE;
    }

    public VideoEncoderConfiguration(VideoDimensions dimensions, FRAME_RATE frameRate, int bitrate, ORIENTATION_MODE orientationMode, MIRROR_MODE_TYPE mirrorMode) {
        this.dimensions = dimensions;
        this.frameRate = frameRate.getValue();
        this.minFrameRate = -1;
        this.bitrate = bitrate;
        this.minBitrate = -1;
        this.orientationMode = orientationMode;
        this.degradationPrefer = DEGRADATION_PREFERENCE.MAINTAIN_QUALITY;
        this.mirrorMode = mirrorMode;
        this.advanceOptions = new AdvanceOptions(ENCODING_PREFERENCE.PREFER_AUTO, COMPRESSION_PREFERENCE.PREFER_LOW_LATENCY, false);
        this.codecType = VIDEO_CODEC_TYPE.VIDEO_CODEC_NONE;
    }

    public VideoEncoderConfiguration(int width, int height, FRAME_RATE frameRate, int bitrate, ORIENTATION_MODE orientationMode) {
        this.dimensions = new VideoDimensions(width, height);
        this.frameRate = frameRate.getValue();
        this.minFrameRate = -1;
        this.bitrate = bitrate;
        this.minBitrate = -1;
        this.orientationMode = orientationMode;
        this.degradationPrefer = DEGRADATION_PREFERENCE.MAINTAIN_QUALITY;
        this.mirrorMode = MIRROR_MODE_TYPE.MIRROR_MODE_DISABLED;
        this.advanceOptions = new AdvanceOptions(ENCODING_PREFERENCE.PREFER_AUTO, COMPRESSION_PREFERENCE.PREFER_LOW_LATENCY, false);
        this.codecType = VIDEO_CODEC_TYPE.VIDEO_CODEC_NONE;
    }

    public VideoEncoderConfiguration(int width, int height, FRAME_RATE frameRate, int bitrate, ORIENTATION_MODE orientationMode, MIRROR_MODE_TYPE mirrorMode) {
        this.dimensions = new VideoDimensions(width, height);
        this.frameRate = frameRate.getValue();
        this.minFrameRate = -1;
        this.bitrate = bitrate;
        this.minBitrate = -1;
        this.orientationMode = orientationMode;
        this.degradationPrefer = DEGRADATION_PREFERENCE.MAINTAIN_QUALITY;
        this.mirrorMode = mirrorMode;
        this.advanceOptions = new AdvanceOptions(ENCODING_PREFERENCE.PREFER_AUTO, COMPRESSION_PREFERENCE.PREFER_LOW_LATENCY, false);
        this.codecType = VIDEO_CODEC_TYPE.VIDEO_CODEC_NONE;
    }

    public static enum VIDEO_CODEC_TYPE {
        VIDEO_CODEC_NONE(0),
        VIDEO_CODEC_VP8(1),
        VIDEO_CODEC_H264(2),
        VIDEO_CODEC_H265(3),
        VIDEO_CODEC_GENERIC(6),
        VIDEO_CODEC_GENERIC_H264(7),
        VIDEO_CODEC_AV1(12),
        VIDEO_CODEC_VP9(13),
        VIDEO_CODEC_GENERIC_JPEG(20);

        private int value;

        private VIDEO_CODEC_TYPE(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum MIRROR_MODE_TYPE {
        MIRROR_MODE_AUTO(0),
        MIRROR_MODE_ENABLED(1),
        MIRROR_MODE_DISABLED(2);

        private int value;

        private MIRROR_MODE_TYPE(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum CODEC_CAP_MASK {
        CODEC_CAP_MASK_NONE(0),
        CODEC_CAP_MASK_HW_DEC(1),
        CODEC_CAP_MASK_HW_ENC(2),
        CODEC_CAP_MASK_SW_DEC(4),
        CODEC_CAP_MASK_SW_ENC(8);

        private int value;

        private CODEC_CAP_MASK(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum DEGRADATION_PREFERENCE {
        MAINTAIN_QUALITY(0),
        MAINTAIN_FRAMERATE(1),
        MAINTAIN_BALANCED(2),
        MAINTAIN_RESOLUTION(3),
        DISABLED(100);

        private int value;

        private DEGRADATION_PREFERENCE(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class AdvanceOptions {
        public ENCODING_PREFERENCE encodingPreference;
        public COMPRESSION_PREFERENCE compressionPreference;
        public boolean encodeAlpha;

        public AdvanceOptions(ENCODING_PREFERENCE encodingPreference, COMPRESSION_PREFERENCE compressionPreference, boolean encodeAlpha) {
            this.encodingPreference = encodingPreference;
            this.compressionPreference = compressionPreference;
            this.encodeAlpha = encodeAlpha;
        }

        public AdvanceOptions() {
            this.encodingPreference = ENCODING_PREFERENCE.PREFER_AUTO;
            this.compressionPreference = COMPRESSION_PREFERENCE.PREFER_LOW_LATENCY;
            this.encodeAlpha = false;
        }
    }

    public static enum COMPRESSION_PREFERENCE {
        PREFER_LOW_LATENCY(0),
        PREFER_QUALITY(1);

        private int value;

        private COMPRESSION_PREFERENCE(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ENCODING_PREFERENCE {
        PREFER_AUTO(-1),
        PREFER_SOFTWARE(0),
        PREFER_HARDWARE(1);

        private int value;

        private ENCODING_PREFERENCE(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ORIENTATION_MODE {
        ORIENTATION_MODE_ADAPTIVE(0),
        ORIENTATION_MODE_FIXED_LANDSCAPE(1),
        ORIENTATION_MODE_FIXED_PORTRAIT(2);

        private int value;

        private ORIENTATION_MODE(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum FRAME_RATE {
        FRAME_RATE_FPS_1(1),
        FRAME_RATE_FPS_7(7),
        FRAME_RATE_FPS_10(10),
        FRAME_RATE_FPS_15(15),
        FRAME_RATE_FPS_24(24),
        FRAME_RATE_FPS_30(30),
        FRAME_RATE_FPS_60(60);

        private int value;

        private FRAME_RATE(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class VideoDimensions {
        public int width;
        public int height;

        public VideoDimensions(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public VideoDimensions() {
            this.width = 0;
            this.height = 0;
        }
    }
}

