/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rte;

import android.view.View;
import io.agora.rte.CanvasConfig;
import io.agora.rte.CanvasInitialConfig;
import io.agora.rte.Error;
import io.agora.rte.Rte;
import io.agora.rte.ViewConfig;
import io.agora.rte.callback.CanvasAddViewCallback;
import io.agora.rte.callback.CanvasSetConfigsCallback;

public class Canvas {
    private long mNativeHandle = 0L;

    public Canvas(Rte rte, CanvasInitialConfig config, Error error) {
        this.mNativeHandle = this.nativeCreateCanvas(rte != null ? Long.valueOf(rte.GetNativeHandle()) : null, config != null ? Long.valueOf(config.GetNativeHandle()) : null, error != null ? Long.valueOf(error.GetNativeHandle()) : null);
    }

    public void Release() {
        this.nativeReleaseCanvas(this.mNativeHandle);
        this.mNativeHandle = 0L;
    }

    protected void finalize() {
        this.Release();
    }

    public long GetNativeHandle() {
        return this.mNativeHandle;
    }

    public void AddView(View view, ViewConfig viewConfig, CanvasAddViewCallback callback, Object cbData) {
        this.nativeAddView(this.mNativeHandle, view, viewConfig != null ? Long.valueOf(viewConfig.GetNativeHandle()) : null, callback, cbData);
    }

    public void RemoveView(View view, ViewConfig viewConfig, Error error) {
        this.nativeRemoveView(this.mNativeHandle, view, viewConfig != null ? Long.valueOf(viewConfig.GetNativeHandle()) : null, error != null ? Long.valueOf(error.GetNativeHandle()) : null);
    }

    public void GetConfigs(CanvasConfig config, Error error) {
        this.nativeGetConfigs(this.mNativeHandle, config != null ? Long.valueOf(config.GetNativeHandle()) : null, error != null ? Long.valueOf(error.GetNativeHandle()) : null);
    }

    public void SetConfigs(CanvasConfig config, CanvasSetConfigsCallback callback, Object cbData) {
        this.nativeSetConfigs(this.mNativeHandle, config != null ? Long.valueOf(config.GetNativeHandle()) : null, callback, cbData);
    }

    private native long nativeCreateCanvas(long var1, long var3, long var5);

    private native void nativeReleaseCanvas(long var1);

    private native void nativeAddView(long var1, View var3, long var4, CanvasAddViewCallback var6, Object var7);

    private native void nativeRemoveView(long var1, View var3, long var4, long var6);

    private native void nativeGetConfigs(long var1, long var3, long var5);

    private native void nativeSetConfigs(long var1, long var3, CanvasSetConfigsCallback var5, Object var6);
}

