/*
 * Decompiled with CFR 0.152.
 */
package io.agora.utils2.internal;

import java.io.PrintWriter;
import java.io.StringWriter;

public class Logging {
    private static final int AGORA_LOG_DEBUG = 2048;
    private static final int AGORA_LOG_INFO = 1;
    private static final int AGORA_LOG_WARN = 2;
    private static final int AGORA_LOG_ERROR = 4;

    public static void log(int level, String tag, String message) {
        Logging.nativeLog(level, "[" + tag + "] " + message);
    }

    public static void d(String message) {
        Logging.nativeLog(2048, message);
    }

    public static void i(String message) {
        Logging.nativeLog(1, message);
    }

    public static void e(String message) {
        Logging.nativeLog(4, message);
    }

    public static void w(String message) {
        Logging.nativeLog(2, message);
    }

    public static void d(String tag, String message) {
        Logging.log(2048, tag, message);
    }

    public static void i(String tag, String message) {
        Logging.log(1, tag, message);
    }

    public static void e(String tag, String message) {
        Logging.log(4, tag, message);
    }

    public static void w(String tag, String message) {
        Logging.log(2, tag, message);
    }

    public static void d(String tag, String message, Throwable e) {
        Logging.log(2048, tag, message);
        Logging.log(2048, tag, e.toString());
        Logging.log(2048, tag, Logging.getStackTraceString(e));
    }

    public static void w(String tag, String message, Throwable e) {
        Logging.log(2, tag, message);
        Logging.log(2, tag, e.toString());
        Logging.log(2, tag, Logging.getStackTraceString(e));
    }

    public static void e(String tag, String message, Throwable e) {
        Logging.log(4, tag, message);
        Logging.log(4, tag, e.toString());
        Logging.log(4, tag, Logging.getStackTraceString(e));
    }

    static String getStackTraceString(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            e.printStackTrace(pw);
            return sw.toString();
        }
        catch (Throwable t) {
            String message = e.getMessage();
            return message == null ? "" : message;
        }
    }

    static native int nativeLog(int var0, String var1);
}

