/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import android.util.Range;
import android.view.Surface;
import androidx.annotation.Nullable;
import io.agora.base.JavaI420Buffer;
import io.agora.base.NV12Buffer;
import io.agora.base.NV21Buffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.CodecSpecificInfo;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.EncodedImage;
import io.agora.base.internal.video.MediaCodecUtils;
import io.agora.base.internal.video.MediaCodecWrapper;
import io.agora.base.internal.video.MediaCodecWrapperFactory;
import io.agora.base.internal.video.SurfaceTextureHelper;
import io.agora.base.internal.video.VideoCodecProfile;
import io.agora.base.internal.video.VideoCodecStatus;
import io.agora.base.internal.video.VideoCodecType;
import io.agora.base.internal.video.VideoDecoder;
import io.agora.base.internal.video.VideoDecoderUtils;
import io.agora.base.internal.video.VideoSink;
import io.agora.base.internal.video.YuvHelper;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

@TargetApi(value=16)
class HardwareVideoDecoder
implements VideoDecoder,
VideoSink {
    private static final String TAG = "HardwareVideoDecoder";
    private static final boolean DEBUG = false;
    private static final String MEDIA_FORMAT_KEY_STRIDE = "stride";
    private static final String MEDIA_FORMAT_KEY_SLICE_HEIGHT = "slice-height";
    private static final String MEDIA_FORMAT_KEY_CROP_LEFT = "crop-left";
    private static final String MEDIA_FORMAT_KEY_CROP_RIGHT = "crop-right";
    private static final String MEDIA_FORMAT_KEY_CROP_TOP = "crop-top";
    private static final String MEDIA_FORMAT_KEY_CROP_BOTTOM = "crop-bottom";
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int DEQUEUE_INPUT_TIMEOUT_US = 500000;
    private static final int DEQUEUE_OUTPUT_BUFFER_TIMEOUT_US = 100000;
    private static final int MAX_DECODE_TIME_MS = 2000;
    private final MediaCodecWrapperFactory mediaCodecWrapperFactory;
    private final String codecName;
    private final VideoCodecType codecType;
    private boolean shouldResetCodec;
    private boolean fallbackByCodecError;
    private final BlockingDeque<FrameInfo> frameInfos;
    private int colorFormat;
    private final Map<String, String> params;
    @Nullable
    private String customConfigJson;
    private final Queue<TimeStamps> decodeTimeStamps = new ConcurrentLinkedQueue<TimeStamps>();
    @Nullable
    private Thread outputThread;
    private ThreadUtils.ThreadChecker outputThreadChecker;
    @Nullable
    private Handler proxyThreadHandler;
    private volatile boolean running = false;
    @Nullable
    private volatile Exception shutdownException = null;
    private boolean deliveredVideoFrame;
    private final Object dimensionLock = new Object();
    private int width;
    private int height;
    private int stride;
    private int sliceHeight;
    private boolean isHisiCodec = false;
    private boolean hasDecodedFirstFrame;
    private boolean keyFrameRequired;
    private final EglBase.Context sharedContext;
    @Nullable
    private SurfaceTextureHelper surfaceTextureHelper;
    @Nullable
    private Surface surface = null;
    private static final int MAX_TEXTURE_BUFFER_COUNT = 16;
    private Surface directSurface;
    private final Object textureMetadataLock = new Object();
    private static final int MAX_DEQUEUED_OUTPUTBUFFERS = 3;
    private final Queue<DecodedTextureMetadata> dequeuedSurfaceOutputBuffers = new LinkedList<DecodedTextureMetadata>();
    @Nullable
    private DecodedTextureMetadata renderedTextureMetadata;
    @Nullable
    private VideoDecoder.Callback callback;
    @Nullable
    private MediaCodecWrapper codec = null;
    private Map<Long, CodecSpecificInfo> codecSpecificInfoMap = new HashMap<Long, CodecSpecificInfo>();

    HardwareVideoDecoder(MediaCodecWrapperFactory mediaCodecWrapperFactory, String codecName, VideoCodecType codecType, Map<String, String> params, int colorFormat, EglBase.Context sharedContext, Surface directSurface) {
        if (!this.isSupportedColorFormat(colorFormat)) {
            throw new IllegalArgumentException("Unsupported color format: " + colorFormat);
        }
        VideoDecoderUtils.isSupportHwDecoderByTypeAndProfile(VideoCodecType.H265.name(), VideoCodecProfile.HEVCMain10HDR10.name());
        this.mediaCodecWrapperFactory = mediaCodecWrapperFactory;
        this.codecName = codecName;
        this.codecType = codecType;
        this.colorFormat = colorFormat;
        this.params = params;
        this.sharedContext = sharedContext;
        this.directSurface = directSurface;
        this.frameInfos = new LinkedBlockingDeque<FrameInfo>();
    }

    @Override
    public VideoCodecStatus attachProxyThread() {
        if (null == this.proxyThreadHandler) {
            HandlerThread proxyThread = new HandlerThread("proxyThread-Decoder");
            proxyThread.start();
            this.proxyThreadHandler = new Handler(proxyThread.getLooper());
        }
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoCodecStatus initDecode(VideoDecoder.Settings settings, VideoDecoder.Callback callback) {
        if (this.running) {
            Logging.w(TAG, "already initialized!");
            return VideoCodecStatus.OK;
        }
        this.callback = callback;
        if (this.directSurface != null) {
            this.surface = this.directSurface;
        } else if (this.sharedContext != null) {
            this.surfaceTextureHelper = this.createSurfaceTextureHelper();
            if (this.surfaceTextureHelper == null) {
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            this.surface = new Surface(this.surfaceTextureHelper.getSurfaceTexture());
            this.surfaceTextureHelper.startListening(this);
        }
        return this.initDecodeInternal(settings.width, settings.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VideoCodecStatus initDecodeInternal(int width, int height) {
        VideoCodecStatus status;
        Logging.d(TAG, "initDecodeInternal");
        if (this.proxyThreadHandler == null) {
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        if (this.outputThread != null) {
            Logging.e(TAG, "initDecodeInternal called while the codec is already running");
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        if (this.surfaceTextureHelper != null) {
            try {
                this.surfaceTextureHelper.setTextureSize(width, height);
            }
            catch (IllegalArgumentException ex) {
                Logging.e(TAG, "setTextureSize:", ex);
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
        }
        this.width = width;
        this.height = height;
        this.stride = width;
        this.sliceHeight = height;
        this.hasDecodedFirstFrame = false;
        this.keyFrameRequired = true;
        this.decodeTimeStamps.clear();
        this.deliveredVideoFrame = false;
        this.shouldResetCodec = false;
        this.fallbackByCodecError = false;
        if (null != this.codecName && null != Build.HARDWARE && this.codecName.startsWith("OMX.hisi.") && Build.HARDWARE.startsWith("bigfish")) {
            this.isHisiCodec = true;
            Logging.d(TAG, " bigfish isHisiCodec: " + this.isHisiCodec);
        } else {
            this.isHisiCodec = false;
        }
        Callable<VideoCodecStatus> callable = new Callable<VideoCodecStatus>(){

            @Override
            public VideoCodecStatus call() throws Exception {
                VideoCodecStatus result = VideoCodecStatus.OK;
                try {
                    HardwareVideoDecoder.this.codec = HardwareVideoDecoder.this.mediaCodecWrapperFactory.createByCodecName(HardwareVideoDecoder.this.codecName);
                }
                catch (Exception e) {
                    Logging.e(HardwareVideoDecoder.TAG, "Cannot create media decoder " + HardwareVideoDecoder.this.codecName);
                    result = VideoCodecStatus.FALLBACK_SOFTWARE;
                }
                return result;
            }
        };
        try {
            status = ThreadUtils.invokeAtFrontUninterruptibly(this.proxyThreadHandler, 2000L, callable);
            if (status == null) {
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            if (status != VideoCodecStatus.OK) {
                return status;
            }
        }
        catch (Exception e) {
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        this.readVideoCapabilities();
        final MediaFormat format = MediaFormat.createVideoFormat((String)this.codecType.mimeType(), (int)width, (int)height);
        if (this.sharedContext == null && this.directSurface == null) {
            format.setInteger("color-format", this.colorFormat);
        }
        this.customConfigJson = this.params.get("av_dec_video_hwdec_config");
        MediaCodecUtils.applyCustomConfig(format, this.customConfigJson);
        callable = new Callable<VideoCodecStatus>(){

            @Override
            public VideoCodecStatus call() throws Exception {
                try {
                    HardwareVideoDecoder.this.codec.configure(format, HardwareVideoDecoder.this.surface, null, MediaCodecUtils.applyCustomFlags(HardwareVideoDecoder.this.customConfigJson));
                    HardwareVideoDecoder.this.codec.start();
                }
                catch (Throwable t) {
                    Logging.e(HardwareVideoDecoder.TAG, "initDecode failed" + t.getMessage());
                    HardwareVideoDecoder.this.release();
                    return VideoCodecStatus.FALLBACK_SOFTWARE;
                }
                return VideoCodecStatus.OK;
            }
        };
        try {
            status = ThreadUtils.invokeAtFrontUninterruptibly(this.proxyThreadHandler, 2000L, callable);
            if (status == null) {
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            if (status != VideoCodecStatus.OK) {
                return status;
            }
        }
        catch (Exception e) {
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        Object object = this.textureMetadataLock;
        synchronized (object) {
            this.dequeuedSurfaceOutputBuffers.clear();
        }
        this.running = true;
        this.outputThread = this.createOutputThread();
        this.outputThread.start();
        Logging.w(TAG, "initDecodeInternal " + this.codecType.mimeType() + " done, format: " + format);
        return VideoCodecStatus.OK;
    }

    private void readVideoCapabilities() {
        Range heights;
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        MediaCodecInfo.CodecCapabilities codecCapabilities = null;
        try {
            codecCapabilities = this.codec.getCodecInfo(this.codecType.mimeType());
        }
        catch (Exception e) {
            Logging.e(TAG, "Cannot get CodecInfo " + this.codecName);
        }
        if (codecCapabilities == null) {
            return;
        }
        MediaCodecInfo.VideoCapabilities videoCapabilities = codecCapabilities.getVideoCapabilities();
        if (videoCapabilities == null) {
            return;
        }
        Range widths = videoCapabilities.getSupportedWidths();
        int maxSupportedWidth = 0;
        int minSupportedWidth = 0;
        int maxSupportedHeight = 0;
        int minSupportedHeight = 0;
        if (widths != null) {
            maxSupportedWidth = (Integer)widths.getUpper();
            minSupportedWidth = (Integer)widths.getLower();
        }
        if ((heights = videoCapabilities.getSupportedHeights()) != null) {
            maxSupportedHeight = (Integer)heights.getUpper();
            minSupportedHeight = (Integer)heights.getLower();
        }
        Logging.d(TAG, this.codecType.mimeType() + "  max supported size:" + maxSupportedWidth + "x" + maxSupportedHeight + " min supported size:" + minSupportedWidth + "x" + minSupportedHeight);
        if (Build.VERSION.SDK_INT >= 23) {
            Logging.d(TAG, "max supported instance: " + codecCapabilities.getMaxSupportedInstances());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VideoCodecStatus decode(final EncodedImage frame, VideoDecoder.DecodeInfo info, final CodecSpecificInfo codecSpecificInfo) {
        VideoCodecStatus status;
        int height;
        int width;
        if (this.codec == null || this.callback == null || this.proxyThreadHandler == null || !this.running) {
            Logging.d(TAG, "decode uninitalized, codec: " + (this.codec != null) + ", callback: " + this.callback);
            return VideoCodecStatus.UNINITIALIZED;
        }
        if (frame.buffer == null) {
            Logging.e(TAG, "decode() - no input data");
            return VideoCodecStatus.ERR_PARAMETER;
        }
        final int size = frame.buffer.remaining();
        if (size == 0) {
            Logging.e(TAG, "decode() - input buffer empty");
            return VideoCodecStatus.ERR_PARAMETER;
        }
        Object object = this.dimensionLock;
        synchronized (object) {
            width = this.width;
            height = this.height;
        }
        if ((frame.encodedWidth * frame.encodedHeight > 0 && (frame.encodedWidth != width || frame.encodedHeight != height) || this.shouldResetCodec) && (status = this.reinitDecode(frame.encodedWidth, frame.encodedHeight)) != VideoCodecStatus.OK) {
            return status;
        }
        if (this.fallbackByCodecError) {
            this.release();
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        if (this.keyFrameRequired) {
            if (frame.frameType != EncodedImage.FrameType.VideoFrameKey) {
                Logging.e(TAG, "decode() - key frame required first");
                return VideoCodecStatus.NO_OUTPUT;
            }
            if (!frame.completeFrame) {
                Logging.e(TAG, "decode() - complete frame required first");
                return VideoCodecStatus.NO_OUTPUT;
            }
        }
        Callable<VideoCodecStatus> callable = new Callable<VideoCodecStatus>(){

            @Override
            public VideoCodecStatus call() throws Exception {
                ByteBuffer buffer;
                int index;
                try {
                    index = HardwareVideoDecoder.this.codec.dequeueInputBuffer(500000L);
                }
                catch (IllegalStateException e) {
                    Logging.e(HardwareVideoDecoder.TAG, "dequeueInputBuffer failed", e);
                    if (!HardwareVideoDecoder.this.deliveredVideoFrame) {
                        return VideoCodecStatus.FALLBACK_SOFTWARE;
                    }
                    return MediaCodecUtils.isMediaCodecException(e);
                }
                if (index < 0) {
                    Logging.e(HardwareVideoDecoder.TAG, "decode() - no HW buffers available; decoder falling behind");
                    return VideoCodecStatus.ERROR;
                }
                try {
                    buffer = HardwareVideoDecoder.this.codec.getInputBuffers()[index];
                }
                catch (IllegalStateException e) {
                    Logging.e(HardwareVideoDecoder.TAG, "getInputBuffers failed", e);
                    if (!HardwareVideoDecoder.this.deliveredVideoFrame) {
                        return VideoCodecStatus.FALLBACK_SOFTWARE;
                    }
                    return MediaCodecUtils.isMediaCodecException(e);
                }
                if (buffer.capacity() < size) {
                    Logging.e(HardwareVideoDecoder.TAG, "decode() - HW buffer too small");
                    return VideoCodecStatus.ERROR;
                }
                buffer.put(frame.buffer);
                HardwareVideoDecoder.this.frameInfos.offer(new FrameInfo(SystemClock.elapsedRealtime(), frame.rotation));
                long presentationTimeUs = TimeUnit.NANOSECONDS.toMicros(frame.captureTimeNs);
                try {
                    if (codecSpecificInfo != null) {
                        HardwareVideoDecoder.this.codecSpecificInfoMap.put(presentationTimeUs, codecSpecificInfo);
                    }
                    TimeStamps timeStamps = new TimeStamps(SystemClock.elapsedRealtime(), presentationTimeUs);
                    HardwareVideoDecoder.this.decodeTimeStamps.add(timeStamps);
                    HardwareVideoDecoder.debug_log("queue input buffer, pts_us: " + timeStamps.presentationTimeStampUs);
                    HardwareVideoDecoder.this.codec.queueInputBuffer(index, 0, size, presentationTimeUs, 0);
                }
                catch (RuntimeException e) {
                    Logging.e(HardwareVideoDecoder.TAG, "queueInputBuffer failed", e);
                    HardwareVideoDecoder.this.frameInfos.pollLast();
                    HardwareVideoDecoder.this.codecSpecificInfoMap.remove(presentationTimeUs);
                    if (!HardwareVideoDecoder.this.deliveredVideoFrame) {
                        return VideoCodecStatus.FALLBACK_SOFTWARE;
                    }
                    return MediaCodecUtils.isMediaCodecException(e);
                }
                if (HardwareVideoDecoder.this.keyFrameRequired) {
                    HardwareVideoDecoder.this.keyFrameRequired = false;
                }
                return VideoCodecStatus.OK;
            }
        };
        try {
            VideoCodecStatus status2 = ThreadUtils.invokeAtFrontUninterruptibly(this.proxyThreadHandler, 2000L, callable);
            if (status2 == null) {
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            return status2;
        }
        catch (Exception e) {
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
    }

    @Override
    public boolean getPrefersLateDecoding() {
        return true;
    }

    @Override
    public String getImplementationName() {
        return "HWDecoder";
    }

    @Override
    public long createNativeVideoDecoder() {
        return 0L;
    }

    @Override
    public boolean isHardwareDecoder() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VideoCodecStatus release() {
        Logging.d(TAG, "release");
        VideoCodecStatus status = this.releaseInternal();
        if (this.surface != null && this.directSurface == null) {
            this.releaseSurface();
            this.surface = null;
            this.surfaceTextureHelper.stopListening();
            this.surfaceTextureHelper.dispose();
            this.surfaceTextureHelper = null;
        }
        Object object = this.textureMetadataLock;
        synchronized (object) {
            this.renderedTextureMetadata = null;
        }
        this.callback = null;
        this.deliveredVideoFrame = false;
        this.shouldResetCodec = false;
        this.fallbackByCodecError = false;
        this.frameInfos.clear();
        this.decodeTimeStamps.clear();
        return status;
    }

    @Override
    public VideoCodecStatus detachProxyThread() {
        if (this.proxyThreadHandler != null) {
            this.proxyThreadHandler.removeCallbacksAndMessages(null);
            this.proxyThreadHandler.getLooper().quitSafely();
            this.proxyThreadHandler = null;
        }
        return VideoCodecStatus.OK;
    }

    private VideoCodecStatus releaseInternal() {
        if (!this.running) {
            Logging.d(TAG, "release: Decoder is not running.");
            return VideoCodecStatus.OK;
        }
        try {
            this.running = false;
            if (!ThreadUtils.joinUninterruptibly(this.outputThread, 5000L)) {
                Logging.e(TAG, "Media decoder release timeout", new RuntimeException());
                VideoCodecStatus videoCodecStatus = VideoCodecStatus.TIMEOUT;
                return videoCodecStatus;
            }
            if (this.shutdownException != null) {
                Logging.e(TAG, "Media decoder release error", new RuntimeException(this.shutdownException));
                this.shutdownException = null;
                VideoCodecStatus videoCodecStatus = VideoCodecStatus.ERROR;
                return videoCodecStatus;
            }
        }
        finally {
            this.codec = null;
            this.outputThread = null;
        }
        return VideoCodecStatus.OK;
    }

    private VideoCodecStatus reinitDecode(int newWidth, int newHeight) {
        VideoCodecStatus status = this.releaseInternal();
        if (status != VideoCodecStatus.OK) {
            return status;
        }
        return this.initDecodeInternal(newWidth, newHeight);
    }

    private Thread createOutputThread() {
        return new Thread("HardwareVideoDecoder.outputThread"){

            @Override
            public void run() {
                HardwareVideoDecoder.this.outputThreadChecker = new ThreadUtils.ThreadChecker();
                while (HardwareVideoDecoder.this.running) {
                    HardwareVideoDecoder.this.deliverDecodedFrame();
                }
                HardwareVideoDecoder.this.releaseCodecOnOutputThread();
            }
        };
    }

    protected void deliverDecodedFrame() {
        this.outputThreadChecker.checkIsOnValidThread();
        try {
            MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
            int result = this.codec.dequeueOutputBuffer(info, 100000L);
            HardwareVideoDecoder.debug_log("dequeue output buffer, pts_us: " + info.presentationTimeUs + " result: " + result);
            if (result == -2) {
                this.reformat(this.codec.getOutputFormat());
                return;
            }
            if (result < 0) {
                Logging.v(TAG, "dequeueOutputBuffer returned " + result);
                return;
            }
            FrameInfo frameInfo = this.frameInfos.poll();
            Integer decodeTimeMs = null;
            int rotation = 0;
            if (frameInfo != null) {
                decodeTimeMs = (int)(SystemClock.elapsedRealtime() - frameInfo.decodeStartTimeMs);
                rotation = frameInfo.rotation;
            }
            this.hasDecodedFirstFrame = true;
            if (this.directSurface != null) {
                this.deliverToDirectSurface(result, info, rotation, decodeTimeMs);
            } else if (this.surfaceTextureHelper != null) {
                this.deliverTextureFrame(result, info, rotation, decodeTimeMs);
            } else {
                this.deliverByteFrame(result, info, rotation, decodeTimeMs);
            }
            this.deliveredVideoFrame = true;
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "deliverDecodedFrame failed", e);
            if (!this.deliveredVideoFrame) {
                this.fallbackByCodecError = true;
            } else if (MediaCodecUtils.isMediaCodecException(e) != VideoCodecStatus.ERROR) {
                this.fallbackByCodecError = true;
            } else {
                this.shouldResetCodec = true;
            }
        }
        catch (Exception e) {
            this.fallbackByCodecError = true;
            Logging.e(TAG, "deliverDecodedFrame error", e);
        }
    }

    private void deliverToDirectSurface(int index, MediaCodec.BufferInfo info, int rotation, Integer decodeTimeMs) {
        try {
            this.codec.releaseOutputBuffer(index, true);
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "deliverToDirectSurface failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverTextureFrame(int index, MediaCodec.BufferInfo info, int rotation, Integer decodeTimeMs) {
        int height;
        int width;
        Object object = this.dimensionLock;
        synchronized (object) {
            width = this.width;
            height = this.height;
        }
        DecodedTextureMetadata newFrame = new DecodedTextureMetadata(index, width, height, rotation, info.presentationTimeUs, decodeTimeMs);
        Object object2 = this.textureMetadataLock;
        synchronized (object2) {
            this.dequeuedSurfaceOutputBuffers.offer(newFrame);
            this.maybeRenderDecodedTextureBuffer();
            if (this.dequeuedSurfaceOutputBuffers.size() >= 3) {
                DecodedTextureMetadata droppedFrame = this.dequeuedSurfaceOutputBuffers.poll();
                HardwareVideoDecoder.debug_log("drop the oldest output frame in cache, pts_us: " + droppedFrame.presentationTimestampUs);
                try {
                    this.codec.releaseOutputBuffer(droppedFrame.outputBufferIndex, false);
                }
                catch (IllegalStateException e) {
                    Logging.e(TAG, "deliverTextureFrame failed", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFrame(VideoFrame frame) {
        CodecSpecificInfo codecSpecificInfo;
        int decodeTimeMs;
        long timestampNs;
        long presentationTimeUs;
        Object object = this.textureMetadataLock;
        synchronized (object) {
            if (this.renderedTextureMetadata == null) {
                throw new IllegalStateException("Rendered texture metadata was null in onTextureFrameAvailable.");
            }
            presentationTimeUs = this.renderedTextureMetadata.presentationTimestampUs;
            timestampNs = this.renderedTextureMetadata.presentationTimestampUs * 1000L;
            decodeTimeMs = this.renderedTextureMetadata.decodeTimeMs;
            codecSpecificInfo = this.codecSpecificInfoMap.remove(this.renderedTextureMetadata.presentationTimestampUs);
            this.renderedTextureMetadata = null;
            this.maybeRenderDecodedTextureBuffer();
        }
        VideoFrame frameWithModifiedTimeStamp = new VideoFrame(frame.getBuffer(), frame.getRotation(), timestampNs);
        TimeStamps timeStamps = null;
        int decodecDelayFrames = this.decodeTimeStamps.size();
        while (!this.decodeTimeStamps.isEmpty() && (timeStamps = this.decodeTimeStamps.poll()) != null && timeStamps.presentationTimeStampUs != presentationTimeUs) {
            Logging.d(TAG, "decodeTimeStamps remove: " + timeStamps.presentationTimeStampUs + " , cannot find presentationTimeUs: " + presentationTimeUs);
        }
        int decodecDelayTimeMs = -1;
        if (timeStamps == null) {
            Logging.e(TAG, "decodeTimeStamps empty. cannot find: " + presentationTimeUs);
        } else {
            decodecDelayTimeMs = (int)(SystemClock.elapsedRealtime() - timeStamps.decodeStartTimeMs);
            if (decodecDelayTimeMs > 2000) {
                Logging.w(TAG, "Very high decode time: " + decodecDelayTimeMs + "ms.");
                decodecDelayTimeMs = 2000;
            }
        }
        boolean directOes = false;
        if (codecSpecificInfo != null && codecSpecificInfo.getVideoCodecType() == VideoCodecType.H265 && (codecSpecificInfo.getVideoCodecProfile() == VideoCodecProfile.HEVCMain10 || codecSpecificInfo.getVideoCodecProfile() == VideoCodecProfile.HEVCMain10HDR10 || codecSpecificInfo.getVideoCodecProfile() == VideoCodecProfile.HEVCMain10HDR10Plus)) {
            directOes = true;
        }
        if (directOes) {
            VideoFrame decodedFrame = new VideoFrame(frameWithModifiedTimeStamp.getBuffer(), frameWithModifiedTimeStamp.getRotation(), frameWithModifiedTimeStamp.getTimestampNs());
            this.callback.onDecodedFrame(decodedFrame, decodeTimeMs, null, decodecDelayTimeMs, decodecDelayFrames, codecSpecificInfo);
            decodedFrame.release();
            HardwareVideoDecoder.debug_log("frame delivered to native by direct oes, pts_us: " + presentationTimeUs);
        } else {
            VideoFrame.TextureBuffer textureBufferCopy = this.surfaceTextureHelper.textureCopy((VideoFrame.TextureBuffer)frameWithModifiedTimeStamp.getBuffer());
            if (textureBufferCopy == null) {
                HardwareVideoDecoder.debug_log("failed to copy texture buffer, drop frame");
            } else {
                VideoFrame decodedFrame = new VideoFrame(textureBufferCopy, frameWithModifiedTimeStamp.getRotation(), frameWithModifiedTimeStamp.getTimestampNs());
                this.callback.onDecodedFrame(decodedFrame, decodeTimeMs, null, decodecDelayTimeMs, decodecDelayFrames, codecSpecificInfo);
                decodedFrame.release();
                HardwareVideoDecoder.debug_log("frame delivered to native, pts_us: " + presentationTimeUs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverByteFrame(int result, MediaCodec.BufferInfo info, int rotation, Integer decodeTimeMs) {
        int sliceHeight;
        int stride;
        int height;
        int width;
        Object object = this.dimensionLock;
        synchronized (object) {
            width = this.width;
            height = this.height;
            stride = this.stride;
            sliceHeight = this.sliceHeight;
        }
        if (info.size < width * height * 3 / 2) {
            Logging.e(TAG, "Insufficient output buffer size: " + info.size);
            return;
        }
        if (info.size < stride * height * 3 / 2 && sliceHeight == height && stride > width) {
            stride = info.size * 2 / (height * 3);
        }
        VideoFrame.Buffer frameBuffer = null;
        ByteBuffer buffer = null;
        try {
            buffer = this.codec.getOutputBuffers()[result];
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "getOutputBuffers failed", e);
        }
        buffer.position(info.offset);
        buffer.limit(info.offset + info.size);
        buffer = buffer.slice();
        frameBuffer = this.colorFormat == 19 ? this.copyI420Buffer(buffer, stride, sliceHeight, width, height) : (this.isHisiCodec && this.colorFormat == 39 ? this.copyNV21ToI420Buffer(buffer, stride, sliceHeight, width, height) : this.copyNV12ToI420Buffer(buffer, stride, sliceHeight, width, height));
        try {
            this.codec.releaseOutputBuffer(result, false);
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "deliverByteFrame failed", e);
        }
        catch (Exception e) {
            Logging.e(TAG, "deliverByteFrame error", e);
        }
        long presentationTimeNs = info.presentationTimeUs * 1000L;
        VideoFrame frame = new VideoFrame(frameBuffer, rotation, presentationTimeNs);
        CodecSpecificInfo codecSpecificInfo = this.codecSpecificInfoMap.remove(info.presentationTimeUs);
        TimeStamps timeStamps = null;
        int decodecDelayFrames = this.decodeTimeStamps.size();
        while (!this.decodeTimeStamps.isEmpty() && (timeStamps = this.decodeTimeStamps.poll()) != null && timeStamps.presentationTimeStampUs != info.presentationTimeUs) {
            Logging.d(TAG, "decodeTimeStamps remove: " + timeStamps.presentationTimeStampUs + " , cannot find presentationTimeUs: " + info.presentationTimeUs);
        }
        int decodecDelayTimeMs = -1;
        if (timeStamps == null) {
            Logging.e(TAG, "decodeTimeStamps empty. cannot find: " + info.presentationTimeUs);
        } else {
            decodecDelayTimeMs = (int)(SystemClock.elapsedRealtime() - timeStamps.decodeStartTimeMs);
            if (decodecDelayTimeMs > 2000) {
                Logging.w(TAG, "Very high decode time: " + decodecDelayTimeMs + "ms.");
                decodecDelayTimeMs = 2000;
            }
        }
        this.callback.onDecodedFrame(frame, decodeTimeMs, null, decodecDelayTimeMs, decodecDelayFrames, codecSpecificInfo);
        frame.release();
    }

    private VideoFrame.Buffer copyNV21ToI420Buffer(ByteBuffer buffer, int stride, int sliceHeight, int width, int height) {
        return new NV21Buffer(width, height, stride, sliceHeight, buffer, null).toI420();
    }

    private VideoFrame.Buffer copyNV12ToI420Buffer(ByteBuffer buffer, int stride, int sliceHeight, int width, int height) {
        return new NV12Buffer(width, height, stride, sliceHeight, buffer, null).toI420();
    }

    private VideoFrame.Buffer copyI420Buffer(ByteBuffer buffer, int stride, int sliceHeight, int width, int height) {
        if (stride % 2 != 0) {
            throw new AssertionError((Object)("Stride is not divisible by two: " + stride));
        }
        int chromaWidth = (width + 1) / 2;
        int chromaHeight = sliceHeight % 2 == 0 ? (height + 1) / 2 : height / 2;
        int uvStride = stride / 2;
        boolean yPos = false;
        int yEnd = 0 + stride * height;
        int uPos = 0 + stride * sliceHeight;
        int uEnd = uPos + uvStride * chromaHeight;
        int vPos = uPos + uvStride * sliceHeight / 2;
        int vEnd = vPos + uvStride * chromaHeight;
        VideoFrame.I420Buffer frameBuffer = this.allocateI420Buffer(width, height);
        buffer.limit(yEnd);
        buffer.position(0);
        this.copyPlane(buffer.slice(), stride, frameBuffer.getDataY(), frameBuffer.getStrideY(), width, height);
        buffer.limit(uEnd);
        buffer.position(uPos);
        this.copyPlane(buffer.slice(), uvStride, frameBuffer.getDataU(), frameBuffer.getStrideU(), chromaWidth, chromaHeight);
        if (sliceHeight % 2 == 1) {
            buffer.position(uPos + uvStride * (chromaHeight - 1));
            ByteBuffer dataU = frameBuffer.getDataU();
            dataU.position(frameBuffer.getStrideU() * chromaHeight);
            dataU.put(buffer);
        }
        buffer.limit(vEnd);
        buffer.position(vPos);
        this.copyPlane(buffer.slice(), uvStride, frameBuffer.getDataV(), frameBuffer.getStrideV(), chromaWidth, chromaHeight);
        if (sliceHeight % 2 == 1) {
            buffer.position(vPos + uvStride * (chromaHeight - 1));
            ByteBuffer dataV = frameBuffer.getDataV();
            dataV.position(frameBuffer.getStrideV() * chromaHeight);
            dataV.put(buffer);
        }
        return frameBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reformat(MediaFormat format) {
        int newHeight;
        int newWidth;
        this.outputThreadChecker.checkIsOnValidThread();
        Logging.d(TAG, "Decoder format changed: " + format.toString());
        if (format.containsKey(MEDIA_FORMAT_KEY_CROP_LEFT) && format.containsKey(MEDIA_FORMAT_KEY_CROP_RIGHT) && format.containsKey(MEDIA_FORMAT_KEY_CROP_BOTTOM) && format.containsKey(MEDIA_FORMAT_KEY_CROP_TOP)) {
            newWidth = 1 + format.getInteger(MEDIA_FORMAT_KEY_CROP_RIGHT) - format.getInteger(MEDIA_FORMAT_KEY_CROP_LEFT);
            newHeight = 1 + format.getInteger(MEDIA_FORMAT_KEY_CROP_BOTTOM) - format.getInteger(MEDIA_FORMAT_KEY_CROP_TOP);
        } else {
            newWidth = format.getInteger("width");
            newHeight = format.getInteger("height");
        }
        Object object = this.dimensionLock;
        synchronized (object) {
            if (this.hasDecodedFirstFrame && (this.width != newWidth || this.height != newHeight)) {
                this.stopOnOutputThread(new RuntimeException("Unexpected size change. Configured " + this.width + "*" + this.height + ". New " + newWidth + "*" + newHeight));
                return;
            }
            this.width = newWidth;
            this.height = newHeight;
        }
        if (this.surfaceTextureHelper == null && this.directSurface == null && format.containsKey("color-format")) {
            int color_format = format.getInteger("color-format");
            Logging.d(TAG, "reformat, Color: 0x" + Integer.toHexString(color_format));
            this.colorFormat = this.isHisiCodec && color_format == 47 && Build.VERSION.SDK_INT >= 21 ? 39 : color_format;
            if (!this.isSupportedColorFormat(this.colorFormat)) {
                this.stopOnOutputThread(new IllegalStateException("Unsupported color format: " + this.colorFormat));
                return;
            }
        }
        Object object2 = this.dimensionLock;
        synchronized (object2) {
            if (format.containsKey(MEDIA_FORMAT_KEY_STRIDE)) {
                this.stride = format.getInteger(MEDIA_FORMAT_KEY_STRIDE);
            }
            if (format.containsKey(MEDIA_FORMAT_KEY_SLICE_HEIGHT)) {
                this.sliceHeight = format.getInteger(MEDIA_FORMAT_KEY_SLICE_HEIGHT);
            }
            Logging.d(TAG, "Frame stride and slice height: " + this.stride + " x " + this.sliceHeight);
            this.stride = Math.max(this.width, this.stride);
            this.sliceHeight = Math.max(this.height, this.sliceHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseCodecOnOutputThread() {
        this.outputThreadChecker.checkIsOnValidThread();
        Logging.d(TAG, "Releasing MediaCodec on output thread");
        try {
            this.codec.stop();
        }
        catch (Exception e) {
            Logging.e(TAG, "Media decoder stop failed", e);
        }
        try {
            this.codec.release();
        }
        catch (Exception e) {
            Logging.e(TAG, "Media decoder release failed", e);
            this.shutdownException = e;
        }
        Object object = this.textureMetadataLock;
        synchronized (object) {
            this.dequeuedSurfaceOutputBuffers.clear();
        }
        Logging.d(TAG, "Release on output thread done");
    }

    private void stopOnOutputThread(Exception e) {
        this.outputThreadChecker.checkIsOnValidThread();
        this.running = false;
        this.shutdownException = e;
    }

    private boolean isSupportedColorFormat(int colorFormat) {
        for (int supported : MediaCodecUtils.DECODER_COLOR_FORMATS) {
            if (supported != colorFormat) continue;
            return true;
        }
        return false;
    }

    private boolean isSupportedColorFormatHDR(int colorFormat) {
        for (int supported : MediaCodecUtils.DECODER_COLOR_FORMATS_HDR) {
            if (supported != colorFormat) continue;
            return true;
        }
        return false;
    }

    private void maybeRenderDecodedTextureBuffer() {
        if (this.renderedTextureMetadata != null) {
            return;
        }
        if (!this.running) {
            Logging.d(TAG, "RenderTexture: Decoder is not running.");
            return;
        }
        DecodedTextureMetadata renderFrame = this.dequeuedSurfaceOutputBuffers.poll();
        if (renderFrame == null) {
            return;
        }
        this.surfaceTextureHelper.setFrameRotation(renderFrame.rotation);
        this.renderedTextureMetadata = renderFrame;
        HardwareVideoDecoder.debug_log("render output buffer to surface, pts_us: " + renderFrame.presentationTimestampUs);
        try {
            this.codec.releaseOutputBuffer(renderFrame.outputBufferIndex, true);
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "deliverToDirectSurface failed", e);
        }
        catch (Exception e) {
            Logging.e(TAG, "deliverToDirectSurface error", e);
        }
    }

    @Nullable
    protected SurfaceTextureHelper createSurfaceTextureHelper() {
        return SurfaceTextureHelper.create("decoder-texture-thread", this.sharedContext, 16);
    }

    protected void releaseSurface() {
        this.surface.release();
    }

    protected VideoFrame.I420Buffer allocateI420Buffer(int width, int height) {
        return JavaI420Buffer.allocate(width, height);
    }

    protected void copyPlane(ByteBuffer src, int srcStride, ByteBuffer dst, int dstStride, int width, int height) {
        YuvHelper.copyPlane(src, srcStride, dst, dstStride, width, height);
    }

    private static final void debug_log(String log) {
    }

    private static class DecodedTextureMetadata {
        final int outputBufferIndex;
        final int width;
        final int height;
        final int rotation;
        final long presentationTimestampUs;
        final Integer decodeTimeMs;

        DecodedTextureMetadata(int outputBufferIndex, int width, int height, int rotation, long presentationTimestampUs, Integer decodeTimeMs) {
            this.outputBufferIndex = outputBufferIndex;
            this.width = width;
            this.height = height;
            this.rotation = rotation;
            this.presentationTimestampUs = presentationTimestampUs;
            this.decodeTimeMs = decodeTimeMs;
        }
    }

    private static class TimeStamps {
        private final long decodeStartTimeMs;
        private final long presentationTimeStampUs;

        public TimeStamps(long decodeStartTimeMs, long presentationTimeStampUs) {
            this.decodeStartTimeMs = decodeStartTimeMs;
            this.presentationTimeStampUs = presentationTimeStampUs;
        }
    }

    private static class FrameInfo {
        final long decodeStartTimeMs;
        final int rotation;

        FrameInfo(long decodeStartTimeMs, int rotation) {
            this.decodeStartTimeMs = decodeStartTimeMs;
            this.rotation = rotation;
        }
    }
}

