/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.agora.base.TextureBuffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.EglBaseFactory;
import io.agora.base.internal.video.GlUtil;
import io.agora.base.internal.video.IHandlerReplaceable;
import io.agora.base.internal.video.ISurfaceTextureHelper;
import io.agora.base.internal.video.RendererCommon;
import io.agora.base.internal.video.TextureBufferPool;
import io.agora.base.internal.video.VideoSink;
import io.agora.base.internal.video.YuvConverter;
import java.util.concurrent.Callable;

public class SurfaceTextureHelper
implements ISurfaceTextureHelper {
    private static final String TAG = "SurfaceTextureHelper";
    private static final int DEFAULT_MAX_BUFFER_COUNT = 4;
    private final String name;
    private final Handler handler;
    private final EglBase eglBase;
    @NonNull
    private final EglBase.Context sharedContext;
    private final SurfaceTexture surfaceTexture;
    private final int oesTextureId;
    private final YuvConverter yuvConverter = new YuvConverter();
    private final TextureBufferPool textureBufferPool;
    @Nullable
    private VideoSink listener;
    private boolean hasPendingTexture = false;
    private volatile boolean isOesTextureInUse = false;
    private boolean isQuitting = false;
    private int frameRotation;
    private int textureWidth;
    private int textureHeight;
    @Nullable
    private VideoSink pendingListener;
    final Runnable setListenerRunnable = new Runnable(){

        @Override
        public void run() {
            Logging.d(SurfaceTextureHelper.TAG, "Setting listener to " + SurfaceTextureHelper.this.pendingListener);
            SurfaceTextureHelper.this.listener = SurfaceTextureHelper.this.pendingListener;
            SurfaceTextureHelper.this.pendingListener = null;
            if (SurfaceTextureHelper.this.hasPendingTexture) {
                SurfaceTextureHelper.this.updateTexImage();
                SurfaceTextureHelper.this.hasPendingTexture = false;
            }
        }
    };
    private static final int ANDROID_API_TEXTURE_IN_USE = 10;

    @Nullable
    public static SurfaceTextureHelper create(String threadName, EglBase.Context sharedContext) {
        return SurfaceTextureHelper.create(threadName, sharedContext, 4);
    }

    @Nullable
    public static SurfaceTextureHelper create(final String threadName, final EglBase.Context sharedContext, final int maxBufCount) {
        HandlerThread thread = new HandlerThread(threadName);
        thread.start();
        final Handler handler = new Handler(thread.getLooper());
        try {
            return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<SurfaceTextureHelper>(){

                @Override
                @Nullable
                public SurfaceTextureHelper call() {
                    try {
                        return new SurfaceTextureHelper(threadName, sharedContext, handler, maxBufCount);
                    }
                    catch (RuntimeException e) {
                        Logging.e(SurfaceTextureHelper.TAG, threadName + " create failure", e);
                        return null;
                    }
                }
            });
        }
        catch (Exception e) {
            Logging.e(TAG, threadName + " create failure", e);
            return null;
        }
    }

    private SurfaceTextureHelper(String name, EglBase.Context sharedContext, Handler handler, int maxBufCount) {
        if (handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("SurfaceTextureHelper must be created on the handler thread");
        }
        this.name = name;
        this.handler = handler;
        this.eglBase = EglBaseFactory.create(sharedContext, EglBase.CONFIG_PIXEL_BUFFER);
        try {
            this.eglBase.createDummyPbufferSurface();
            this.eglBase.makeCurrent();
        }
        catch (RuntimeException e) {
            this.eglBase.release();
            handler.getLooper().quit();
            throw e;
        }
        this.sharedContext = sharedContext != null ? sharedContext : this.eglBase.getEglBaseContext();
        this.textureBufferPool = TextureBufferPool.createWithinGlThread(name, maxBufCount, 6407, handler, this.eglBase, sharedContext, this.yuvConverter);
        this.oesTextureId = GlUtil.generateTexture(36197);
        this.surfaceTexture = new SurfaceTexture(this.oesTextureId);
        SurfaceTextureHelper.setOnFrameAvailableListener(this.surfaceTexture, new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture st) {
                SurfaceTextureHelper.this.hasPendingTexture = true;
                SurfaceTextureHelper.this.tryDeliverTextureFrame();
            }
        }, handler);
    }

    @TargetApi(value=21)
    private static void setOnFrameAvailableListener(SurfaceTexture surfaceTexture, SurfaceTexture.OnFrameAvailableListener listener, Handler handler) {
        if (Build.VERSION.SDK_INT >= 21) {
            surfaceTexture.setOnFrameAvailableListener(listener, handler);
        } else {
            surfaceTexture.setOnFrameAvailableListener(listener);
        }
    }

    @Override
    public void startListening(VideoSink listener) {
        if (this.listener != null || this.pendingListener != null) {
            throw new IllegalStateException("SurfaceTextureHelper listener has already been set.");
        }
        this.pendingListener = listener;
        this.handler.post(this.setListenerRunnable);
    }

    @Override
    public void stopListening() {
        Logging.d(TAG, "stopListening()");
        this.handler.removeCallbacks(this.setListenerRunnable);
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

            @Override
            public void run() {
                SurfaceTextureHelper.this.listener = null;
                SurfaceTextureHelper.this.pendingListener = null;
            }
        });
    }

    @Override
    public void setTextureSize(final int textureWidth, final int textureHeight) {
        if (textureWidth <= 0) {
            throw new IllegalArgumentException("Texture width must be positive, but was " + textureWidth);
        }
        if (textureHeight <= 0) {
            throw new IllegalArgumentException("Texture height must be positive, but was " + textureHeight);
        }
        this.surfaceTexture.setDefaultBufferSize(textureWidth, textureHeight);
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                SurfaceTextureHelper.this.textureWidth = textureWidth;
                SurfaceTextureHelper.this.textureHeight = textureHeight;
            }
        });
    }

    @Override
    public void setFrameRotation(final int rotation) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                SurfaceTextureHelper.this.frameRotation = rotation;
            }
        });
    }

    @Override
    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    @Override
    public Handler getHandler() {
        return this.handler;
    }

    private void returnTextureFrame() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                SurfaceTextureHelper.this.isOesTextureInUse = false;
                if (SurfaceTextureHelper.this.isQuitting) {
                    if (!SurfaceTextureHelper.this.textureBufferPool.anyTextureInUse()) {
                        SurfaceTextureHelper.this.release();
                    }
                } else {
                    SurfaceTextureHelper.this.tryDeliverTextureFrame();
                }
            }
        });
    }

    @Override
    public boolean isOesTextureInUse() {
        return this.isOesTextureInUse;
    }

    @Override
    public void dispose() {
        Logging.d(TAG, "dispose()");
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

            @Override
            public void run() {
                SurfaceTextureHelper.this.isQuitting = true;
                if (!SurfaceTextureHelper.this.isOesTextureInUse && !SurfaceTextureHelper.this.textureBufferPool.anyTextureInUse()) {
                    SurfaceTextureHelper.this.release();
                } else {
                    Logging.d(SurfaceTextureHelper.TAG, SurfaceTextureHelper.this.name + " not release yet, this: " + SurfaceTextureHelper.this + " isOesTextureInUse: " + SurfaceTextureHelper.this.isOesTextureInUse);
                }
            }
        });
    }

    @Deprecated
    public VideoFrame.I420Buffer textureToYuv(VideoFrame.TextureBuffer textureBuffer) {
        return textureBuffer.toI420();
    }

    @Nullable
    public VideoFrame.TextureBuffer textureCopy(final VideoFrame.TextureBuffer textureBuffer) {
        if (textureBuffer == null) {
            Logging.w(TAG, "textureCopy: " + this.name + " textureBuffer is null, IllegalStateException");
            throw new IllegalStateException("textureCopy called unexpected with textureBuffer is null");
        }
        if (this.handler == null || ((IHandlerReplaceable)((Object)textureBuffer)).getToI420Handler() == null) {
            Logging.w(TAG, "textureCopy: " + this.name + " handler is null, IllegalStateException");
            throw new IllegalStateException("textureCopy called unexpected with handler is null");
        }
        return ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Callable<VideoFrame.TextureBuffer>(){

            @Override
            public VideoFrame.TextureBuffer call() throws Exception {
                return SurfaceTextureHelper.this.textureBufferPool.textureCopy(textureBuffer, new Runnable(){

                    @Override
                    public void run() {
                        SurfaceTextureHelper.this.handler.post(new Runnable(){

                            @Override
                            public void run() {
                                if (SurfaceTextureHelper.this.isQuitting && !SurfaceTextureHelper.this.isOesTextureInUse && !SurfaceTextureHelper.this.textureBufferPool.anyTextureInUse()) {
                                    SurfaceTextureHelper.this.release();
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTexImage() {
        try {
            Object object = EglBase.lock;
            synchronized (object) {
                this.surfaceTexture.updateTexImage();
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "failed to updateTexImage. " + e.getMessage());
        }
    }

    private void tryDeliverTextureFrame() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.isQuitting || !this.hasPendingTexture || this.listener == null) {
            return;
        }
        if (this.isOesTextureInUse) {
            if (this.listener instanceof IVideoCapture) {
                ((IVideoCapture)this.listener).onFrameDropped(10);
            }
            return;
        }
        this.isOesTextureInUse = true;
        this.hasPendingTexture = false;
        this.updateTexImage();
        float[] transformMatrix = new float[16];
        this.surfaceTexture.getTransformMatrix(transformMatrix);
        long timestampNs = this.surfaceTexture.getTimestamp();
        if (this.textureWidth == 0 || this.textureHeight == 0) {
            throw new RuntimeException("Texture size has not been set.");
        }
        TextureBuffer buffer = new TextureBuffer(this.sharedContext, this.textureWidth, this.textureHeight, VideoFrame.TextureBuffer.Type.OES, this.oesTextureId, RendererCommon.convertMatrixToAndroidGraphicsMatrix(transformMatrix), this.handler, this.yuvConverter, new Runnable(){

            @Override
            public void run() {
                SurfaceTextureHelper.this.returnTextureFrame();
            }
        });
        VideoFrame frame = new VideoFrame(buffer, this.frameRotation, timestampNs);
        this.listener.onFrame(frame);
        frame.release();
    }

    private void release() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.isOesTextureInUse || this.textureBufferPool.anyTextureInUse() || !this.isQuitting) {
            throw new IllegalStateException("Unexpected release.");
        }
        this.yuvConverter.release();
        this.textureBufferPool.dispose();
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.oesTextureId}, (int)0);
        this.surfaceTexture.release();
        this.eglBase.release();
        this.handler.getLooper().quit();
    }

    public static interface IVideoCapture
    extends VideoSink {
        public void onFrameDropped(int var1);
    }
}

