/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.voiceengine;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioRecordingConfiguration;
import android.media.AudioTrack;
import android.os.Build;
import android.telephony.TelephonyManager;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.agora.base.internal.ContextUtils;
import io.agora.base.internal.Logging;
import io.agora.base.internal.voiceengine.WebRtcAudioEffects;
import io.agora.base.internal.voiceengine.WebRtcAudioUtils;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class WebRtcAudioManager {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioManager";
    private static final boolean blacklistDeviceForAAudioUsage = true;
    private static boolean useStereoOutput = true;
    private static boolean useStereoInput = false;
    private static boolean blacklistDeviceForOpenSLESUsage = false;
    private static boolean blacklistDeviceForOpenSLESUsageIsOverridden = false;
    private final Object volumeListenerLock = new Object();
    @Nullable
    private AudioAttributes custAudioAttr = null;
    private static final int BITS_PER_SAMPLE = 16;
    private static final int DEFAULT_FRAME_PER_BUFFER = 256;
    private final long nativeAudioManager;
    private final AudioManager audioManager;
    @Nullable
    private final TelephonyManager telephonyManager;
    private boolean initialized = false;
    private int nativeSampleRate;
    private int nativeChannels;
    private int mBufferPeriodMs = 10;
    private boolean hardwareAEC;
    private boolean hardwareAGC;
    private boolean hardwareNS;
    private boolean lowLatencyOutput;
    private boolean lowLatencyInput;
    private boolean proAudio;
    private boolean aAudio;
    private int sampleRate;
    private int outputChannels;
    private int inputChannels;
    private int outputBufferSize;
    private int inputBufferSize;
    private static AudioManager mockedAudioManager;
    @Nullable
    private VolumeChangeReceiver mVolumeChangeReceiver = null;
    private int playoutVolume = 0;

    public static synchronized void setBlacklistDeviceForOpenSLESUsage(boolean enable) {
        blacklistDeviceForOpenSLESUsageIsOverridden = true;
        blacklistDeviceForOpenSLESUsage = enable;
    }

    public static synchronized void setStereoOutput(boolean enable) {
        Logging.w(TAG, "Overriding default output behavior: setStereoOutput(" + enable + ')');
        useStereoOutput = enable;
    }

    public static synchronized void setStereoInput(boolean enable) {
        Logging.w(TAG, "Overriding default input behavior: setStereoInput(" + enable + ')');
        useStereoInput = enable;
    }

    public static synchronized boolean getStereoOutput() {
        return useStereoOutput;
    }

    public static synchronized boolean getStereoInput() {
        return useStereoInput;
    }

    @VisibleForTesting
    public static void setMockedAudioManager(AudioManager mockedAudioManager) {
        WebRtcAudioManager.mockedAudioManager = mockedAudioManager;
    }

    WebRtcAudioManager(long nativeAudioManager, int bufferPeriodMs) {
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo() + ", this " + this);
        this.nativeAudioManager = nativeAudioManager;
        this.mBufferPeriodMs = bufferPeriodMs;
        Logging.w(TAG, "bufferPeriodMs is: " + this.mBufferPeriodMs);
        if (mockedAudioManager != null) {
            this.audioManager = mockedAudioManager;
            this.telephonyManager = null;
        } else {
            this.audioManager = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
            this.telephonyManager = (TelephonyManager)ContextUtils.getApplicationContext().getSystemService("phone");
        }
        this.storeAudioParameters();
        this.nativeCacheAudioParameters(this.sampleRate, this.outputChannels, this.inputChannels, this.hardwareAEC, this.hardwareAGC, this.hardwareNS, this.lowLatencyOutput, this.lowLatencyInput, this.proAudio, this.aAudio, this.outputBufferSize, this.inputBufferSize, bufferPeriodMs, nativeAudioManager);
        WebRtcAudioUtils.logAudioState(TAG);
    }

    private boolean init() {
        Logging.d(TAG, "init" + WebRtcAudioUtils.getThreadInfo());
        if (this.initialized) {
            return true;
        }
        Logging.d(TAG, "audio mode is: " + WebRtcAudioUtils.modeToString(this.audioManager.getMode()));
        this.initialized = true;
        return true;
    }

    private void dispose() {
        Logging.d(TAG, "dispose" + WebRtcAudioUtils.getThreadInfo());
        if (!this.initialized) {
            return;
        }
    }

    private boolean isCommunicationModeEnabled() {
        return this.audioManager.getMode() == 3;
    }

    private boolean isDeviceBlacklistedForOpenSLESUsage() {
        boolean blacklisted;
        boolean bl = blacklisted = blacklistDeviceForOpenSLESUsageIsOverridden ? blacklistDeviceForOpenSLESUsage : WebRtcAudioUtils.deviceIsBlacklistedForOpenSLESUsage();
        if (blacklisted) {
            Logging.d(TAG, Build.MODEL + " is blacklisted for OpenSL ES usage!");
        }
        return blacklisted;
    }

    private boolean enableChatMode(boolean enable) {
        WebRtcAudioManager.assertTrue(this.audioManager != null);
        int audio_mode = enable ? 3 : 0;
        try {
            int curr_mode = this.audioManager.getMode();
            Logging.d(TAG, "set audio mode to: " + WebRtcAudioUtils.modeToString(audio_mode) + " curr: " + WebRtcAudioUtils.modeToString(curr_mode));
            this.audioManager.setMode(audio_mode);
        }
        catch (Exception e) {
            Logging.e(TAG, "audioManager.setMode failed: " + e.getMessage());
        }
        return true;
    }

    private boolean getChatMode() {
        WebRtcAudioManager.assertTrue(this.audioManager != null);
        int audio_mode = this.audioManager.getMode();
        Logging.d(TAG, "current audio mode: " + WebRtcAudioUtils.modeToString(audio_mode));
        return audio_mode == 3;
    }

    private int getCallState() {
        if (mockedAudioManager != null) {
            Logging.d(TAG, "mock call state: " + mockedAudioManager.getRingerMode());
            return mockedAudioManager.getRingerMode();
        }
        Context context = ContextUtils.getApplicationContext();
        if (this.telephonyManager != null && context.checkCallingOrSelfPermission("android.permission.READ_PHONE_STATE") == 0) {
            return this.telephonyManager.getCallState();
        }
        return this.audioManager.getMode() == 2 || this.audioManager.getMode() == 1 ? 2 : 0;
    }

    private void storeAudioParameters() {
        this.outputChannels = WebRtcAudioManager.getStereoOutput() ? 2 : 1;
        this.inputChannels = WebRtcAudioManager.getStereoInput() ? 2 : 1;
        this.sampleRate = this.getNativeOutputSampleRate();
        this.hardwareAEC = WebRtcAudioManager.isAcousticEchoCancelerSupported();
        this.hardwareAGC = false;
        this.hardwareNS = WebRtcAudioManager.isNoiseSuppressorSupported();
        this.lowLatencyOutput = this.isLowLatencyOutputSupported();
        this.lowLatencyInput = this.isLowLatencyInputSupported();
        this.proAudio = this.isProAudioSupported();
        this.aAudio = this.isAAudioSupported();
        this.outputBufferSize = this.getBufferSizeByPeriod(this.sampleRate, this.mBufferPeriodMs);
        this.inputBufferSize = this.getBufferSizeByPeriod(this.sampleRate, this.mBufferPeriodMs);
    }

    private int getBufferSizeByPeriod(int sampleRate, int bufferPeriodMs) {
        return sampleRate / 1000 * bufferPeriodMs;
    }

    private boolean hasEarpiece() {
        return ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    private boolean isLowLatencyOutputSupported() {
        return ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
    }

    public boolean isLowLatencyInputSupported() {
        return WebRtcAudioUtils.runningOnLollipopOrHigher() && this.isLowLatencyOutputSupported();
    }

    @TargetApi(value=23)
    private boolean isProAudioSupported() {
        return WebRtcAudioUtils.runningOnMarshmallowOrHigher() && ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.audio.pro");
    }

    private boolean isAAudioSupported() {
        Logging.w(TAG, "AAudio support is currently disabled on all devices!");
        return false;
    }

    private int getNativeOutputSampleRate() {
        if (WebRtcAudioUtils.runningOnEmulator()) {
            Logging.d(TAG, "Running emulator, overriding sample rate to 8 kHz.");
            return 8000;
        }
        if (WebRtcAudioUtils.isDefaultSampleRateOverridden()) {
            Logging.d(TAG, "Default sample rate is overriden to " + WebRtcAudioUtils.getDefaultSampleRateHz() + " Hz");
            return WebRtcAudioUtils.getDefaultSampleRateHz();
        }
        int sampleRateHz = WebRtcAudioUtils.runningOnJellyBeanMR1OrHigher() ? this.getSampleRateOnJellyBeanMR10OrHigher() : WebRtcAudioUtils.getDefaultSampleRateHz();
        Logging.d(TAG, "Sample rate is set to " + sampleRateHz + " Hz");
        return sampleRateHz;
    }

    @TargetApi(value=17)
    private int getSampleRateOnJellyBeanMR10OrHigher() {
        String sampleRateString = this.audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
        return sampleRateString == null ? WebRtcAudioUtils.getDefaultSampleRateHz() : Integer.parseInt(sampleRateString);
    }

    @TargetApi(value=17)
    private int getLowLatencyOutputFramesPerBuffer() {
        WebRtcAudioManager.assertTrue(this.isLowLatencyOutputSupported());
        if (!WebRtcAudioUtils.runningOnJellyBeanMR1OrHigher()) {
            return 256;
        }
        String framesPerBuffer = this.audioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER");
        return framesPerBuffer == null ? 256 : Integer.parseInt(framesPerBuffer);
    }

    private static boolean isAcousticEchoCancelerSupported() {
        return WebRtcAudioEffects.canUseAcousticEchoCanceler();
    }

    private static boolean isNoiseSuppressorSupported() {
        return WebRtcAudioEffects.canUseNoiseSuppressor();
    }

    private static int getMinOutputFrameSize(int sampleRateInHz, int numChannels) {
        int bytesPerFrame = numChannels * 2;
        int channelConfig = numChannels == 1 ? 4 : 12;
        return AudioTrack.getMinBufferSize((int)sampleRateInHz, (int)channelConfig, (int)2) / bytesPerFrame;
    }

    private int getLowLatencyInputFramesPerBuffer() {
        WebRtcAudioManager.assertTrue(this.isLowLatencyInputSupported());
        return this.getLowLatencyOutputFramesPerBuffer();
    }

    private static int getMinInputFrameSize(int sampleRateInHz, int numChannels) {
        int bytesPerFrame = numChannels * 2;
        int channelConfig = numChannels == 1 ? 16 : 12;
        return AudioRecord.getMinBufferSize((int)sampleRateInHz, (int)channelConfig, (int)2) / bytesPerFrame;
    }

    private int setAudioAttrCtx(AudioAttributes attr) {
        if (attr == null) {
            return 0;
        }
        Logging.d(TAG, "audioAttr " + attr.toString());
        this.custAudioAttr = attr;
        return 0;
    }

    @Nullable
    public AudioAttributes getCustAudioAttrCtx() {
        return this.custAudioAttr;
    }

    private int getCurrentPlayoutDevices() {
        int devices = 0;
        try {
            int streamType = this.getStreamType();
            Method method = AudioManager.class.getMethod("getDevicesForStream", Integer.TYPE);
            devices = (Integer)method.invoke((Object)this.audioManager, streamType);
            Logging.d(TAG, "get current playout devices: " + devices);
        }
        catch (Exception error) {
            Logging.e(TAG, "Error getDevicesForStream! ", error);
        }
        return devices;
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private native void nativeCacheAudioParameters(int var1, int var2, int var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, int var11, int var12, int var13, long var14);

    private int getStreamType() {
        int streamType = 0;
        int audioMode = this.audioManager.getMode();
        if (audioMode == 3) {
            streamType = 0;
        } else if (audioMode == 0) {
            streamType = 3;
        } else {
            Logging.w(TAG, "invalid audio mode");
        }
        Logging.d(TAG, "get stream type is " + streamType);
        return streamType;
    }

    private boolean setStreamVolume(int volume) {
        Logging.d(TAG, "setStreamVolume(" + volume + ")");
        WebRtcAudioManager.assertTrue(this.audioManager != null);
        if (this.isVolumeFixed()) {
            Logging.e(TAG, "The device implements a fixed volume policy.");
            return false;
        }
        int streamType = this.getStreamType();
        this.audioManager.setStreamVolume(streamType, volume, 0);
        return true;
    }

    @SuppressLint(value={"NewApi"})
    private boolean isVolumeFixed() {
        if (!WebRtcAudioUtils.runningOnLollipopOrHigher()) {
            return false;
        }
        return this.audioManager.isVolumeFixed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean monitorPlayoutVolumeChange(boolean monitor) {
        Logging.d(TAG, "monitorPlayoutVolumeChange monitor: " + monitor);
        Context context = ContextUtils.getApplicationContext();
        if (context == null || mockedAudioManager != null) {
            return false;
        }
        if (monitor) {
            int streamType = this.getStreamType();
            int volume = this.audioManager.getStreamVolume(streamType);
            this.notifyPlayoutVolumeChange(volume, streamType);
            if (this.mVolumeChangeReceiver == null) {
                try {
                    this.mVolumeChangeReceiver = new VolumeChangeReceiver(this);
                    if (this.mVolumeChangeReceiver == null) {
                        return false;
                    }
                    IntentFilter iFilter = new IntentFilter();
                    iFilter.addAction("android.media.VOLUME_CHANGED_ACTION");
                    iFilter.addAction("android.intent.action.HEADSET_PLUG");
                    context.registerReceiver((BroadcastReceiver)this.mVolumeChangeReceiver, iFilter);
                    return true;
                }
                catch (Exception e) {
                    Logging.e(TAG, "Unable to create VolumeChangeReceiver, ", e);
                    return false;
                }
            }
        } else {
            try {
                Object streamType = this.volumeListenerLock;
                synchronized (streamType) {
                    if (this.mVolumeChangeReceiver != null) {
                        context.unregisterReceiver((BroadcastReceiver)this.mVolumeChangeReceiver);
                        this.mVolumeChangeReceiver = null;
                    }
                }
                return true;
            }
            catch (Exception e) {
                Logging.e(TAG, "unregister VolumeChangeReceiver failed ", e);
                return false;
            }
        }
        return false;
    }

    private int notifyRecordingStatus(int status) {
        int sid = -1;
        if (Build.VERSION.SDK_INT < 24) {
            return sid;
        }
        if (status > 0) {
            List configs = this.audioManager.getActiveRecordingConfigurations();
            for (AudioRecordingConfiguration cfg : configs) {
                sid = cfg.getClientAudioSessionId();
            }
        }
        return sid;
    }

    private boolean checkRecordingOcccupiedInfo(int sid) {
        if (this.audioManager == null || Build.VERSION.SDK_INT < 24) {
            return false;
        }
        List configs = this.audioManager.getActiveRecordingConfigurations();
        for (AudioRecordingConfiguration cfg : configs) {
            if (cfg.getClientAudioSessionId() == sid) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPlayoutVolumeChange(int volume, int streamType) {
        if (this.playoutVolume == volume) {
            return;
        }
        Object object = this.volumeListenerLock;
        synchronized (object) {
            if (this.mVolumeChangeReceiver == null) {
                return;
            }
            this.playoutVolume = volume;
            int playoutVolumeMax = 0;
            playoutVolumeMax = this.audioManager.getStreamMaxVolume(streamType);
            if (playoutVolumeMax != 0) {
                volume = (int)(255.0f * ((float)volume / (float)playoutVolumeMax));
            }
            this.nativeNotifyPlayoutVolumeChange(volume, this.nativeAudioManager);
            Logging.d(TAG, "notifyPlayoutVolumeChange: " + volume);
        }
    }

    private boolean checkRecordingPermission() {
        String permission2 = "android.permission.RECORD_AUDIO";
        boolean hasPermission = true;
        Context context = ContextUtils.getApplicationContext();
        if (context != null && Build.VERSION.SDK_INT >= 23) {
            hasPermission = context.checkSelfPermission(permission2) == 0;
        }
        return hasPermission;
    }

    private native void nativeNotifyPlayoutVolumeChange(int var1, long var2);

    private static class VolumeChangeReceiver
    extends BroadcastReceiver {
        private WeakReference<WebRtcAudioManager> mWebRtcAudioManager;

        public VolumeChangeReceiver(WebRtcAudioManager ad) {
            this.mWebRtcAudioManager = new WeakReference<WebRtcAudioManager>(ad);
        }

        public void onReceive(Context context, Intent intent) {
            WebRtcAudioManager ad = (WebRtcAudioManager)this.mWebRtcAudioManager.get();
            if (ad == null) {
                return;
            }
            int streamType = ad.getStreamType();
            int volume = 0;
            volume = ad.audioManager.getStreamVolume(streamType);
            ad.notifyPlayoutVolumeChange(volume, streamType);
        }
    }

    private static class VolumeLogger {
        private static final String THREAD_NAME = "WebRtcVolumeLevelLoggerThread";
        private static final int TIMER_PERIOD_IN_SECONDS = 30;
        private final AudioManager audioManager;
        @Nullable
        private Timer timer;

        public VolumeLogger(AudioManager audioManager) {
            this.audioManager = audioManager;
        }

        public void start() {
            this.timer = new Timer(THREAD_NAME);
            this.timer.schedule((TimerTask)new LogVolumeTask(this.audioManager.getStreamMaxVolume(2), this.audioManager.getStreamMaxVolume(0)), 0L, 30000L);
        }

        private void stop() {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }

        private class LogVolumeTask
        extends TimerTask {
            private final int maxRingVolume;
            private final int maxVoiceCallVolume;

            LogVolumeTask(int maxRingVolume, int maxVoiceCallVolume) {
                this.maxRingVolume = maxRingVolume;
                this.maxVoiceCallVolume = maxVoiceCallVolume;
            }

            @Override
            public void run() {
                int mode = VolumeLogger.this.audioManager.getMode();
                if (mode == 1) {
                    Logging.d(WebRtcAudioManager.TAG, "STREAM_RING stream volume: " + VolumeLogger.this.audioManager.getStreamVolume(2) + " (max=" + this.maxRingVolume + ")");
                } else if (mode == 3) {
                    Logging.d(WebRtcAudioManager.TAG, "VOICE_CALL stream volume: " + VolumeLogger.this.audioManager.getStreamVolume(0) + " (max=" + this.maxVoiceCallVolume + ")");
                }
            }
        }
    }
}

