/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.internal;

import io.agora.rtc2.ClientRoleOptions;
import io.agora.rtc2.Constants;
import io.agora.rtc2.IRtcEngineEventHandler;
import io.agora.rtc2.UserInfo;
import io.agora.rtc2.internal.RtcEngineMessage;
import java.io.UnsupportedEncodingException;

public class RtcEngineEventHandlerProxy {
    private IRtcEngineEventHandler mHandler = null;

    public RtcEngineEventHandlerProxy(IRtcEngineEventHandler handler) {
        this.mHandler = handler;
    }

    public void handleEvent(int eventId, byte[] evt) {
        if (null == this.mHandler) {
            return;
        }
        block1 : switch (eventId) {
            case 100: {
                try {
                    String string = new String(evt, "ISO-8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                break;
            }
            case 101: {
                RtcEngineMessage.PError pe = new RtcEngineMessage.PError();
                pe.unmarshall(evt);
                this.mHandler.onError(pe.err);
                break;
            }
            case 1002: {
                this.mHandler.onMediaEngineLoadSuccess();
                break;
            }
            case 1005: {
                this.mHandler.onCameraReady();
                break;
            }
            case 1006: {
                this.mHandler.onMediaEngineStartCallSuccess();
                break;
            }
            case 1007: {
                this.mHandler.onVideoStopped();
                break;
            }
            case 1102: {
                RtcEngineMessage.PMediaResAudioQuality aq = new RtcEngineMessage.PMediaResAudioQuality();
                aq.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onAudioQuality(aq.uid, aq.quality, aq.delay, aq.lost);
                break;
            }
            case 1104: {
                RtcEngineMessage.PMediaEngineEvent pmee = new RtcEngineMessage.PMediaEngineEvent();
                pmee.unmarshall(evt);
                switch (pmee.code) {
                    case 10: {
                        this.mHandler.onAudioMixingFinished();
                        break block1;
                    }
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: {
                        break block1;
                    }
                }
                break;
            }
            case 1108: {
                this.mHandler.onRequestToken();
                break;
            }
            case 1109: {
                RtcEngineMessage.PClientRoleChanged pcrc = new RtcEngineMessage.PClientRoleChanged();
                pcrc.unmarshall(evt);
                ClientRoleOptions roleOptions = new ClientRoleOptions();
                roleOptions.audienceLatencyLevel = pcrc.newRoleLatencyLevel;
                this.mHandler.onClientRoleChanged(pcrc.oldRole, pcrc.newRole, roleOptions);
                break;
            }
            case 1121: {
                RtcEngineMessage.PClientRoleChangeFailed pcrcf = new RtcEngineMessage.PClientRoleChangeFailed();
                pcrcf.unmarshall(evt);
                this.mHandler.onClientRoleChangeFailed(pcrcf.reason, pcrcf.currentRole);
                break;
            }
            case 1120: {
                RtcEngineMessage.PStreamPublishState sps = new RtcEngineMessage.PStreamPublishState();
                sps.unmarshall(evt);
                this.mHandler.onRtmpStreamingStateChanged(sps.url, sps.state, sps.error);
                break;
            }
            case 1122: {
                RtcEngineMessage.PStreamPublishEvent spe = new RtcEngineMessage.PStreamPublishEvent();
                spe.unmarshall(evt);
                this.mHandler.onRtmpStreamingEvent(spe.url, spe.event);
                break;
            }
            case 1112: {
                this.mHandler.onTranscodingUpdated();
                break;
            }
            case 1116: {
                RtcEngineMessage.PStreamInjectedStatus sis = new RtcEngineMessage.PStreamInjectedStatus();
                sis.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onStreamInjectedStatus(sis.url, sis.uid, sis.status);
                break;
            }
            case 1117: {
                RtcEngineMessage.PPrivilegeWillExpire ppwe = new RtcEngineMessage.PPrivilegeWillExpire();
                ppwe.unmarshall(evt);
                this.mHandler.onTokenPrivilegeWillExpire(ppwe.token);
                break;
            }
            case 13001: {
                RtcEngineMessage.PMediaResJoinMedia pmjm = new RtcEngineMessage.PMediaResJoinMedia();
                pmjm.unmarshall(evt);
                if (pmjm.firstSuccess) {
                    if (null == this.mHandler) break;
                    this.mHandler.onJoinChannelSuccess(pmjm.channel, pmjm.uid, pmjm.elapsed);
                    break;
                }
                if (null == this.mHandler) break;
                this.mHandler.onRejoinChannelSuccess(pmjm.channel, pmjm.uid, pmjm.elapsed);
                break;
            }
            case 13006: {
                RtcEngineMessage.PMediaResRtcStats rtcStats2 = new RtcEngineMessage.PMediaResRtcStats();
                rtcStats2.unmarshall(evt);
                this.mHandler.onLeaveChannel(rtcStats2.getRtcStats());
                break;
            }
            case 13007: {
                RtcEngineMessage.PMediaResNetworkQuality nq = new RtcEngineMessage.PMediaResNetworkQuality();
                nq.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onNetworkQuality(nq.uid, nq.txQuality, nq.rxQuality);
                break;
            }
            case 14031: {
                RtcEngineMessage.PNetworkTypeChanged ntc = new RtcEngineMessage.PNetworkTypeChanged();
                ntc.unmarshall(evt);
                this.mHandler.onNetworkTypeChanged(ntc.type);
                break;
            }
            case 13008: {
                RtcEngineMessage.PMediaResUserOfflineEvent euo = new RtcEngineMessage.PMediaResUserOfflineEvent();
                euo.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onUserOffline(euo.uid, euo.reason);
                break;
            }
            case 13010: {
                RtcEngineMessage.PMediaResRtcStats rtcStats = new RtcEngineMessage.PMediaResRtcStats();
                rtcStats.unmarshall(evt);
                this.mHandler.onRtcStats(rtcStats.getRtcStats());
                break;
            }
            case 13013: {
                RtcEngineMessage.PMediaResUserJoinedEvent euj = new RtcEngineMessage.PMediaResUserJoinedEvent();
                euj.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onUserJoined(euj.uid, euj.elapsed);
                break;
            }
            case 13014: {
                RtcEngineMessage.PMediaResUserState euma = new RtcEngineMessage.PMediaResUserState();
                euma.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onUserMuteAudio(euma.uid, euma.state);
                break;
            }
            case 13015: {
                RtcEngineMessage.PMediaResUserState eumv = new RtcEngineMessage.PMediaResUserState();
                eumv.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onUserMuteVideo(eumv.uid, eumv.state);
                break;
            }
            case 13016: {
                RtcEngineMessage.PMediaResUserState euev = new RtcEngineMessage.PMediaResUserState();
                euev.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onUserEnableVideo(euev.uid, euev.state);
                break;
            }
            case 13017: {
                RtcEngineMessage.PMediaResLastmileQuality lq = new RtcEngineMessage.PMediaResLastmileQuality();
                lq.unmarshall(evt);
                this.mHandler.onLastmileQuality(lq.quality);
                break;
            }
            case 13020: {
                RtcEngineMessage.PMediaResLastmileProbeResult result = new RtcEngineMessage.PMediaResLastmileProbeResult();
                result.unmarshall(evt);
                IRtcEngineEventHandler.LastmileProbeResult r = result.getLastmileProbeResult();
                this.mHandler.onLastmileProbeResult(r);
                break;
            }
            case 13021: {
                RtcEngineMessage.PUplinkNetworkInfoUpdated uip = new RtcEngineMessage.PUplinkNetworkInfoUpdated();
                uip.unmarshall(evt);
                IRtcEngineEventHandler.UplinkNetworkInfo info = uip.getUplinkNetworkInfo();
                this.mHandler.onUplinkNetworkInfoUpdated(info);
                break;
            }
            case 13022: {
                RtcEngineMessage.PDownlinkNetworkInfoUpdated diu = new RtcEngineMessage.PDownlinkNetworkInfoUpdated();
                diu.unmarshall(evt);
                IRtcEngineEventHandler.DownlinkNetworkInfo info = diu.getDownlinkNetworkInfo();
                this.mHandler.onDownlinkNetworkInfoUpdated(info);
                break;
            }
            case 13018: {
                RtcEngineMessage.PMediaResAudioEffectFinished aef = new RtcEngineMessage.PMediaResAudioEffectFinished();
                aef.unmarshall(evt);
                this.mHandler.onAudioEffectFinished(aef.soundId);
                break;
            }
            case 13019: {
                RtcEngineMessage.PMediaResUserState euelv = new RtcEngineMessage.PMediaResUserState();
                euelv.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onUserEnableLocalVideo(euelv.uid, euelv.state);
                break;
            }
            case 13023: {
                RtcEngineMessage.PUserStateChanged usc = new RtcEngineMessage.PUserStateChanged();
                usc.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onUserStateChanged(usc.uid, usc.state);
                break;
            }
            case 14001: {
                RtcEngineMessage.PMediaResSpeakersReport report = new RtcEngineMessage.PMediaResSpeakersReport();
                report.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onAudioVolumeIndication(report.getAudioVolumeInfo(), report.mixVolume);
                break;
            }
            case 14058: {
                RtcEngineMessage.PFirstRemoteAudioFrame efraf = new RtcEngineMessage.PFirstRemoteAudioFrame();
                efraf.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onFirstRemoteAudioFrame(efraf.uid, efraf.elapsed);
                break;
            }
            case 14033: {
                RtcEngineMessage.PFirstRemoteAudioDecoded frad = new RtcEngineMessage.PFirstRemoteAudioDecoded();
                frad.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onFirstRemoteAudioDecoded(frad.uid, frad.elapsed);
                break;
            }
            case 14002: {
                RtcEngineMessage.PFirstRemoteVideoFrame v = new RtcEngineMessage.PFirstRemoteVideoFrame();
                v.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onFirstRemoteVideoFrame(v.uid, v.width, v.height, v.elapsed);
                break;
            }
            case 14003: {
                RtcEngineMessage.PLocalVideoStat v = new RtcEngineMessage.PLocalVideoStat();
                v.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onLocalVideoStats(Constants.VideoSourceType.fromInt(v.source), v.stats);
                break;
            }
            case 14004: {
                RtcEngineMessage.PRemoteVideoStat v = new RtcEngineMessage.PRemoteVideoStat();
                v.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onRemoteVideoStats(v.stats);
                break;
            }
            case 14005: {
                RtcEngineMessage.PFirstLocalVideoFrame p = new RtcEngineMessage.PFirstLocalVideoFrame();
                p.unmarshall(evt);
                this.mHandler.onFirstLocalVideoFrame(Constants.VideoSourceType.fromInt(p.source), p.width, p.height, p.elapsed);
                break;
            }
            case 14007: {
                RtcEngineMessage.PFirstRemoteVideoDecoded p = new RtcEngineMessage.PFirstRemoteVideoDecoded();
                p.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onFirstRemoteVideoDecoded(p.uid, p.width, p.height, p.elapsed);
                break;
            }
            case 14008: {
                this.mHandler.onConnectionLost();
                break;
            }
            case 14009: {
                RtcEngineMessage.PStreamMessage p = new RtcEngineMessage.PStreamMessage();
                p.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onStreamMessage(p.uid, p.streamId, p.payload);
                break;
            }
            case 14010: {
                this.mHandler.onConnectionInterrupted();
                break;
            }
            case 14012: {
                RtcEngineMessage.PStreamMessageError p = new RtcEngineMessage.PStreamMessageError();
                p.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onStreamMessageError(p.uid, p.streamId, p.error, p.missed, p.cached);
                break;
            }
            case 14054: {
                RtcEngineMessage.PRhythmPlayerStateChanged rpsc = new RtcEngineMessage.PRhythmPlayerStateChanged();
                rpsc.unmarshall(evt);
                this.mHandler.onRhythmPlayerStateChanged(rpsc.state, rpsc.errorCode);
                break;
            }
            case 14013: {
                RtcEngineMessage.PVideoSizeChanged p = new RtcEngineMessage.PVideoSizeChanged();
                p.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onVideoSizeChanged(Constants.VideoSourceType.fromInt(p.source), p.uid, p.width, p.height, p.rotation);
                break;
            }
            case 14014: {
                RtcEngineMessage.PFirstLocalAudioFrame p = new RtcEngineMessage.PFirstLocalAudioFrame();
                p.unmarshall(evt);
                this.mHandler.onFirstLocalAudioFramePublished(p.elapsed);
                break;
            }
            case 14015: {
                RtcEngineMessage.PFirstLocalVideoFramePublished p = new RtcEngineMessage.PFirstLocalVideoFramePublished();
                p.unmarshall(evt);
                this.mHandler.onFirstLocalVideoFramePublished(Constants.VideoSourceType.fromInt(p.source), p.elapsed);
                break;
            }
            case 14016: {
                RtcEngineMessage.PActiveSpeaker eas = new RtcEngineMessage.PActiveSpeaker();
                eas.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onActiveSpeaker(eas.uid);
                break;
            }
            case 14019: {
                this.mHandler.onConnectionBanned();
                break;
            }
            case 14020: {
                RtcEngineMessage.PCameraFocusAreaChanged p = new RtcEngineMessage.PCameraFocusAreaChanged();
                p.unmarshall(evt);
                this.mHandler.onCameraFocusAreaChanged(p.getRect());
                break;
            }
            case 14029: {
                RtcEngineMessage.PCameraExposureAreaChanged p = new RtcEngineMessage.PCameraExposureAreaChanged();
                p.unmarshall(evt);
                this.mHandler.onCameraExposureAreaChanged(p.getRect());
                break;
            }
            case 14053: {
                RtcEngineMessage.PFacePositionChanged p = new RtcEngineMessage.PFacePositionChanged();
                p.unmarshall(evt);
                this.mHandler.onFacePositionChanged(p.imageWidth, p.imageHeight, p.getAgoraFacePositionInfo());
                break;
            }
            case 14062: {
                RtcEngineMessage.PSnapshotTaken p = new RtcEngineMessage.PSnapshotTaken();
                p.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onSnapshotTaken(p.uid, p.filepath, p.width, p.height, p.errCode);
                break;
            }
            case 14063: {
                RtcEngineMessage.PContentInspectResult m = new RtcEngineMessage.PContentInspectResult();
                m.unmarshall(evt);
                this.mHandler.onContentInspectResult(m.result);
                break;
            }
            case 14021: {
                RtcEngineMessage.PRemoteVideoState m = new RtcEngineMessage.PRemoteVideoState();
                m.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onRemoteVideoStateChanged(m.uid, m.state, m.reason, m.elapsed);
                break;
            }
            case 14022: {
                RtcEngineMessage.PLocalFallbackStatus lfs = new RtcEngineMessage.PLocalFallbackStatus();
                lfs.unmarshall(evt);
                this.mHandler.onLocalPublishFallbackToAudioOnly(lfs.state);
                break;
            }
            case 14023: {
                RtcEngineMessage.PMediaResUserState erfsc = new RtcEngineMessage.PMediaResUserState();
                erfsc.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onRemoteSubscribeFallbackToAudioOnly(erfsc.uid, erfsc.state);
                break;
            }
            case 14024: {
                RtcEngineMessage.PUserTransportStat ts = new RtcEngineMessage.PUserTransportStat();
                ts.unmarshall(evt);
                if (ts.isAudio) {
                    if (null == this.mHandler) break;
                    this.mHandler.onRemoteAudioTransportStats(ts.peerUid, ts.delay, ts.lost, ts.rxKBitRate);
                    break;
                }
                if (null == this.mHandler) break;
                this.mHandler.onRemoteVideoTransportStats(ts.peerUid, ts.delay, ts.lost, ts.rxKBitRate);
                break;
            }
            case 14040: {
                RtcEngineMessage.PRemoteAudioState m = new RtcEngineMessage.PRemoteAudioState();
                m.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onRemoteAudioStateChanged(m.uid, m.state, m.reason, m.elapsed);
                break;
            }
            case 14042: {
                RtcEngineMessage.PLocalAudioState audioState = new RtcEngineMessage.PLocalAudioState();
                audioState.unmarshall(evt);
                this.mHandler.onLocalAudioStateChanged(audioState.state, audioState.errorCode);
                break;
            }
            case 1118: {
                RtcEngineMessage.PLocalVideoState v = new RtcEngineMessage.PLocalVideoState();
                v.unmarshall(evt);
                this.mHandler.onLocalVideoStateChanged(Constants.VideoSourceType.fromInt(v.source), v.state, v.errorCode);
                break;
            }
            case 14037: {
                RtcEngineMessage.PCrossChannelState c = new RtcEngineMessage.PCrossChannelState();
                c.unmarshall(evt);
                this.mHandler.onChannelMediaRelayStateChanged(c.state, c.code);
                break;
            }
            case 14041: {
                RtcEngineMessage.PLocalAudioStat v = new RtcEngineMessage.PLocalAudioStat();
                v.unmarshall(evt);
                this.mHandler.onLocalAudioStats(v.stats);
                break;
            }
            case 14030: {
                RtcEngineMessage.PRemoteAudioStat p = new RtcEngineMessage.PRemoteAudioStat();
                p.unmarshall(evt);
                if (null == this.mHandler) break;
                if (0 == p.stats.uid) {
                    return;
                }
                this.mHandler.onRemoteAudioStats(p.stats);
                break;
            }
            case 14028: {
                RtcEngineMessage.PConnectionState cs = new RtcEngineMessage.PConnectionState();
                cs.unmarshall(evt);
                this.mHandler.onConnectionStateChanged(cs.state, cs.reason);
                break;
            }
            case 14032: {
                RtcEngineMessage.PAudioRoutingChanged arc = new RtcEngineMessage.PAudioRoutingChanged();
                arc.unmarshall(evt);
                this.mHandler.onAudioRouteChanged(arc.routing);
                break;
            }
            case 14043: {
                RtcEngineMessage.PAudioMixingStateChanged amsc = new RtcEngineMessage.PAudioMixingStateChanged();
                amsc.unmarshall(evt);
                this.mHandler.onAudioMixingStateChanged(amsc.state, amsc.reasonCode);
                if (amsc.state != 713) break;
                this.mHandler.onAudioMixingFinished();
                break;
            }
            case 14064: {
                RtcEngineMessage.PAudioMixingPositionChanged ampc = new RtcEngineMessage.PAudioMixingPositionChanged();
                ampc.unmarshall(evt);
                this.mHandler.onAudioMixingPositionChanged(ampc.position);
                break;
            }
            case 14044: {
                this.mHandler.onIntraRequestReceived();
                break;
            }
            case 14046: {
                RtcEngineMessage.PEncryptionError encryptError = new RtcEngineMessage.PEncryptionError();
                encryptError.unmarshall(evt);
                this.mHandler.onEncryptionError(encryptError.errorType);
                break;
            }
            case 14052: {
                RtcEngineMessage.PPermissionError permissionError = new RtcEngineMessage.PPermissionError();
                permissionError.unmarshall(evt);
                this.mHandler.onPermissionError(permissionError.permission);
                break;
            }
            case 14034: {
                RtcEngineMessage.PUserInfoState m = new RtcEngineMessage.PUserInfoState();
                m.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onLocalUserRegistered(m.uid, m.userAccount);
                break;
            }
            case 14035: {
                RtcEngineMessage.PUserInfoState m = new RtcEngineMessage.PUserInfoState();
                m.unmarshall(evt);
                UserInfo userInfo = new UserInfo(m.uid, m.userAccount);
                if (null == this.mHandler) break;
                this.mHandler.onUserInfoUpdated(m.uid, userInfo);
                break;
            }
            case 14048: {
                RtcEngineMessage.PSubscribeAudioStateChanged s = new RtcEngineMessage.PSubscribeAudioStateChanged();
                s.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onAudioSubscribeStateChanged(s.channelId, s.uid, s.oldState, s.newState, s.elapseSinceLastState);
                break;
            }
            case 14049: {
                RtcEngineMessage.PSubscribeVideoStateChanged s = new RtcEngineMessage.PSubscribeVideoStateChanged();
                s.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onVideoSubscribeStateChanged(s.channelId, s.uid, s.oldState, s.newState, s.elapseSinceLastState);
                break;
            }
            case 14050: {
                RtcEngineMessage.PPublishAudioStateChanged p = new RtcEngineMessage.PPublishAudioStateChanged();
                p.unmarshall(evt);
                this.mHandler.onAudioPublishStateChanged(p.channelId, p.oldState, p.newState, p.elapseSinceLastState);
                break;
            }
            case 14051: {
                RtcEngineMessage.PPublishVideoStateChanged p = new RtcEngineMessage.PPublishVideoStateChanged();
                p.unmarshall(evt);
                this.mHandler.onVideoPublishStateChanged(Constants.VideoSourceType.fromInt(p.source), p.channelId, p.oldState, p.newState, p.elapseSinceLastState);
                break;
            }
            case 14055: {
                RtcEngineMessage.PUploadLogResult p = new RtcEngineMessage.PUploadLogResult();
                p.unmarshall(evt);
                this.mHandler.onUploadLogResult(p.requestId, p.success, p.reason);
                break;
            }
            case 14059: {
                RtcEngineMessage.PProxyConnect lp = new RtcEngineMessage.PProxyConnect();
                lp.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onProxyConnected(lp.channel, lp.uid, lp.proxyType, lp.localProxyIp, lp.elapsed);
                break;
            }
            case 14060: {
                RtcEngineMessage.PMediaResWlAccMessage w = new RtcEngineMessage.PMediaResWlAccMessage();
                w.unmarshall(evt);
                this.mHandler.onWlAccMessage(w.reason, w.action, w.wlAccMsg);
                break;
            }
            case 14061: {
                RtcEngineMessage.PMediaResWlAccStats w = new RtcEngineMessage.PMediaResWlAccStats();
                w.unmarshall(evt);
                this.mHandler.onWlAccStats(w.getWlAccStatsCur(), w.getWlAccStatsAve());
                break;
            }
            case 14065: {
                RtcEngineMessage.PLicenseVerifyFailed p = new RtcEngineMessage.PLicenseVerifyFailed();
                p.unmarshall(evt);
                this.mHandler.onLicenseValidationFailure(p.reason);
                break;
            }
            case 14066: {
                RtcEngineMessage.PVideoRenderingTracingInfo vrti = new RtcEngineMessage.PVideoRenderingTracingInfo();
                vrti.unmarshall(evt);
                IRtcEngineEventHandler.VideoRenderingTracingInfo tracingInfo = vrti.getVideoRenderingTracingInfo();
                Constants.MEDIA_TRACE_EVENT event = Constants.MEDIA_TRACE_EVENT.fromInt(vrti.event);
                if (null == this.mHandler) break;
                this.mHandler.onVideoRenderingTracingResult(vrti.uid, event, tracingInfo);
                break;
            }
            case 14067: {
                RtcEngineMessage.PTranscodingVideoStream p = new RtcEngineMessage.PTranscodingVideoStream();
                p.unmarshall(evt);
                if (null == this.mHandler) break;
                this.mHandler.onLocalVideoTranscoderError(p.getTranscodingVideoStream(), p.error);
                break;
            }
            case 14069: {
                RtcEngineMessage.PVideoLayoutInfo pVideoLayoutInfo = new RtcEngineMessage.PVideoLayoutInfo();
                pVideoLayoutInfo.unmarshall(evt);
                IRtcEngineEventHandler.VideoLayoutInfo videoLayoutInfo = new IRtcEngineEventHandler.VideoLayoutInfo();
                videoLayoutInfo.width = pVideoLayoutInfo.width;
                videoLayoutInfo.height = pVideoLayoutInfo.height;
                videoLayoutInfo.layoutCount = pVideoLayoutInfo.layoutCount;
                if (videoLayoutInfo.layoutCount > 0) {
                    videoLayoutInfo.layoutList = new IRtcEngineEventHandler.VideoLayout[videoLayoutInfo.layoutCount];
                    for (int i = 0; i < videoLayoutInfo.layoutCount; ++i) {
                        videoLayoutInfo.layoutList[i] = new IRtcEngineEventHandler.VideoLayout();
                        videoLayoutInfo.layoutList[i].channelId = pVideoLayoutInfo.layoutList[i].channel;
                        videoLayoutInfo.layoutList[i].uid = pVideoLayoutInfo.layoutList[i].uid;
                        videoLayoutInfo.layoutList[i].x = pVideoLayoutInfo.layoutList[i].x;
                        videoLayoutInfo.layoutList[i].y = pVideoLayoutInfo.layoutList[i].y;
                        videoLayoutInfo.layoutList[i].width = pVideoLayoutInfo.layoutList[i].width;
                        videoLayoutInfo.layoutList[i].height = pVideoLayoutInfo.layoutList[i].height;
                        videoLayoutInfo.layoutList[i].videoState = pVideoLayoutInfo.layoutList[i].videoState;
                    }
                }
                if (null == this.mHandler) break;
                this.mHandler.onTranscodedStreamLayoutInfo(pVideoLayoutInfo.uid, videoLayoutInfo);
                break;
            }
        }
    }
}

