/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.api.configuration.supplier;

import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.agroal.api.configuration.supplier.AgroalConnectionFactoryConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalConnectionPoolConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalDataSourceConfigurationSupplier;
import io.agroal.api.security.NamePrincipal;
import io.agroal.api.security.SimplePassword;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class AgroalPropertiesReader
implements Supplier<AgroalDataSourceConfiguration> {
    public static final String IMPLEMENTATION = "implementation";
    public static final String METRICS_ENABLED = "metricsEnabled";
    public static final String MIN_SIZE = "minSize";
    public static final String MAX_SIZE = "maxSize";
    public static final String INITIAL_SIZE = "initialSize";
    public static final String FLUSH_ON_CLOSE = "flushOnClose";
    public static final String ENHANCED_LEAK_REPORT = "enhancedLeakReport";
    public static final String MULTIPLE_ACQUISITION = "multipleAcquisition";
    public static final String TRANSACTION_REQUIREMENT = "transactionRequirement";
    public static final String ACQUISITION_TIMEOUT = "acquisitionTimeout";
    public static final String ACQUISITION_TIMEOUT_MS = "acquisitionTimeout_ms";
    public static final String ACQUISITION_TIMEOUT_S = "acquisitionTimeout_s";
    public static final String ACQUISITION_TIMEOUT_M = "acquisitionTimeout_m";
    public static final String VALIDATION_TIMEOUT = "validationTimeout";
    public static final String VALIDATION_TIMEOUT_MS = "validationTimeout_ms";
    public static final String VALIDATION_TIMEOUT_S = "validationTimeout_s";
    public static final String VALIDATION_TIMEOUT_M = "validationTimeout_m";
    public static final String LEAK_TIMEOUT = "leakTimeout";
    public static final String LEAK_TIMEOUT_MS = "leakTimeout_ms";
    public static final String LEAK_TIMEOUT_S = "leakTimeout_s";
    public static final String LEAK_TIMEOUT_M = "leakTimeout_m";
    public static final String REAP_TIMEOUT = "reapTimeout";
    public static final String REAP_TIMEOUT_MS = "reapTimeout_ms";
    public static final String REAP_TIMEOUT_S = "reapTimeout_s";
    public static final String REAP_TIMEOUT_M = "reapTimeout_m";
    public static final String MAX_LIFETIME = "maxLifetime";
    public static final String MAX_LIFETIME_MS = "maxLifetime_ms";
    public static final String MAX_LIFETIME_S = "maxLifetime_s";
    public static final String MAX_LIFETIME_M = "maxLifetime_m";
    public static final String JDBC_URL = "jdbcUrl";
    public static final String AUTO_COMMIT = "autoCommit";
    public static final String TRACK_JDBC_RESOURCES = "trackJdbcResources";
    public static final String INITIAL_SQL = "initialSQL";
    public static final String PROVIDER_CLASS_NAME = "providerClassName";
    public static final String TRANSACTION_ISOLATION = "jdbcTransactionIsolation";
    public static final String PRINCIPAL = "principal";
    public static final String CREDENTIAL = "credential";
    public static final String RECOVERY_PRINCIPAL = "recoveryPrincipal";
    public static final String RECOVERY_CREDENTIAL = "recoveryCredential";
    public static final String JDBC_PROPERTIES = "jdbcProperties";
    private final String prefix;
    private final AgroalDataSourceConfigurationSupplier dataSourceSupplier;

    public AgroalPropertiesReader() {
        this("");
    }

    public AgroalPropertiesReader(String readerPrefix) {
        this.prefix = readerPrefix;
        this.dataSourceSupplier = new AgroalDataSourceConfigurationSupplier();
    }

    @Override
    public AgroalDataSourceConfiguration get() {
        return this.dataSourceSupplier.get();
    }

    public AgroalDataSourceConfigurationSupplier modify() {
        return this.dataSourceSupplier;
    }

    public AgroalPropertiesReader readProperties(Path path) throws IOException {
        return this.readProperties(path.toFile());
    }

    public AgroalPropertiesReader readProperties(String filename) throws IOException {
        return this.readProperties(new File(filename));
    }

    public AgroalPropertiesReader readProperties(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            Properties properties = new Properties();
            properties.load(inputStream);
            AgroalPropertiesReader agroalPropertiesReader = this.readProperties(properties);
            return agroalPropertiesReader;
        }
    }

    public AgroalPropertiesReader readProperties(Properties properties) {
        return this.readProperties((Map<String, String>)properties);
    }

    public AgroalPropertiesReader readProperties(Map<String, String> properties) {
        AgroalConnectionPoolConfigurationSupplier connectionPoolSupplier = new AgroalConnectionPoolConfigurationSupplier();
        AgroalConnectionFactoryConfigurationSupplier connectionFactorySupplier = new AgroalConnectionFactoryConfigurationSupplier();
        this.apply(this.dataSourceSupplier::dataSourceImplementation, AgroalDataSourceConfiguration.DataSourceImplementation::valueOf, properties, IMPLEMENTATION);
        this.apply(this.dataSourceSupplier::metricsEnabled, Boolean::parseBoolean, properties, METRICS_ENABLED);
        this.apply(connectionPoolSupplier::minSize, Integer::parseInt, properties, MIN_SIZE);
        this.apply(connectionPoolSupplier::maxSize, Integer::parseInt, properties, MAX_SIZE);
        this.apply(connectionPoolSupplier::flushOnClose, Boolean::parseBoolean, properties, FLUSH_ON_CLOSE);
        this.apply(connectionPoolSupplier::initialSize, Integer::parseInt, properties, INITIAL_SIZE);
        this.apply(connectionPoolSupplier::enhancedLeakReport, Boolean::parseBoolean, properties, ENHANCED_LEAK_REPORT);
        this.apply(connectionPoolSupplier::multipleAcquisition, AgroalConnectionPoolConfiguration.MultipleAcquisitionAction::valueOf, properties, MULTIPLE_ACQUISITION);
        this.apply(connectionPoolSupplier::transactionRequirement, AgroalConnectionPoolConfiguration.TransactionRequirement::valueOf, properties, TRANSACTION_REQUIREMENT);
        this.apply(connectionPoolSupplier::acquisitionTimeout, Duration::parse, properties, ACQUISITION_TIMEOUT);
        this.apply(connectionPoolSupplier::acquisitionTimeout, AgroalPropertiesReader::parseDurationMs, properties, ACQUISITION_TIMEOUT_MS);
        this.apply(connectionPoolSupplier::acquisitionTimeout, AgroalPropertiesReader::parseDurationS, properties, ACQUISITION_TIMEOUT_S);
        this.apply(connectionPoolSupplier::acquisitionTimeout, AgroalPropertiesReader::parseDurationM, properties, ACQUISITION_TIMEOUT_M);
        this.apply(connectionPoolSupplier::validationTimeout, Duration::parse, properties, VALIDATION_TIMEOUT);
        this.apply(connectionPoolSupplier::validationTimeout, AgroalPropertiesReader::parseDurationMs, properties, VALIDATION_TIMEOUT_MS);
        this.apply(connectionPoolSupplier::validationTimeout, AgroalPropertiesReader::parseDurationS, properties, VALIDATION_TIMEOUT_S);
        this.apply(connectionPoolSupplier::validationTimeout, AgroalPropertiesReader::parseDurationM, properties, VALIDATION_TIMEOUT_M);
        this.apply(connectionPoolSupplier::leakTimeout, Duration::parse, properties, LEAK_TIMEOUT);
        this.apply(connectionPoolSupplier::leakTimeout, AgroalPropertiesReader::parseDurationMs, properties, LEAK_TIMEOUT_MS);
        this.apply(connectionPoolSupplier::leakTimeout, AgroalPropertiesReader::parseDurationS, properties, LEAK_TIMEOUT_S);
        this.apply(connectionPoolSupplier::leakTimeout, AgroalPropertiesReader::parseDurationM, properties, LEAK_TIMEOUT_M);
        this.apply(connectionPoolSupplier::reapTimeout, Duration::parse, properties, REAP_TIMEOUT);
        this.apply(connectionPoolSupplier::reapTimeout, AgroalPropertiesReader::parseDurationMs, properties, REAP_TIMEOUT_MS);
        this.apply(connectionPoolSupplier::reapTimeout, AgroalPropertiesReader::parseDurationS, properties, REAP_TIMEOUT_S);
        this.apply(connectionPoolSupplier::reapTimeout, AgroalPropertiesReader::parseDurationM, properties, REAP_TIMEOUT_M);
        this.apply(connectionPoolSupplier::maxLifetime, Duration::parse, properties, MAX_LIFETIME);
        this.apply(connectionPoolSupplier::maxLifetime, AgroalPropertiesReader::parseDurationMs, properties, MAX_LIFETIME_MS);
        this.apply(connectionPoolSupplier::maxLifetime, AgroalPropertiesReader::parseDurationS, properties, MAX_LIFETIME_S);
        this.apply(connectionPoolSupplier::maxLifetime, AgroalPropertiesReader::parseDurationM, properties, MAX_LIFETIME_M);
        this.apply(connectionFactorySupplier::jdbcUrl, Function.identity(), properties, JDBC_URL);
        this.apply(connectionFactorySupplier::autoCommit, Boolean::parseBoolean, properties, AUTO_COMMIT);
        this.apply(connectionFactorySupplier::trackJdbcResources, Boolean::parseBoolean, properties, TRACK_JDBC_RESOURCES);
        this.apply(connectionFactorySupplier::initialSql, Function.identity(), properties, INITIAL_SQL);
        this.apply(connectionFactorySupplier::connectionProviderClassName, Function.identity(), properties, PROVIDER_CLASS_NAME);
        this.apply(connectionFactorySupplier::jdbcTransactionIsolation, AgroalConnectionFactoryConfiguration.TransactionIsolation::valueOf, properties, TRANSACTION_ISOLATION);
        this.apply(connectionFactorySupplier::principal, NamePrincipal::new, properties, PRINCIPAL);
        this.apply(connectionFactorySupplier::credential, SimplePassword::new, properties, CREDENTIAL);
        this.apply(connectionFactorySupplier::recoveryPrincipal, NamePrincipal::new, properties, RECOVERY_PRINCIPAL);
        this.apply(connectionFactorySupplier::recoveryCredential, SimplePassword::new, properties, RECOVERY_CREDENTIAL);
        this.applyJdbcProperties(connectionFactorySupplier::jdbcProperty, properties, JDBC_PROPERTIES);
        this.dataSourceSupplier.connectionPoolConfiguration(connectionPoolSupplier.connectionFactoryConfiguration(connectionFactorySupplier));
        return this;
    }

    private <T> void apply(Consumer<? super T> consumer, Function<? super String, T> converter, Map<String, String> properties, String key) {
        String value = properties.get(this.prefix + key);
        if (value != null) {
            consumer.accept(converter.apply(value));
        }
    }

    private void applyJdbcProperties(BiConsumer<? super String, ? super String> consumer, Map<String, String> properties, String key) {
        String propertiesArray = properties.get(this.prefix + key);
        if (propertiesArray != null && !propertiesArray.isEmpty()) {
            for (String property : propertiesArray.split(";")) {
                String[] keyValue = property.split("=");
                consumer.accept(keyValue[0], keyValue[1]);
            }
        }
    }

    private static Duration parseDurationMs(String value) {
        return Duration.ofMillis(Long.parseLong(value));
    }

    private static Duration parseDurationS(String value) {
        return Duration.ofSeconds(Long.parseLong(value));
    }

    private static Duration parseDurationM(String value) {
        return Duration.ofMinutes(Long.parseLong(value));
    }
}

