/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.hikari;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.AgroalDataSourceMetrics;
import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.agroal.api.security.SimplePassword;
import java.io.PrintWriter;
import java.security.Principal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;

public class HikariUnderTheCovers
implements AgroalDataSource {
    private static final long serialVersionUID = -1655894113120947776L;
    private final AgroalDataSourceConfiguration configuration;
    private final AgroalConnectionPoolConfiguration poolConfiguration;
    private final AgroalConnectionFactoryConfiguration factoryConfiguration;
    private final HikariDataSource hikari;

    public HikariUnderTheCovers(AgroalDataSourceConfiguration dataSourceConfiguration, AgroalDataSourceListener ... listeners) {
        this.configuration = dataSourceConfiguration;
        this.poolConfiguration = dataSourceConfiguration.connectionPoolConfiguration();
        this.factoryConfiguration = this.poolConfiguration.connectionFactoryConfiguration();
        this.hikari = new HikariDataSource(this.getHikariConfig(dataSourceConfiguration));
    }

    private HikariConfig getHikariConfig(AgroalDataSourceConfiguration dataSourceConfiguration) {
        if (dataSourceConfiguration.isXA()) {
            throw new UnsupportedOperationException("Unsupported. Hikari does not support XA");
        }
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDataSourceJNDI(dataSourceConfiguration.jndiName());
        hikariConfig.setLeakDetectionThreshold(this.poolConfiguration.leakTimeout().toMillis());
        hikariConfig.setIdleTimeout(this.poolConfiguration.reapTimeout().toMillis());
        hikariConfig.setValidationTimeout(this.poolConfiguration.validationTimeout().toMillis());
        if (this.factoryConfiguration.jdbcTransactionIsolation().isDefined()) {
            hikariConfig.setTransactionIsolation("TRANSACTION_" + this.factoryConfiguration.jdbcTransactionIsolation().name());
        }
        hikariConfig.setJdbcUrl(this.factoryConfiguration.jdbcUrl());
        hikariConfig.setAutoCommit(this.factoryConfiguration.autoCommit());
        hikariConfig.setConnectionInitSql(this.factoryConfiguration.initialSql());
        Principal principal = this.factoryConfiguration.principal();
        if (principal != null) {
            hikariConfig.setUsername(this.factoryConfiguration.principal().getName());
        }
        for (Object credential : this.factoryConfiguration.credentials()) {
            if (!(credential instanceof SimplePassword)) continue;
            hikariConfig.setPassword(((SimplePassword)credential).getWord());
        }
        hikariConfig.setMaximumPoolSize(this.poolConfiguration.maxSize());
        hikariConfig.setConnectionTimeout(this.poolConfiguration.acquisitionTimeout().toMillis());
        hikariConfig.setDriverClassName(this.factoryConfiguration.driverClassName());
        return hikariConfig;
    }

    public AgroalDataSourceConfiguration getConfiguration() {
        return this.configuration;
    }

    public AgroalDataSourceMetrics getMetrics() {
        throw new UnsupportedOperationException("Hikari pool does not expose metrics");
    }

    public void addListener(AgroalDataSourceListener listener) {
        throw new UnsupportedOperationException("Hikari pool does not support listeners");
    }

    public void close() {
        this.hikari.close();
    }

    public Connection getConnection() throws SQLException {
        return this.hikari.getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.hikari.getConnection(username, password);
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this.hikari.unwrap(iface);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.hikari.isWrapperFor(iface);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.hikari.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.hikari.setLogWriter(out);
    }

    public int getLoginTimeout() throws SQLException {
        return this.hikari.getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.hikari.setLoginTimeout(seconds);
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.hikari.getParentLogger();
    }
}

