/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.AgroalDataSourceMetrics;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.agroal.pool.ConnectionPool;
import io.agroal.pool.DefaultMetricsRepository;
import io.agroal.pool.MetricsRepository;
import io.agroal.pool.util.StampedCopyOnWriteArrayList;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class DataSource
implements AgroalDataSource,
AgroalDataSourceConfiguration.MetricsEnabledListener {
    private static final long serialVersionUID = 6485903416474487024L;
    private final AgroalDataSourceConfiguration configuration;
    private final List<AgroalDataSourceListener> listenerList;
    private final ConnectionPool connectionPool;
    private MetricsRepository dataSourceMetrics;

    public DataSource(AgroalDataSourceConfiguration configuration, AgroalDataSourceListener ... listeners) {
        this.configuration = configuration;
        this.configuration.registerMetricsEnabledListener((AgroalDataSourceConfiguration.MetricsEnabledListener)this);
        this.listenerList = new StampedCopyOnWriteArrayList<AgroalDataSourceListener>(AgroalDataSourceListener.class);
        this.listenerList.addAll(Arrays.asList(listeners));
        this.connectionPool = new ConnectionPool(configuration.connectionPoolConfiguration(), this);
        this.onMetricsEnabled(configuration.metricsEnabled());
        this.connectionPool.init();
    }

    public List<AgroalDataSourceListener> listenerList() {
        return this.listenerList;
    }

    public MetricsRepository metricsRepository() {
        return this.dataSourceMetrics;
    }

    public void onMetricsEnabled(boolean metricsEnabled) {
        this.dataSourceMetrics = metricsEnabled ? new DefaultMetricsRepository(this.connectionPool) : new MetricsRepository.EmptyMetricsRepository();
    }

    public AgroalDataSourceConfiguration getConfiguration() {
        return this.configuration;
    }

    public AgroalDataSourceMetrics getMetrics() {
        return this.dataSourceMetrics;
    }

    public void addListener(AgroalDataSourceListener listener) {
        this.listenerList.add(listener);
    }

    public void close() {
        this.connectionPool.close();
    }

    public Connection getConnection() throws SQLException {
        return this.connectionPool.getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLException("username/password invalid on a pooled data source");
    }

    public <T> T unwrap(Class<T> target) throws SQLException {
        return null;
    }

    public boolean isWrapperFor(Class<?> target) throws SQLException {
        return false;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Not Supported");
    }
}

