/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.AgroalDataSourceMetrics;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.agroal.pool.ConnectionPool;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;

public final class DataSource
implements AgroalDataSource {
    private static final long serialVersionUID = 6485903416474487024L;
    private final AgroalDataSourceConfiguration configuration;
    private final ConnectionPool connectionPool;

    public DataSource(AgroalDataSourceConfiguration dataSourceConfiguration, AgroalDataSourceListener ... listeners) {
        this.configuration = dataSourceConfiguration;
        this.connectionPool = new ConnectionPool(dataSourceConfiguration.connectionPoolConfiguration(), listeners);
        dataSourceConfiguration.registerMetricsEnabledListener((AgroalDataSourceConfiguration.MetricsEnabledListener)this.connectionPool);
        this.connectionPool.onMetricsEnabled(dataSourceConfiguration.metricsEnabled());
        this.connectionPool.init();
    }

    public AgroalDataSourceConfiguration getConfiguration() {
        return this.configuration;
    }

    public AgroalDataSourceMetrics getMetrics() {
        return this.connectionPool.getMetrics();
    }

    @Deprecated
    public void addListener(AgroalDataSourceListener listener) {
        throw new UnsupportedOperationException("Deprecated. Add listeners using the constructor or AgroalDataSource factory methods");
    }

    public void flush(AgroalDataSource.FlushMode mode) {
        this.connectionPool.flush(mode);
    }

    public void close() {
        this.connectionPool.close();
    }

    public Connection getConnection() throws SQLException {
        return this.connectionPool.getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLException("username and password combination invalid on a pooled data source!");
    }

    public <T> T unwrap(Class<T> target) throws SQLException {
        return null;
    }

    public boolean isWrapperFor(Class<?> target) throws SQLException {
        return false;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Not Supported");
    }
}

