/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool;

import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.security.AgroalSecurityProvider;
import io.agroal.api.transaction.TransactionIntegration;
import io.agroal.pool.util.ListenerHelper;
import io.agroal.pool.util.PropertyInjector;
import io.agroal.pool.util.XAConnectionAdaptor;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public final class ConnectionFactory
implements TransactionIntegration.ResourceRecoveryFactory {
    private static final String URL_PROPERTY_NAME = "url";
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private final AgroalConnectionFactoryConfiguration configuration;
    private final AgroalDataSourceListener[] listeners;
    private final Properties jdbcProperties;
    private final Mode factoryMode;
    private Driver driver;
    private DataSource dataSource;
    private XADataSource xaDataSource;
    private XADataSource xaRecoveryDataSource;
    private PropertyInjector injector;

    public ConnectionFactory(AgroalConnectionFactoryConfiguration configuration, AgroalDataSourceListener ... listeners) {
        this.configuration = configuration;
        this.listeners = listeners;
        this.jdbcProperties = new Properties();
        configuration.jdbcProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)this.jdbcProperties::put));
        this.factoryMode = Mode.fromClass(configuration.connectionProviderClass());
        switch (this.factoryMode) {
            case XA_DATASOURCE: {
                this.injector = new PropertyInjector(configuration.connectionProviderClass());
                this.xaDataSource = this.newXADataSource(this.jdbcProperties);
                this.xaRecoveryDataSource = this.newXADataSource(this.jdbcProperties);
                break;
            }
            case DATASOURCE: {
                this.injector = new PropertyInjector(configuration.connectionProviderClass());
                this.dataSource = this.newDataSource(this.jdbcProperties);
                break;
            }
            case DRIVER: {
                this.driver = this.newDriver();
            }
        }
    }

    private XADataSource newXADataSource(Properties properties) {
        XADataSource newDataSource;
        try {
            newDataSource = this.configuration.connectionProviderClass().asSubclass(XADataSource.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to instantiate javax.sql.XADataSource", e);
        }
        if (this.configuration.jdbcUrl() != null && !this.configuration.jdbcUrl().isEmpty()) {
            this.injectUrlProperty(newDataSource, URL_PROPERTY_NAME, this.configuration.jdbcUrl());
        }
        this.injectJdbcProperties(newDataSource, properties);
        return newDataSource;
    }

    private DataSource newDataSource(Properties properties) {
        DataSource newDataSource;
        try {
            newDataSource = this.configuration.connectionProviderClass().asSubclass(DataSource.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to instantiate javax.sql.DataSource", e);
        }
        if (this.configuration.jdbcUrl() != null && !this.configuration.jdbcUrl().isEmpty()) {
            this.injectUrlProperty(newDataSource, URL_PROPERTY_NAME, this.configuration.jdbcUrl());
        }
        this.injectJdbcProperties(newDataSource, properties);
        return newDataSource;
    }

    private Driver newDriver() {
        if (this.configuration.connectionProviderClass() == null) {
            try {
                this.driver = DriverManager.getDriver(this.configuration.jdbcUrl());
                return this.driver;
            }
            catch (SQLException sql) {
                throw new RuntimeException("Unable to get java.sql.Driver from DriverManager", sql);
            }
        }
        try {
            this.driver = this.configuration.connectionProviderClass().asSubclass(Driver.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!this.driver.acceptsURL(this.configuration.jdbcUrl())) {
                ListenerHelper.fireOnWarning(this.listeners, "Driver does not support the provided URL: " + this.configuration.jdbcUrl());
            }
            return this.driver;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to instantiate java.sql.Driver", e);
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to verify that the java.sql.Driver supports the provided URL", e);
        }
    }

    private void injectUrlProperty(Object target, String propertyName, String propertyValue) {
        try {
            this.injector.inject(target, propertyName, propertyValue);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            if (propertyName.chars().anyMatch(Character::isLowerCase)) {
                this.injectUrlProperty(target, propertyName.toUpperCase(Locale.ROOT), propertyValue);
            }
            ListenerHelper.fireOnWarning(this.listeners, "Ignoring property '" + propertyName + "': " + e.getMessage());
        }
    }

    private void injectJdbcProperties(Object target, Properties properties) {
        boolean ignoring = false;
        for (String propertyName : properties.stringPropertyNames()) {
            try {
                this.injector.inject(target, propertyName, properties.getProperty(propertyName));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                ListenerHelper.fireOnWarning(this.listeners, "Ignoring property '" + propertyName + "': " + e.getMessage());
                ignoring = true;
            }
        }
        if (ignoring) {
            ListenerHelper.fireOnWarning(this.listeners, "Available properties " + Arrays.toString(this.injector.availableProperties().toArray()));
        }
    }

    private Properties jdbcProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.jdbcProperties);
        properties.putAll((Map<?, ?>)this.securityProperties(this.configuration.principal(), this.configuration.credentials()));
        return properties;
    }

    private Properties recoveryProperties() {
        Properties properties = new Properties();
        if (this.configuration.recoveryPrincipal() == null && (this.configuration.recoveryCredentials() == null || this.configuration.recoveryCredentials().isEmpty())) {
            properties.putAll((Map<?, ?>)this.securityProperties(this.configuration.principal(), this.configuration.credentials()));
        } else {
            properties.putAll((Map<?, ?>)this.securityProperties(this.configuration.recoveryPrincipal(), this.configuration.recoveryCredentials()));
        }
        return properties;
    }

    private Properties securityProperties(Principal principal, Iterable<Object> credentials) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.securityProperties(principal));
        for (Object credential : credentials) {
            properties.putAll((Map<?, ?>)this.securityProperties(credential));
        }
        return properties;
    }

    private Properties securityProperties(Object securityObject) {
        if (securityObject == null) {
            return EMPTY_PROPERTIES;
        }
        for (AgroalSecurityProvider provider : this.configuration.securityProviders()) {
            Properties properties = provider.getSecurityProperties(securityObject);
            if (properties == null) continue;
            return properties;
        }
        ListenerHelper.fireOnWarning(this.listeners, "Unknown security object of type: " + securityObject.getClass().getName());
        return EMPTY_PROPERTIES;
    }

    public XAConnection createConnection() throws SQLException {
        switch (this.factoryMode) {
            case DRIVER: {
                return new XAConnectionAdaptor(this.connectionSetup(this.driver.connect(this.configuration.jdbcUrl(), this.jdbcProperties())));
            }
            case DATASOURCE: {
                this.injectJdbcProperties(this.dataSource, this.securityProperties(this.configuration.principal(), this.configuration.credentials()));
                return new XAConnectionAdaptor(this.connectionSetup(this.dataSource.getConnection()));
            }
            case XA_DATASOURCE: {
                this.injectJdbcProperties(this.xaDataSource, this.securityProperties(this.configuration.principal(), this.configuration.credentials()));
                return this.xaConnectionSetup(this.xaDataSource.getXAConnection());
            }
        }
        throw new SQLException("Unknown connection factory mode");
    }

    private Connection connectionSetup(Connection connection) throws SQLException {
        if (connection == null) {
            throw new SQLException("Driver does not support the provided URL: " + this.configuration.jdbcUrl());
        }
        connection.setAutoCommit(this.configuration.autoCommit());
        if (this.configuration.jdbcTransactionIsolation().isDefined()) {
            connection.setTransactionIsolation(this.configuration.jdbcTransactionIsolation().level());
        }
        if (this.configuration.initialSql() != null && !this.configuration.initialSql().isEmpty()) {
            try (Statement statement = connection.createStatement();){
                statement.execute(this.configuration.initialSql());
            }
        }
        return connection;
    }

    private XAConnection xaConnectionSetup(XAConnection xaConnection) throws SQLException {
        if (xaConnection.getXAResource() == null) {
            xaConnection.close();
            throw new SQLException("null XAResource from XADataSource");
        }
        this.connectionSetup(xaConnection.getConnection());
        return xaConnection;
    }

    public XAConnection getRecoveryConnection() {
        try {
            if (this.factoryMode == Mode.XA_DATASOURCE) {
                this.injectJdbcProperties(this.xaRecoveryDataSource, this.recoveryProperties());
                return this.xaRecoveryDataSource.getXAConnection();
            }
            ListenerHelper.fireOnWarning(this.listeners, "Recovery connections are only available for XADataSource");
        }
        catch (SQLException e) {
            ListenerHelper.fireOnWarning(this.listeners, "Unable to get recovery connection: " + e.getMessage());
        }
        return null;
    }

    private static enum Mode {
        DRIVER,
        DATASOURCE,
        XA_DATASOURCE;


        static Mode fromClass(Class<?> providerClass) {
            if (providerClass == null) {
                return DRIVER;
            }
            if (XADataSource.class.isAssignableFrom(providerClass)) {
                return XA_DATASOURCE;
            }
            if (DataSource.class.isAssignableFrom(providerClass)) {
                return DATASOURCE;
            }
            if (Driver.class.isAssignableFrom(providerClass)) {
                return DRIVER;
            }
            throw new IllegalArgumentException("Unable to create ConnectionFactory from providerClass " + providerClass.getName());
        }
    }
}

