/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool.wrapper;

import io.agroal.pool.ConnectionHandler;
import io.agroal.pool.util.StampedCopyOnWriteArrayList;
import io.agroal.pool.wrapper.CallableStatementWrapper;
import io.agroal.pool.wrapper.PreparedStatementWrapper;
import io.agroal.pool.wrapper.StatementWrapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public final class ConnectionWrapper
implements Connection {
    private static final InvocationHandler CLOSED_HANDLER = (proxy, method, args) -> {
        switch (method.getName()) {
            case "abort": {
                return Void.TYPE;
            }
            case "close": {
                return Void.TYPE;
            }
            case "isClosed": {
                return Boolean.TRUE;
            }
            case "isValid": {
                return Boolean.FALSE;
            }
            case "toString": {
                return ConnectionWrapper.class.getSimpleName() + ".CLOSED_CONNECTION";
            }
        }
        throw new SQLException("Connection is closed");
    };
    private static final Connection CLOSED_CONNECTION = (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, CLOSED_HANDLER);
    private final Collection<Statement> trackedStatements = new StampedCopyOnWriteArrayList<Statement>(Statement.class);
    private final ConnectionHandler handler;
    private Connection wrappedConnection;
    private boolean trackStatements = true;

    public ConnectionWrapper(ConnectionHandler connectionHandler) {
        this.handler = connectionHandler;
        this.wrappedConnection = connectionHandler.getConnection();
    }

    public ConnectionHandler getHandler() {
        return this.handler;
    }

    private Statement trackStatement(Statement statement) {
        if (this.trackStatements && statement != null) {
            StatementWrapper wrappedStatement = new StatementWrapper(this, statement);
            this.trackedStatements.add(wrappedStatement);
            return wrappedStatement;
        }
        return statement;
    }

    private CallableStatement trackCallableStatement(CallableStatement statement) {
        if (this.trackStatements && statement != null) {
            CallableStatementWrapper wrappedStatement = new CallableStatementWrapper(this, statement);
            this.trackedStatements.add(wrappedStatement);
            return wrappedStatement;
        }
        return statement;
    }

    private PreparedStatement trackPreparedStatement(PreparedStatement statement) {
        if (this.trackStatements && statement != null) {
            PreparedStatementWrapper wrappedStatement = new PreparedStatementWrapper(this, statement);
            this.trackedStatements.add(wrappedStatement);
            return wrappedStatement;
        }
        return statement;
    }

    private void closeTrackedStatements() throws SQLException {
        if (!this.trackedStatements.isEmpty()) {
            for (Statement statement : this.trackedStatements) {
                statement.close();
            }
            this.trackedStatements.clear();
        }
    }

    public void releaseTrackedStatement(Statement statement) {
        this.trackedStatements.remove(statement);
    }

    @Override
    public void close() throws SQLException {
        if (this.wrappedConnection != CLOSED_CONNECTION) {
            this.wrappedConnection = CLOSED_CONNECTION;
            this.closeTrackedStatements();
            this.handler.onConnectionWrapperClose(this);
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.wrappedConnection = CLOSED_CONNECTION;
        this.wrappedConnection.abort(executor);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.wrappedConnection.getAutoCommit();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (autoCommit && this.handler.isEnlisted()) {
            throw new SQLException("Trying to set autocommit in connection taking part of transaction");
        }
        this.handler.deferredEnlistmentCheck();
        if (this.wrappedConnection.getAutoCommit() != autoCommit) {
            this.handler.setDirtyAttribute(ConnectionHandler.DirtyAttribute.AUTOCOMMIT);
            this.wrappedConnection.setAutoCommit(autoCommit);
        }
    }

    @Override
    public void commit() throws SQLException {
        if (this.handler.isEnlisted()) {
            throw new SQLException("Attempting to commit while taking part in a transaction");
        }
        this.wrappedConnection.commit();
    }

    @Override
    public void rollback() throws SQLException {
        if (this.handler.isEnlisted()) {
            throw new SQLException("Attempting to rollback while enlisted in a transaction");
        }
        this.handler.deferredEnlistmentCheck();
        this.wrappedConnection.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.handler.isEnlisted()) {
            throw new SQLException("Attempting to commit while enlisted in a transaction");
        }
        this.handler.deferredEnlistmentCheck();
        this.wrappedConnection.rollback(savepoint);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.handler.deferredEnlistmentCheck();
        this.wrappedConnection.clearWarnings();
    }

    @Override
    public Clob createClob() throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.wrappedConnection.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.wrappedConnection.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.wrappedConnection.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.wrappedConnection.createSQLXML();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.wrappedConnection.createArrayOf(typeName, elements);
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.trackStatement(this.wrappedConnection.createStatement());
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.trackStatement(this.wrappedConnection.createStatement(resultSetType, resultSetConcurrency));
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.trackStatement(this.wrappedConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.wrappedConnection.createStruct(typeName, attributes);
    }

    @Override
    public String getCatalog() throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.wrappedConnection.getCatalog();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        this.handler.setDirtyAttribute(ConnectionHandler.DirtyAttribute.CATALOG);
        this.wrappedConnection.setCatalog(catalog);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.wrappedConnection.getHoldability();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        this.wrappedConnection.setHoldability(holdability);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.wrappedConnection.getClientInfo();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.wrappedConnection.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.wrappedConnection.getClientInfo(name);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.wrappedConnection.getMetaData();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.wrappedConnection.getNetworkTimeout();
    }

    @Override
    public String getSchema() throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.wrappedConnection.getSchema();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        this.handler.setDirtyAttribute(ConnectionHandler.DirtyAttribute.SCHEMA);
        this.wrappedConnection.setSchema(schema);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.wrappedConnection.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        this.wrappedConnection.setTypeMap(map);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.wrappedConnection.getTransactionIsolation();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        this.handler.setDirtyAttribute(ConnectionHandler.DirtyAttribute.TRANSACTION_ISOLATION);
        this.wrappedConnection.setTransactionIsolation(level);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.wrappedConnection.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.wrappedConnection.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.wrappedConnection.isReadOnly();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        this.wrappedConnection.setReadOnly(readOnly);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.wrappedConnection.isValid(timeout);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.wrappedConnection.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.trackCallableStatement(this.wrappedConnection.prepareCall(sql));
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.trackCallableStatement(this.wrappedConnection.prepareCall(sql, resultSetType, resultSetConcurrency));
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.trackCallableStatement(this.wrappedConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.trackPreparedStatement(this.wrappedConnection.prepareStatement(sql));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.trackPreparedStatement(this.wrappedConnection.prepareStatement(sql, resultSetType, resultSetConcurrency));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.trackPreparedStatement(this.wrappedConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.trackPreparedStatement(this.wrappedConnection.prepareStatement(sql, autoGeneratedKeys));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.trackPreparedStatement(this.wrappedConnection.prepareStatement(sql, columnIndexes));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.trackPreparedStatement(this.wrappedConnection.prepareStatement(sql, columnNames));
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        this.wrappedConnection.releaseSavepoint(savepoint);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.wrappedConnection.setClientInfo(name, value);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.wrappedConnection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        return this.wrappedConnection.setSavepoint(name);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.handler.deferredEnlistmentCheck();
        this.handler.setDirtyAttribute(ConnectionHandler.DirtyAttribute.NETWORK_TIMEOUT);
        this.wrappedConnection.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public <T> T unwrap(Class<T> target) throws SQLException {
        return this.wrappedConnection.unwrap(target);
    }

    @Override
    public boolean isWrapperFor(Class<?> target) throws SQLException {
        return this.wrappedConnection.isWrapperFor(target);
    }

    public String toString() {
        return "wrapped[" + this.wrappedConnection + (this.handler.isEnlisted() ? "]<<enrolled" : "]");
    }
}

