/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool;

import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.security.AgroalSecurityProvider;
import io.agroal.api.transaction.TransactionIntegration;
import io.agroal.pool.util.ListenerHelper;
import io.agroal.pool.util.PropertyInjector;
import io.agroal.pool.util.XAConnectionAdaptor;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.BiConsumer;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;

public final class ConnectionFactory
implements TransactionIntegration.ResourceRecoveryFactory {
    private static final String URL_PROPERTY_NAME = "url";
    private static final XAResource[] NO_RESOURCES = new XAResource[0];
    private final AgroalConnectionFactoryConfiguration configuration;
    private final AgroalDataSourceListener[] listeners;
    private final Properties jdbcProperties;
    private final Properties recoveryProperties;
    private final Mode factoryMode;
    private Driver driver;
    private DataSource dataSource;
    private XADataSource xaDataSource;

    public ConnectionFactory(AgroalConnectionFactoryConfiguration configuration, AgroalDataSourceListener ... listeners) {
        this.configuration = configuration;
        this.listeners = listeners;
        this.jdbcProperties = new Properties();
        this.recoveryProperties = new Properties();
        configuration.jdbcProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)this.jdbcProperties::put));
        configuration.jdbcProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)this.recoveryProperties::put));
        this.setupSecurity(configuration);
        this.factoryMode = Mode.fromClass(configuration.connectionProviderClass());
        switch (this.factoryMode) {
            case XA_DATASOURCE: {
                this.xaDataSource = this.newXADataSource(this.jdbcProperties);
                break;
            }
            case DATASOURCE: {
                this.dataSource = this.newDataSource(this.jdbcProperties);
                break;
            }
            case DRIVER: {
                this.driver = this.newDriver();
            }
        }
    }

    private XADataSource newXADataSource(Properties properties) {
        XADataSource newDataSource;
        try {
            newDataSource = this.configuration.connectionProviderClass().asSubclass(XADataSource.class).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unable to instantiate javax.sql.XADataSource", e);
        }
        PropertyInjector injector = new PropertyInjector(this.configuration.connectionProviderClass());
        if (this.configuration.jdbcUrl() != null && !this.configuration.jdbcUrl().isEmpty()) {
            this.injectProperty(injector, newDataSource, URL_PROPERTY_NAME, this.configuration.jdbcUrl());
        }
        this.injectJdbcProperties(injector, newDataSource, properties);
        return newDataSource;
    }

    private DataSource newDataSource(Properties properties) {
        DataSource newDataSource;
        try {
            newDataSource = this.configuration.connectionProviderClass().asSubclass(DataSource.class).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unable to instantiate javax.sql.DataSource", e);
        }
        PropertyInjector injector = new PropertyInjector(this.configuration.connectionProviderClass());
        if (this.configuration.jdbcUrl() != null && !this.configuration.jdbcUrl().isEmpty()) {
            this.injectProperty(injector, newDataSource, URL_PROPERTY_NAME, this.configuration.jdbcUrl());
        }
        this.injectJdbcProperties(injector, newDataSource, properties);
        return newDataSource;
    }

    private Driver newDriver() {
        if (this.configuration.connectionProviderClass() == null) {
            try {
                this.driver = DriverManager.getDriver(this.configuration.jdbcUrl());
                return this.driver;
            }
            catch (SQLException sql) {
                throw new RuntimeException("Unable to get java.sql.Driver from DriverManager", sql);
            }
        }
        try {
            this.driver = this.configuration.connectionProviderClass().asSubclass(Driver.class).newInstance();
            if (!this.driver.acceptsURL(this.configuration.jdbcUrl())) {
                ListenerHelper.fireOnWarning(this.listeners, "Driver does not support the provided URL: " + this.configuration.jdbcUrl());
            }
            return this.driver;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unable to instantiate java.sql.Driver", e);
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to verify that the java.sql.Driver supports the provided URL", e);
        }
    }

    private void injectProperty(PropertyInjector injector, Object target, String propertyName, String propertyValue) {
        try {
            injector.inject(target, propertyName, propertyValue);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            ListenerHelper.fireOnWarning(this.listeners, "Ignoring property '" + propertyName + "': " + e.getMessage());
        }
    }

    private void injectJdbcProperties(PropertyInjector injector, Object target, Properties properties) {
        boolean ignoring = false;
        for (String propertyName : properties.stringPropertyNames()) {
            try {
                injector.inject(target, propertyName, properties.getProperty(propertyName));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                ListenerHelper.fireOnWarning(this.listeners, "Ignoring property '" + propertyName + "': " + e.getMessage());
                ignoring = true;
            }
        }
        if (ignoring) {
            ListenerHelper.fireOnWarning(this.listeners, "Available properties " + Arrays.toString(injector.availableProperties().toArray()));
        }
    }

    private void setupSecurity(AgroalConnectionFactoryConfiguration configuration) {
        this.setupSecurity(this.jdbcProperties, configuration.principal(), configuration.credentials());
        if (configuration.recoveryPrincipal() == null && (configuration.recoveryCredentials() == null || configuration.recoveryCredentials().isEmpty())) {
            this.setupSecurity(this.recoveryProperties, configuration.principal(), configuration.credentials());
        } else {
            this.setupSecurity(this.recoveryProperties, configuration.recoveryPrincipal(), configuration.recoveryCredentials());
        }
    }

    private void setupSecurity(Properties properties, Principal principal, Iterable<Object> credentials) {
        for (AgroalSecurityProvider provider : ServiceLoader.load(AgroalSecurityProvider.class, AgroalSecurityProvider.class.getClassLoader())) {
            properties.putAll((Map<?, ?>)provider.getSecurityProperties((Object)principal));
        }
        for (Object credential : credentials) {
            for (AgroalSecurityProvider provider : ServiceLoader.load(AgroalSecurityProvider.class, AgroalSecurityProvider.class.getClassLoader())) {
                properties.putAll((Map<?, ?>)provider.getSecurityProperties(credential));
            }
        }
    }

    public XAConnection createConnection() throws SQLException {
        switch (this.factoryMode) {
            case DRIVER: {
                return new XAConnectionAdaptor(this.connectionSetup(this.driver.connect(this.configuration.jdbcUrl(), this.jdbcProperties)));
            }
            case DATASOURCE: {
                return new XAConnectionAdaptor(this.connectionSetup(this.dataSource.getConnection()));
            }
            case XA_DATASOURCE: {
                return this.xaConnectionSetup(this.xaDataSource.getXAConnection());
            }
        }
        throw new SQLException("Unknown connection factory mode");
    }

    private Connection connectionSetup(Connection connection) throws SQLException {
        if (connection == null) {
            throw new SQLException("Driver does not support the provided URL: " + this.configuration.jdbcUrl());
        }
        connection.setAutoCommit(this.configuration.autoCommit());
        if (this.configuration.jdbcTransactionIsolation().isDefined()) {
            connection.setTransactionIsolation(this.configuration.jdbcTransactionIsolation().level());
        }
        if (this.configuration.initialSql() != null && !this.configuration.initialSql().isEmpty()) {
            try (Statement statement = connection.createStatement();){
                statement.execute(this.configuration.initialSql());
            }
        }
        return connection;
    }

    private XAConnection xaConnectionSetup(XAConnection xaConnection) throws SQLException {
        if (xaConnection.getXAResource() == null) {
            xaConnection.close();
            throw new SQLException("null XAResource from XADataSource");
        }
        this.connectionSetup(xaConnection.getConnection());
        return xaConnection;
    }

    public XAResource[] recoveryResources() {
        try {
            if (this.factoryMode == Mode.XA_DATASOURCE) {
                return new XAResource[]{this.newXADataSource(this.recoveryProperties).getXAConnection().getXAResource()};
            }
            ListenerHelper.fireOnWarning(this.listeners, "Recovery connections are only available for XADataSource");
        }
        catch (SQLException e) {
            ListenerHelper.fireOnWarning(this.listeners, "Unable to get recovery connection: " + e.getMessage());
        }
        return NO_RESOURCES;
    }

    private static enum Mode {
        DRIVER,
        DATASOURCE,
        XA_DATASOURCE;


        private static Mode fromClass(Class<?> providerClass) {
            if (providerClass == null) {
                return DRIVER;
            }
            if (XADataSource.class.isAssignableFrom(providerClass)) {
                return XA_DATASOURCE;
            }
            if (DataSource.class.isAssignableFrom(providerClass)) {
                return DATASOURCE;
            }
            if (Driver.class.isAssignableFrom(providerClass)) {
                return DRIVER;
            }
            throw new IllegalArgumentException("Unable to create ConnectionFactory from providerClass " + providerClass.getName());
        }
    }
}

