/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool.util;

import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;

public final class PriorityScheduledExecutor
extends ScheduledThreadPoolExecutor {
    private static final Runnable EMPTY_TASK = new Runnable(){

        @Override
        public void run() {
        }
    };
    private final Queue<RunnableFuture<?>> priorityTasks = new ConcurrentLinkedQueue();

    public PriorityScheduledExecutor(int executorSize, String threadPrefix) {
        super(executorSize, new PriorityExecutorThreadFactory(threadPrefix), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void executeNow(Runnable priorityTask) {
        this.executeNow(new FutureTask<Object>(priorityTask, null));
    }

    public <T> Future<T> executeNow(Callable<T> priorityTask) {
        return this.executeNow(new FutureTask<T>(priorityTask));
    }

    public <T> Future<T> executeNow(RunnableFuture<T> priorityFuture) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException("Task " + priorityFuture + " rejected from " + this);
        }
        this.priorityTasks.add(priorityFuture);
        if (!priorityFuture.isDone()) {
            this.execute(EMPTY_TASK);
        }
        return priorityFuture;
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable lowPriorityTask) {
        RunnableFuture<?> priorityTask;
        while ((priorityTask = this.priorityTasks.poll()) != null) {
            if (this.isShutdown()) {
                priorityTask.cancel(false);
                continue;
            }
            priorityTask.run();
        }
        super.beforeExecute(thread, lowPriorityTask);
    }

    @Override
    public void shutdown() {
        if (!this.isShutdown()) {
            this.executeNow(() -> super.shutdown());
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        for (RunnableFuture runnableFuture : this.priorityTasks) {
            runnableFuture.cancel(true);
        }
        this.priorityTasks.clear();
        return super.shutdownNow();
    }

    private static class PriorityExecutorThreadFactory
    implements ThreadFactory {
        private final AtomicLong threadCount;
        private final String threadPrefix;

        public PriorityExecutorThreadFactory(String threadPrefix) {
            this.threadPrefix = threadPrefix;
            this.threadCount = new AtomicLong();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, this.threadPrefix + this.threadCount.incrementAndGet());
            thread.setDaemon(true);
            return thread;
        }
    }
}

