/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.agroal.api.transaction.TransactionAware;
import io.agroal.api.transaction.TransactionIntegration;
import io.agroal.pool.ConnectionFactory;
import io.agroal.pool.ConnectionHandler;
import io.agroal.pool.DefaultMetricsRepository;
import io.agroal.pool.MetricsRepository;
import io.agroal.pool.Pool;
import io.agroal.pool.util.AgroalSynchronizer;
import io.agroal.pool.util.ListenerHelper;
import io.agroal.pool.util.StampedCopyOnWriteArrayList;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAccumulator;

public final class Poolless
implements Pool {
    private final AgroalConnectionPoolConfiguration configuration;
    private final AgroalDataSourceListener[] listeners;
    private final StampedCopyOnWriteArrayList<ConnectionHandler> allConnections;
    private final AgroalSynchronizer synchronizer;
    private final ConnectionFactory connectionFactory;
    private final TransactionIntegration transactionIntegration;
    private final LongAccumulator maxUsed = new LongAccumulator(Math::max, Long.MIN_VALUE);
    private final AtomicInteger activeCount = new AtomicInteger();
    private MetricsRepository metricsRepository;
    private volatile boolean shutdown;

    public Poolless(AgroalConnectionPoolConfiguration configuration, AgroalDataSourceListener ... listeners) {
        this.configuration = configuration;
        this.listeners = listeners;
        this.allConnections = new StampedCopyOnWriteArrayList<ConnectionHandler>(ConnectionHandler.class);
        this.synchronizer = new AgroalSynchronizer();
        this.connectionFactory = new ConnectionFactory(configuration.connectionFactoryConfiguration(), listeners);
        this.transactionIntegration = configuration.transactionIntegration();
    }

    @Override
    public void init() {
        if (!this.configuration.maxLifetime().isZero()) {
            ListenerHelper.fireOnWarning(this.listeners, "Max lifetime not supported in pool-less mode");
        }
        if (!this.configuration.idleValidationTimeout().isZero()) {
            ListenerHelper.fireOnWarning(this.listeners, "Idle validation not supported in pool-less mode");
        }
        if (!this.configuration.leakTimeout().isZero()) {
            ListenerHelper.fireOnWarning(this.listeners, "Leak detection not supported in pool-less mode");
        }
        if (!this.configuration.reapTimeout().isZero()) {
            ListenerHelper.fireOnWarning(this.listeners, "Connection reap not supported in pool-less mode");
        }
        if (this.configuration.initialSize() != 0) {
            ListenerHelper.fireOnWarning(this.listeners, "Initial size is zero in pool-less mode");
        }
        if (this.configuration.minSize() != 0) {
            ListenerHelper.fireOnWarning(this.listeners, "Min size always zero in pool-less mode");
        }
        this.transactionIntegration.addResourceRecoveryFactory((TransactionIntegration.ResourceRecoveryFactory)this.connectionFactory);
    }

    @Override
    public AgroalConnectionPoolConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public AgroalDataSourceListener[] getListeners() {
        return this.listeners;
    }

    @Override
    public void close() {
        this.transactionIntegration.removeResourceRecoveryFactory((TransactionIntegration.ResourceRecoveryFactory)this.connectionFactory);
        this.shutdown = true;
        for (ConnectionHandler handler : this.allConnections) {
            handler.setState(ConnectionHandler.State.FLUSH);
            this.destroyConnection(handler);
        }
        this.allConnections.clear();
        this.synchronizer.release(this.synchronizer.getQueueLength());
    }

    @Override
    public Connection getConnection() throws SQLException {
        ListenerHelper.fireBeforeConnectionAcquire(this.listeners);
        long metricsStamp = this.metricsRepository.beforeConnectionAcquire();
        if (this.shutdown) {
            throw new SQLException("This pool is closed and does not handle any more connections!");
        }
        ConnectionHandler checkedOutHandler = this.handlerFromTransaction();
        if (checkedOutHandler == null) {
            checkedOutHandler = this.handlerFromSharedCache();
        }
        this.metricsRepository.afterConnectionAcquire(metricsStamp);
        ListenerHelper.fireOnConnectionAcquired(this.listeners, checkedOutHandler);
        this.transactionIntegration.associate((TransactionAware)checkedOutHandler, checkedOutHandler.getXaResource());
        return checkedOutHandler.newConnectionWrapper();
    }

    private ConnectionHandler handlerFromTransaction() throws SQLException {
        return (ConnectionHandler)this.transactionIntegration.getTransactionAware();
    }

    private ConnectionHandler handlerFromSharedCache() throws SQLException {
        long remaining = this.configuration.acquisitionTimeout().toNanos();
        remaining = remaining > 0L ? remaining : Long.MAX_VALUE;
        try {
            while (true) {
                if (this.activeCount.incrementAndGet() <= this.configuration.maxSize()) {
                    return this.createConnection();
                }
                this.activeCount.decrementAndGet();
                long synchronizationStamp = this.synchronizer.getStamp();
                long start = System.nanoTime();
                if (remaining < 0L || !this.synchronizer.tryAcquireNanos(synchronizationStamp, remaining)) {
                    throw new SQLException("Sorry, acquisition timeout!");
                }
                if (this.shutdown) {
                    throw new SQLException("Can't create new connection as the pool is shutting down");
                }
                remaining -= System.nanoTime() - start;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLException("Interrupted while acquiring");
        }
    }

    @Override
    public void returnConnectionHandler(ConnectionHandler handler) throws SQLException {
        ListenerHelper.fireBeforeConnectionReturn(this.listeners, handler);
        if (this.transactionIntegration.disassociate((TransactionAware)handler)) {
            this.activeCount.decrementAndGet();
            this.synchronizer.releaseConditional();
            this.flushHandler(handler);
        }
    }

    public void onMetricsEnabled(boolean metricsEnabled) {
        this.setMetricsRepository(metricsEnabled ? new DefaultMetricsRepository(this) : new MetricsRepository.EmptyMetricsRepository());
    }

    @Override
    public MetricsRepository getMetrics() {
        return this.metricsRepository;
    }

    public void setMetricsRepository(MetricsRepository metricsRepository) {
        this.metricsRepository = metricsRepository;
    }

    @Override
    public long activeCount() {
        return this.allConnections.size();
    }

    @Override
    public long availableCount() {
        return 0L;
    }

    @Override
    public long maxUsedCount() {
        return this.maxUsed.get();
    }

    @Override
    public void resetMaxUsedCount() {
        this.maxUsed.reset();
    }

    @Override
    public long awaitingCount() {
        return this.synchronizer.getQueueLength();
    }

    public ConnectionHandler createConnection() throws SQLException {
        ListenerHelper.fireBeforeConnectionCreation(this.listeners);
        long metricsStamp = this.metricsRepository.beforeConnectionCreation();
        try {
            ConnectionHandler handler = new ConnectionHandler(this.connectionFactory.createConnection(), this);
            ListenerHelper.fireOnConnectionCreation(this.listeners, handler);
            this.metricsRepository.afterConnectionCreation(metricsStamp);
            handler.setState(ConnectionHandler.State.CHECKED_OUT);
            this.allConnections.add(handler);
            this.maxUsed.accumulate(this.allConnections.size());
            ListenerHelper.fireOnConnectionPooled(this.listeners, handler);
            return handler;
        }
        catch (SQLException e) {
            ListenerHelper.fireOnWarning(this.listeners, e);
            throw e;
        }
    }

    @Override
    public void flushPool(AgroalDataSource.FlushMode mode) {
        if (mode == AgroalDataSource.FlushMode.ALL) {
            for (ConnectionHandler handler : this.allConnections) {
                ListenerHelper.fireBeforeConnectionFlush(this.listeners, handler);
                this.flushHandler(handler);
            }
        }
    }

    public void flushHandler(ConnectionHandler handler) {
        handler.setState(ConnectionHandler.State.FLUSH);
        this.allConnections.remove(handler);
        this.metricsRepository.afterConnectionFlush();
        ListenerHelper.fireOnConnectionFlush(this.listeners, handler);
        this.destroyConnection(handler);
    }

    public void destroyConnection(ConnectionHandler handler) {
        ListenerHelper.fireBeforeConnectionDestroy(this.listeners, handler);
        try {
            handler.closeConnection();
        }
        catch (SQLException e) {
            ListenerHelper.fireOnWarning(this.listeners, e);
        }
        handler.setState(ConnectionHandler.State.DESTROYED);
        this.metricsRepository.afterConnectionDestroy();
        ListenerHelper.fireOnConnectionDestroy(this.listeners, handler);
    }
}

