/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool.wrapper;

import io.agroal.pool.util.StampedCopyOnWriteArrayList;
import io.agroal.pool.wrapper.ConnectionWrapper;
import io.agroal.pool.wrapper.ResultSetWrapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collection;

public class StatementWrapper
implements Statement {
    private static final InvocationHandler CLOSED_HANDLER = new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "close": {
                    return Void.TYPE;
                }
                case "isClosed": {
                    return Boolean.TRUE;
                }
                case "toString": {
                    return StatementWrapper.class.getSimpleName() + ".CLOSED_STATEMENT";
                }
            }
            throw new SQLException("Statement is closed");
        }
    };
    private static final Statement CLOSED_STATEMENT = (Statement)Proxy.newProxyInstance(Statement.class.getClassLoader(), new Class[]{Statement.class}, CLOSED_HANDLER);
    protected final ConnectionWrapper connection;
    private final Collection<ResultSet> trackedResultSets;
    private Statement wrappedStatement;

    public StatementWrapper(ConnectionWrapper connectionWrapper, Statement statement, boolean trackResources) {
        this.connection = connectionWrapper;
        this.wrappedStatement = statement;
        this.trackedResultSets = trackResources ? new StampedCopyOnWriteArrayList<ResultSet>(ResultSet.class) : null;
    }

    protected ResultSet trackResultSet(ResultSet resultSet) {
        if (this.trackedResultSets != null && resultSet != null) {
            ResultSetWrapper wrappedResultSet = new ResultSetWrapper(this, resultSet);
            this.trackedResultSets.add(wrappedResultSet);
            return wrappedResultSet;
        }
        return resultSet;
    }

    protected void closeTrackedResultSets() throws SQLException {
        if (this.trackedResultSets != null && !this.trackedResultSets.isEmpty()) {
            for (ResultSet resultSet : this.trackedResultSets) {
                resultSet.close();
            }
            this.trackedResultSets.clear();
        }
    }

    public void releaseTrackedResultSet(ResultSet resultSet) {
        if (this.trackedResultSets != null) {
            this.trackedResultSets.remove(resultSet);
        }
    }

    public int trackedResultSetSize() {
        return this.trackedResultSets != null ? this.trackedResultSets.size() : 0;
    }

    ConnectionWrapper getConnectionWrapper() throws SQLException {
        return this.connection;
    }

    @Override
    public void close() throws SQLException {
        try {
            if (this.wrappedStatement != CLOSED_STATEMENT) {
                this.closeTrackedResultSets();
                this.wrappedStatement.close();
            }
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
        finally {
            this.connection.releaseTrackedStatement(this);
            this.wrappedStatement = CLOSED_STATEMENT;
        }
    }

    @Override
    public final void clearWarnings() throws SQLException {
        try {
            this.wrappedStatement.clearWarnings();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final ResultSet executeQuery(String sql) throws SQLException {
        try {
            return this.trackResultSet(this.wrappedStatement.executeQuery(sql));
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final int executeUpdate(String sql) throws SQLException {
        try {
            return this.wrappedStatement.executeUpdate(sql);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final int getMaxFieldSize() throws SQLException {
        try {
            return this.wrappedStatement.getMaxFieldSize();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final void setMaxFieldSize(int max) throws SQLException {
        try {
            this.wrappedStatement.setMaxFieldSize(max);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final int getMaxRows() throws SQLException {
        try {
            return this.wrappedStatement.getMaxRows();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final void setMaxRows(int max) throws SQLException {
        try {
            this.wrappedStatement.setMaxRows(max);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            this.wrappedStatement.setEscapeProcessing(enable);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final int getQueryTimeout() throws SQLException {
        try {
            return this.wrappedStatement.getQueryTimeout();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final void setQueryTimeout(int seconds) throws SQLException {
        try {
            this.wrappedStatement.setQueryTimeout(seconds);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final void cancel() throws SQLException {
        try {
            this.wrappedStatement.cancel();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final void setCursorName(String name) throws SQLException {
        try {
            this.wrappedStatement.setCursorName(name);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final boolean execute(String sql) throws SQLException {
        try {
            return this.wrappedStatement.execute(sql);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final ResultSet getResultSet() throws SQLException {
        try {
            return this.trackResultSet(this.wrappedStatement.getResultSet());
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final int getUpdateCount() throws SQLException {
        try {
            return this.wrappedStatement.getUpdateCount();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final boolean getMoreResults() throws SQLException {
        try {
            return this.wrappedStatement.getMoreResults();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final int getFetchDirection() throws SQLException {
        try {
            return this.wrappedStatement.getFetchDirection();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final void setFetchDirection(int direction) throws SQLException {
        try {
            this.wrappedStatement.setFetchDirection(direction);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final int getFetchSize() throws SQLException {
        try {
            return this.wrappedStatement.getFetchSize();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final void setFetchSize(int rows) throws SQLException {
        try {
            this.wrappedStatement.setFetchSize(rows);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final int getResultSetConcurrency() throws SQLException {
        try {
            return this.wrappedStatement.getResultSetConcurrency();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final int getResultSetType() throws SQLException {
        try {
            return this.wrappedStatement.getResultSetType();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final void addBatch(String sql) throws SQLException {
        try {
            this.wrappedStatement.addBatch(sql);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final void clearBatch() throws SQLException {
        try {
            this.wrappedStatement.clearBatch();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final int[] executeBatch() throws SQLException {
        try {
            return this.wrappedStatement.executeBatch();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public final boolean getMoreResults(int current) throws SQLException {
        try {
            return this.wrappedStatement.getMoreResults(current);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final ResultSet getGeneratedKeys() throws SQLException {
        try {
            return this.trackResultSet(this.wrappedStatement.getGeneratedKeys());
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.wrappedStatement.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.wrappedStatement.executeUpdate(sql, columnIndexes);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            return this.wrappedStatement.executeUpdate(sql, columnNames);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.wrappedStatement.execute(sql, autoGeneratedKeys);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.wrappedStatement.execute(sql, columnIndexes);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            return this.wrappedStatement.execute(sql, columnNames);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final int getResultSetHoldability() throws SQLException {
        try {
            return this.wrappedStatement.getResultSetHoldability();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final boolean isPoolable() throws SQLException {
        try {
            return this.wrappedStatement.isPoolable();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final void setPoolable(boolean poolable) throws SQLException {
        try {
            this.wrappedStatement.setPoolable(poolable);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final void closeOnCompletion() throws SQLException {
        try {
            this.wrappedStatement.closeOnCompletion();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final boolean isCloseOnCompletion() throws SQLException {
        try {
            return this.wrappedStatement.isCloseOnCompletion();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        try {
            return this.wrappedStatement.getWarnings();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final boolean isClosed() throws SQLException {
        try {
            return this.wrappedStatement.isClosed();
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final <T> T unwrap(Class<T> target) throws SQLException {
        try {
            return this.wrappedStatement.unwrap(target);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    @Override
    public final boolean isWrapperFor(Class<?> target) throws SQLException {
        try {
            return this.wrappedStatement.isWrapperFor(target);
        }
        catch (SQLException se) {
            this.connection.getHandler().setFlushOnly(se);
            throw se;
        }
    }

    public final String toString() {
        return "wrapped[ " + this.wrappedStatement + " ]";
    }
}

