/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool.util;

import io.agroal.api.AgroalPoolInterceptor;
import io.agroal.pool.ConnectionHandler;
import io.agroal.pool.wrapper.ConnectionWrapper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public final class InterceptorHelper {
    private InterceptorHelper() {
    }

    public static void fireOnConnectionAcquiredInterceptor(List<AgroalPoolInterceptor> interceptors, ConnectionHandler handler) throws SQLException {
        if (interceptors != null && interceptors.size() > 0) {
            for (AgroalPoolInterceptor interceptor : interceptors) {
                ConnectionWrapper connection = handler.newDetachedConnectionWrapper();
                Throwable throwable = null;
                try {
                    interceptor.onConnectionAcquire((Connection)connection);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (connection == null) continue;
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    connection.close();
                }
            }
        }
    }

    public static void fireOnConnectionReturnInterceptor(List<AgroalPoolInterceptor> interceptors, ConnectionHandler handler) throws SQLException {
        if (interceptors != null && interceptors.size() > 0) {
            int i = interceptors.size();
            while (i > 0) {
                ConnectionWrapper connection = handler.newDetachedConnectionWrapper();
                Throwable throwable = null;
                try {
                    interceptors.get(--i).onConnectionReturn((Connection)connection);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (connection == null) continue;
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    connection.close();
                }
            }
        }
    }
}

