/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public final class StampedCopyOnWriteArrayList<T>
implements List<T> {
    private final Iterator<T> emptyIterator = new Iterator<T>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException();
        }
    };
    private final StampedLock lock;
    private long optimisticStamp;
    private T[] data;

    public StampedCopyOnWriteArrayList(Class<? extends T> clazz) {
        this.data = (Object[])Array.newInstance(clazz, 0);
        this.lock = new StampedLock();
        this.optimisticStamp = this.lock.tryOptimisticRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T[] getUnderlyingArray() {
        T[] array = this.data;
        if (this.lock.validate(this.optimisticStamp)) {
            return array;
        }
        long stamp = this.lock.readLock();
        try {
            T[] TArray = this.data;
            return TArray;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    @Override
    public T get(int index) {
        return this.getUnderlyingArray()[index];
    }

    @Override
    public int size() {
        return this.getUnderlyingArray().length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T set(int index, T element) {
        long stamp = this.lock.writeLock();
        try {
            T old = this.data[index];
            this.data[index] = element;
            T t = old;
            return t;
        }
        finally {
            this.optimisticStamp = this.lock.tryConvertToOptimisticRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T element) {
        long stamp = this.lock.writeLock();
        try {
            this.data = Arrays.copyOf(this.data, this.data.length + 1);
            this.data[this.data.length - 1] = element;
            boolean bl = true;
            return bl;
        }
        finally {
            this.optimisticStamp = this.lock.tryConvertToOptimisticRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T removeLast() {
        long stamp = this.lock.writeLock();
        try {
            T element = this.data[this.data.length - 1];
            this.data = Arrays.copyOf(this.data, this.data.length - 1);
            T t = element;
            return t;
        }
        finally {
            this.optimisticStamp = this.lock.tryConvertToOptimisticRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object element) {
        int index = this.indexOf(element);
        if (index == -1) {
            return false;
        }
        long stamp = this.lock.writeLock();
        try {
            if (index >= this.data.length || element != this.data[index]) {
                for (index = 0; index < this.data.length && element != this.data[index]; ++index) {
                }
                if (index == this.data.length) {
                    boolean bl = false;
                    return bl;
                }
            }
            T[] newData = Arrays.copyOf(this.data, this.data.length - 1);
            if (this.data.length - index - 1 != 0) {
                System.arraycopy(this.data, index + 1, newData, index, this.data.length - index - 1);
            }
            this.data = newData;
            boolean bl = true;
            return bl;
        }
        finally {
            this.optimisticStamp = this.lock.tryConvertToOptimisticRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove(int index) {
        long stamp = this.lock.writeLock();
        try {
            T old = this.data[index];
            T[] array = Arrays.copyOf(this.data, this.data.length - 1);
            if (this.data.length - index - 1 != 0) {
                System.arraycopy(this.data, index + 1, array, index, this.data.length - index - 1);
            }
            this.data = array;
            T t = old;
            return t;
        }
        finally {
            this.optimisticStamp = this.lock.tryConvertToOptimisticRead(stamp);
        }
    }

    @Override
    public void clear() {
        long stamp = this.lock.writeLock();
        try {
            this.data = Arrays.copyOf(this.data, 0);
        }
        finally {
            this.optimisticStamp = this.lock.tryConvertToOptimisticRead(stamp);
        }
    }

    @Override
    public Iterator<T> iterator() {
        T[] array = this.getUnderlyingArray();
        return array.length == 0 ? this.emptyIterator : new UncheckedIterator<T>(array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> c) {
        long stamp = this.lock.writeLock();
        try {
            int oldSize = this.data.length;
            this.data = Arrays.copyOf(this.data, oldSize + c.size());
            for (T element : c) {
                this.data[oldSize++] = element;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.optimisticStamp = this.lock.tryConvertToOptimisticRead(stamp);
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public int indexOf(Object o) {
        T[] array = this.getUnderlyingArray();
        for (int i = 0; i < array.length; ++i) {
            if (o != array[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        for (T element : this) {
            action.accept(element);
        }
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<T> stream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<T> parallelStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Spliterator<T> spliterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sort(Comparator<? super T> c) {
        throw new UnsupportedOperationException();
    }

    private static final class UncheckedIterator<T>
    implements Iterator<T> {
        private final int size;
        private final T[] data;
        private int index = 0;

        public UncheckedIterator(T[] array) {
            this.data = array;
            this.size = this.data.length;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public T next() {
            if (this.index < this.size) {
                return this.data[this.index++];
            }
            throw new NoSuchElementException("No more elements in this list");
        }
    }
}

