/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.springframework.boot;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.AgroalDataSourceMetrics;
import io.agroal.api.AgroalPoolInterceptor;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.agroal.api.configuration.supplier.AgroalConnectionFactoryConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalConnectionPoolConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalDataSourceConfigurationSupplier;
import io.agroal.api.security.NamePrincipal;
import io.agroal.api.security.SimplePassword;
import io.agroal.api.transaction.TransactionIntegration;
import io.agroal.narayana.NarayanaTransactionIntegration;
import java.io.PrintWriter;
import java.security.Principal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.jta.JtaTransactionManager;

public class AgroalDataSource
implements io.agroal.api.AgroalDataSource,
InitializingBean {
    private static final long serialVersionUID = 3633107290245258196L;
    private final Log logger = LogFactory.getLog(AgroalDataSource.class);
    private final AgroalDataSourceConfigurationSupplier datasourceConfiguration = new AgroalDataSourceConfigurationSupplier();
    private final AgroalConnectionPoolConfigurationSupplier connectionPoolConfiguration = new AgroalConnectionPoolConfigurationSupplier();
    private final AgroalConnectionFactoryConfigurationSupplier connectionFactoryConfiguration = new AgroalConnectionFactoryConfigurationSupplier();
    private io.agroal.api.AgroalDataSource delegate;
    private String datasourceName = "<default>";

    public AgroalDataSource() {
        this.connectionPoolConfiguration.maxSize(10);
    }

    public void afterPropertiesSet() throws SQLException {
        this.connectionPoolConfiguration.connectionFactoryConfiguration((Supplier)this.connectionFactoryConfiguration);
        this.datasourceConfiguration.connectionPoolConfiguration((Supplier)this.connectionPoolConfiguration);
        this.delegate = io.agroal.api.AgroalDataSource.from((Supplier)this.datasourceConfiguration, (AgroalDataSourceListener[])new AgroalDataSourceListener[]{new LoggingListener(this.datasourceName)});
        this.logger.info((Object)("Started DataSource " + this.datasourceName + " connected to " + this.getConfiguration().connectionPoolConfiguration().connectionFactoryConfiguration().jdbcUrl()));
    }

    public void setName(String name) {
        this.datasourceName = name;
    }

    public void setImplementation(String name) {
        this.datasourceConfiguration.dataSourceImplementation(AgroalDataSourceConfiguration.DataSourceImplementation.valueOf((String)name));
    }

    public void setMaxSize(int size) {
        this.connectionPoolConfiguration.maxSize(size);
    }

    public void setMinSize(int size) {
        this.connectionPoolConfiguration.minSize(size);
    }

    public void setInitialSize(int size) {
        this.connectionPoolConfiguration.initialSize(size);
    }

    public void setAcquisitionTimeout(int timeout) {
        this.connectionPoolConfiguration.acquisitionTimeout(Duration.ofSeconds(timeout));
    }

    public void setForegroundValidationTimeout(int timeout) {
        this.connectionPoolConfiguration.idleValidationTimeout(Duration.ofSeconds(timeout));
    }

    public void setIdleTimeout(int timeout) {
        this.connectionPoolConfiguration.reapTimeout(Duration.ofSeconds(timeout));
    }

    public void setLeakTimeout(int timeout) {
        this.connectionPoolConfiguration.leakTimeout(Duration.ofSeconds(timeout));
    }

    public void setLifetimeTimeout(int timeout) {
        this.connectionPoolConfiguration.maxLifetime(Duration.ofSeconds(timeout));
    }

    public void setValidationTimeout(int timeout) {
        this.connectionPoolConfiguration.validationTimeout(Duration.ofSeconds(timeout));
    }

    public void setJtaTransactionIntegration(JtaTransactionManager jtaPlatform) {
        this.connectionPoolConfiguration.transactionIntegration((TransactionIntegration)new NarayanaTransactionIntegration(jtaPlatform.getTransactionManager(), jtaPlatform.getTransactionSynchronizationRegistry()));
    }

    public void setEnhancedLeakReport(boolean enhanced) {
        this.connectionPoolConfiguration.enhancedLeakReport(enhanced);
    }

    public void setUrl(String url) {
        this.connectionFactoryConfiguration.jdbcUrl(url);
    }

    public void setDriverClass(Class<? extends DataSource> driver) {
        this.connectionFactoryConfiguration.connectionProviderClass(driver);
    }

    public void setDriverClassName(String driver) {
        this.connectionFactoryConfiguration.connectionProviderClassName(driver);
    }

    public void setUsername(String username) {
        this.connectionFactoryConfiguration.principal((Principal)new NamePrincipal(username));
    }

    public void setPassword(String password) {
        this.connectionFactoryConfiguration.credential((Object)new SimplePassword(password));
    }

    public void setInitialSql(String initialSql) {
        this.connectionFactoryConfiguration.initialSql(initialSql);
    }

    public void setAutoCommit(boolean autoCommit) {
        this.connectionFactoryConfiguration.autoCommit(autoCommit);
    }

    public void setTrackResources(boolean track) {
        this.connectionFactoryConfiguration.trackJdbcResources(track);
    }

    public void setRecoveryUsername(String username) {
        this.connectionFactoryConfiguration.recoveryPrincipal((Principal)new NamePrincipal(username));
    }

    public void setRecoveryPassword(String password) {
        this.connectionFactoryConfiguration.recoveryCredential((Object)new SimplePassword(password));
    }

    public AgroalDataSourceConfiguration getConfiguration() {
        return this.delegate.getConfiguration();
    }

    public AgroalDataSourceMetrics getMetrics() {
        return this.delegate.getMetrics();
    }

    public void setMetrics(boolean metrics) {
        this.datasourceConfiguration.metricsEnabled();
    }

    public void flush(AgroalDataSource.FlushMode mode) {
        this.delegate.flush(mode);
    }

    public List<AgroalPoolInterceptor> getPoolInterceptors() {
        return this.delegate.getPoolInterceptors();
    }

    public void setPoolInterceptors(Collection<? extends AgroalPoolInterceptor> interceptors) {
        this.delegate.setPoolInterceptors(interceptors);
    }

    public void close() {
        this.logger.debug((Object)("Closing DataSource " + this.datasourceName));
        this.delegate.close();
        this.delegate = null;
    }

    public Connection getConnection() throws SQLException {
        return this.delegate.getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.delegate.getConnection(username, password);
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this.delegate.unwrap(iface);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.delegate.isWrapperFor(iface);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.delegate.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.delegate.setLogWriter(out);
    }

    public int getLoginTimeout() throws SQLException {
        return this.delegate.getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.delegate.setLoginTimeout(seconds);
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.delegate.getParentLogger();
    }

    private static class LoggingListener
    implements AgroalDataSourceListener {
        private final Log logger;

        LoggingListener(String name) {
            this.logger = LogFactory.getLog((String)(io.agroal.api.AgroalDataSource.class.getName() + ".'" + name + "'"));
        }

        public void onWarning(String message) {
            this.logger.warn((Object)message);
        }

        public void onWarning(Throwable throwable) {
            this.logger.warn((Object)throwable);
        }

        public void onInfo(String message) {
            this.logger.info((Object)message);
        }

        public void onConnectionCreation(Connection connection) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Created connection " + connection));
            }
        }

        public void onConnectionAcquire(Connection connection) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Connection acquired " + connection));
            }
        }

        public void onConnectionReturn(Connection connection) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Connection return " + connection));
            }
        }

        public void onConnectionLeak(Connection connection, Thread thread) {
            this.logger.info((Object)("Connection " + connection + " leak! Acquired by " + thread.getName()));
            this.logger.info((Object)Arrays.stream(thread.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining(System.lineSeparator())));
        }

        public void beforeConnectionValidation(Connection connection) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Performing validation of " + connection));
            }
        }

        public void onConnectionInvalid(Connection connection) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Connection invalid " + connection));
            }
        }

        public void onConnectionReap(Connection connection) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Connection reap " + connection));
            }
        }

        public void onConnectionDestroy(Connection connection) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Connection destroy " + connection));
            }
        }
    }
}

