/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.springframework.boot.health;

import io.agroal.api.AgroalDataSource;
import io.agroal.springframework.boot.AgroalDataSourceAutoConfiguration;
import io.agroal.springframework.boot.health.AgroalDataSourceHealthIndicator;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.jdbc.DataSourceHealthContributorAutoConfiguration;
import org.springframework.boot.actuate.health.CompositeHealthContributor;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.util.Assert;

@AutoConfiguration(before={DataSourceHealthContributorAutoConfiguration.class}, after={AgroalDataSourceAutoConfiguration.class})
@ConditionalOnClass(value={DataSourceHealthContributorAutoConfiguration.class, AgroalDataSource.class})
@ConditionalOnBean(value={AgroalDataSource.class})
@ConditionalOnEnabledHealthIndicator(value="db")
public class AgroalDataSourceHealthContributorAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"dbHealthIndicator", "dbHealthContributor"})
    public HealthContributor dbHealthContributor(Map<String, AgroalDataSource> dataSources) {
        return this.createContributor(dataSources);
    }

    private HealthContributor createContributor(Map<String, AgroalDataSource> beans) {
        Assert.notEmpty(beans, (String)"Beans must not be empty");
        if (beans.size() == 1) {
            return this.createContributor(beans.values().iterator().next());
        }
        return CompositeHealthContributor.fromMap(beans, this::createContributor);
    }

    private HealthContributor createContributor(AgroalDataSource source) {
        return new AgroalDataSourceHealthIndicator(source);
    }
}

