/*
 * Decompiled with CFR 0.152.
 */
package io.airbrake.javabrake;

import io.airbrake.javabrake.Airbrake;
import io.airbrake.javabrake.AsyncSender;
import io.airbrake.javabrake.Notice;
import io.airbrake.javabrake.NoticeFilter;
import io.airbrake.javabrake.NoticeHook;
import io.airbrake.javabrake.OkAsyncSender;
import io.airbrake.javabrake.OkSyncSender;
import io.airbrake.javabrake.SyncSender;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

public class Notifier {
    AsyncSender asyncSender;
    SyncSender syncSender;
    final List<NoticeHook> hooks = new ArrayList<NoticeHook>();
    final List<NoticeFilter> filters = new ArrayList<NoticeFilter>();

    public Notifier(int projectId, String projectKey) {
        this.asyncSender = new OkAsyncSender(projectId, projectKey);
        this.syncSender = new OkSyncSender(projectId, projectKey);
        if (Airbrake.notifier == null) {
            Airbrake.notifier = this;
        }
    }

    public Notifier setHost(String host) {
        this.asyncSender.setHost(host);
        this.syncSender.setHost(host);
        return this;
    }

    public Notifier setAsyncSender(AsyncSender sender) {
        this.asyncSender = sender;
        return this;
    }

    public Notifier setSyncSender(SyncSender sender) {
        this.syncSender = sender;
        return this;
    }

    public Notifier onReportedNotice(NoticeHook hook) {
        this.hooks.add(hook);
        return this;
    }

    public Notifier addFilter(NoticeFilter filter) {
        this.filters.add(filter);
        return this;
    }

    public Future<Notice> report(Throwable e) {
        Notice notice = this.buildNotice(e);
        return this.send(notice);
    }

    public Future<Notice> send(Notice notice) {
        notice = this.filterNotice(notice);
        CompletableFuture<Notice> future = this.asyncSender.send(notice);
        Notice finalNotice = notice;
        future.whenComplete((value, exception) -> this.applyHooks(finalNotice));
        return future;
    }

    public Notice reportSync(Throwable e) {
        Notice notice = this.buildNotice(e);
        return this.sendSync(notice);
    }

    public Notice sendSync(Notice notice) {
        notice = this.filterNotice(notice);
        notice = this.syncSender.send(notice);
        this.applyHooks(notice);
        return notice;
    }

    void applyHooks(Notice notice) {
        for (NoticeHook hook : this.hooks) {
            hook.hook(notice);
        }
    }

    Notice filterNotice(Notice notice) {
        for (NoticeFilter filter : this.filters) {
            notice = filter.filter(notice);
            if (notice != null) continue;
            return null;
        }
        return notice;
    }

    public Notice buildNotice(Throwable e) {
        return new Notice(e);
    }
}

