/*
 * Decompiled with CFR 0.152.
 */
package io.airbrake.javabrake;

import io.airbrake.javabrake.Airbrake;
import io.airbrake.javabrake.AsyncSender;
import io.airbrake.javabrake.Config;
import io.airbrake.javabrake.Notice;
import io.airbrake.javabrake.NoticeFilter;
import io.airbrake.javabrake.NoticeHook;
import io.airbrake.javabrake.OkAsyncSender;
import io.airbrake.javabrake.OkSyncSender;
import io.airbrake.javabrake.Queries;
import io.airbrake.javabrake.Queues;
import io.airbrake.javabrake.RemoteSettings;
import io.airbrake.javabrake.Routes;
import io.airbrake.javabrake.SyncSender;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

public class Notifier {
    AsyncSender asyncSender;
    SyncSender syncSender;
    protected static List<Object> routeList = new ArrayList<Object>();
    protected static List<Object> routesBreakdownList = new ArrayList<Object>();
    protected static List<Object> queueList = new ArrayList<Object>();
    protected static List<Object> queryList = new ArrayList<Object>();
    public Routes routes;
    public Queries queries;
    public Queues queues;
    final List<NoticeHook> hooks = new ArrayList<NoticeHook>();
    final List<NoticeFilter> filters = new ArrayList<NoticeFilter>();
    protected static Config config;
    protected static Notifier notifier;

    public Notifier(Config config) {
        Notifier.config = config;
        this.asyncSender = new OkAsyncSender(config);
        this.syncSender = new OkSyncSender(config);
        this.routes = new Routes();
        this.queries = new Queries();
        this.queues = new Queues();
        if (config.errorHost != null) {
            this.setErrorHost(config.errorHost);
        }
        if (config.apmHost != null) {
            this.setAPMHost(config.apmHost);
        }
        if (Airbrake.notifier == null) {
            Airbrake.notifier = this;
        }
        if (config.remoteConfig.booleanValue()) {
            new RemoteSettings(config.projectId, "https://notifier-configs.airbrake.io", config, this.asyncSender, this.syncSender).poll();
        }
    }

    public Notifier setErrorHost(String host) {
        Notifier.config.errorHost = host;
        this.asyncSender.setErrorHost(host);
        this.syncSender.setErrorHost(host);
        return this;
    }

    public Notifier setAPMHost(String host) {
        Notifier.config.apmHost = host;
        this.asyncSender.setAPMHost(host);
        this.syncSender.setAPMHost(host);
        return this;
    }

    public Notifier setAsyncSender(AsyncSender sender) {
        this.asyncSender = sender;
        return this;
    }

    public Notifier setSyncSender(SyncSender sender) {
        this.syncSender = sender;
        return this;
    }

    public Notifier onReportedNotice(NoticeHook hook) {
        this.hooks.add(hook);
        return this;
    }

    public Notifier addFilter(NoticeFilter filter) {
        this.filters.add(filter);
        return this;
    }

    public Future<Notice> report(Throwable e) {
        Notice notice = this.buildNotice(e);
        return this.send(notice);
    }

    public Future<Notice> send(Notice notice) {
        notice = this.filterNotice(notice);
        CompletableFuture<Notice> future = this.asyncSender.send(notice);
        Notice finalNotice = notice;
        future.whenComplete((value, exception) -> this.applyHooks(finalNotice));
        return future;
    }

    public Notice reportSync(Throwable e) {
        Notice notice = this.buildNotice(e);
        return this.sendSync(notice);
    }

    public Notice sendSync(Notice notice) {
        if (!Notifier.config.errorNotifications.booleanValue()) {
            return notice;
        }
        notice = this.filterNotice(notice);
        notice = this.syncSender.send(notice);
        this.applyHooks(notice);
        return notice;
    }

    void applyHooks(Notice notice) {
        for (NoticeHook hook : this.hooks) {
            hook.hook(notice);
        }
    }

    Notice filterNotice(Notice notice) {
        for (NoticeFilter filter : this.filters) {
            notice = filter.filter(notice);
            if (notice != null) continue;
            return null;
        }
        return notice;
    }

    public Notice buildNotice(Throwable e) {
        return new Notice(e);
    }
}

