/*
 * Decompiled with CFR 0.152.
 */
package io.airbrake.javabrake;

import com.google.gson.Gson;
import io.airbrake.javabrake.AsyncSender;
import io.airbrake.javabrake.Config;
import io.airbrake.javabrake.Notice;
import io.airbrake.javabrake.RemoteConfigJSON;
import io.airbrake.javabrake.SettingsData;
import io.airbrake.javabrake.SyncSender;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

class PollTask
extends TimerTask {
    private final int projectId;
    private final String host;
    private final Config config;
    private final AsyncSender asyncSender;
    private final SyncSender syncSender;
    private final SettingsData data;
    private final Boolean origErrorNotifications;
    private final Boolean origAPMNotifications;
    private final OkHttpClient client = new OkHttpClient();
    private final Gson gson = new Gson();
    private static final HashMap<String, String> NOTIFIER_INFO = new HashMap();

    public PollTask(int projectId, String host, Config config, AsyncSender asyncSender, SyncSender syncSender) {
        this.projectId = projectId;
        this.host = host;
        this.config = config;
        this.asyncSender = asyncSender;
        this.syncSender = syncSender;
        this.data = new SettingsData(this.projectId, new RemoteConfigJSON());
        this.origErrorNotifications = config.errorNotifications;
        this.origAPMNotifications = config.performanceStats;
    }

    @Override
    public void run() {
        String response = null;
        try {
            response = this.request();
        }
        catch (IOException e) {
            this.setErrorHost(this.data);
            this.processErrorNotifications(this.data);
            this.setAPMHost(this.data);
            this.processAPMNotifications(this.data);
            return;
        }
        try {
            RemoteConfigJSON json_data = (RemoteConfigJSON)this.gson.fromJson(response, RemoteConfigJSON.class);
            this.data.merge(json_data);
        }
        catch (Exception e) {
            this.setErrorHost(this.data);
            this.processErrorNotifications(this.data);
            this.setAPMHost(this.data);
            this.processAPMNotifications(this.data);
            return;
        }
        this.setErrorHost(this.data);
        this.processErrorNotifications(this.data);
        this.setAPMHost(this.data);
        this.processAPMNotifications(this.data);
    }

    String request() throws IOException {
        HttpUrl.Builder httpBuilder = HttpUrl.parse((String)this.data.configRoute(this.host)).newBuilder();
        for (Map.Entry<String, String> param : NOTIFIER_INFO.entrySet()) {
            httpBuilder.addQueryParameter(param.getKey(), param.getValue());
        }
        Request request = new Request.Builder().url(httpBuilder.build()).build();
        try (Response response = this.client.newCall(request).execute();){
            String string = response.body().string();
            return string;
        }
    }

    void setErrorHost(SettingsData data) {
        this.config.errorHost = this.getErrorHost();
        this.asyncSender.setErrorHost(this.config.errorHost);
        this.syncSender.setErrorHost(this.config.errorHost);
    }

    public String getErrorHost() {
        String remoteErrorHost = this.data.errorHost();
        if (remoteErrorHost == null) {
            return "https://api.airbrake.io";
        }
        return remoteErrorHost;
    }

    void processErrorNotifications(SettingsData data) {
        if (!this.origErrorNotifications.booleanValue()) {
            return;
        }
        this.config.errorNotifications = data.errorNotifications();
    }

    void setAPMHost(SettingsData data) {
        String remoteHost = this.data.apmHost();
        this.config.apmHost = remoteHost == null ? "https://api.airbrake.io" : remoteHost;
        this.asyncSender.setAPMHost(this.config.apmHost);
        this.syncSender.setAPMHost(this.config.apmHost);
    }

    void processAPMNotifications(SettingsData data) {
        if (!this.origAPMNotifications.booleanValue()) {
            return;
        }
        this.config.performanceStats = data.performanceStats();
    }

    static {
        NOTIFIER_INFO.put("notifier_name", Notice.notifierInfo.get("name"));
        NOTIFIER_INFO.put("notifier_version", Notice.notifierInfo.get("version"));
        NOTIFIER_INFO.put("os", System.getProperty("os.name") + "/" + System.getProperty("os.version"));
        NOTIFIER_INFO.put("language", "Java/" + System.getProperty("java.version"));
    }
}

