/*
 * Decompiled with CFR 0.152.
 */
package io.airbrake.javabrake;

import io.airbrake.javabrake.ApmResponse;
import io.airbrake.javabrake.Constant;
import io.airbrake.javabrake.Metrics;
import io.airbrake.javabrake.Notifier;
import io.airbrake.javabrake.OkAsyncSender;
import io.airbrake.javabrake.OkSender;
import io.airbrake.javabrake.Queries;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;

class QueryTimerTask
extends TimerTask {
    static Timer rTimer = new Timer(true);
    private static boolean hasStarted = false;

    QueryTimerTask() {
    }

    public static void start() {
        if (!hasStarted) {
            hasStarted = true;
            rTimer.schedule((TimerTask)new QueryTimerTask(), 0L, (long)(Metrics.FLUSH_PERIOD * 1000));
        }
    }

    @Override
    public void run() {
        hasStarted = true;
        if (Notifier.queryList.size() > 0) {
            Queries queries = new Queries(Notifier.config.environment, Notifier.queryList);
            Notifier.queryList = new ArrayList<Object>();
            CompletableFuture<ApmResponse> future = new OkAsyncSender(Notifier.config).send(OkSender.gson.toJson((Object)queries), Constant.apmQuery);
            future.whenComplete((value, exception) -> {
                if (exception != null) {
                    Queries.status = exception.getMessage();
                } else if (value != null) {
                    Queries.status = value.message;
                }
            });
        }
    }

    public static void stop() {
        rTimer.cancel();
    }
}

