/*
 * Decompiled with CFR 0.152.
 */
package io.airbrake.javabrake;

import io.airbrake.javabrake.ApmResponse;
import io.airbrake.javabrake.Constant;
import io.airbrake.javabrake.Metrics;
import io.airbrake.javabrake.Notifier;
import io.airbrake.javabrake.OkAsyncSender;
import io.airbrake.javabrake.OkSender;
import io.airbrake.javabrake.Routes;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;

class RouteBreakDownTimerTask
extends TimerTask {
    static Timer brTimer = new Timer(true);
    static boolean isStartedBreakdown = false;

    RouteBreakDownTimerTask() {
    }

    public static void start() {
        if (!isStartedBreakdown) {
            isStartedBreakdown = true;
            brTimer.schedule((TimerTask)new RouteBreakDownTimerTask(), 0L, (long)(Metrics.FLUSH_PERIOD * 1000));
        }
    }

    @Override
    public void run() {
        isStartedBreakdown = true;
        if (Notifier.routesBreakdownList.size() > 0) {
            Routes routes = new Routes(Notifier.config.environment, Notifier.routesBreakdownList);
            Notifier.routesBreakdownList = new ArrayList<Object>();
            CompletableFuture<ApmResponse> future = new OkAsyncSender(Notifier.config).send(OkSender.gson.toJson((Object)routes), Constant.apmRouteBreakDown);
            future.whenComplete((value, exception) -> {
                if (exception != null) {
                    Routes.status = exception.getMessage();
                } else if (value != null) {
                    Routes.status = value.message;
                }
            });
        }
    }

    public static void stop() {
        brTimer.cancel();
    }
}

