/*
 * Decompiled with CFR 0.152.
 */
package io.airbrake.javabrake;

import io.airbrake.javabrake.RemoteConfigJSON;
import io.airbrake.javabrake.RemoteSettingJSON;
import java.util.ArrayList;

class SettingsData {
    static final String API_VER = "2020-06-18";
    static final String CONFIG_ROUTE_PATTERN = "%s/%s/config/%d/config.json";
    static final int DEFAULT_INTERVAL = 600;
    private final int projectId;
    RemoteConfigJSON data;

    public SettingsData(int projectId, RemoteConfigJSON data) {
        this.projectId = projectId;
        this.data = data;
    }

    public void merge(RemoteConfigJSON other) {
        this.data.merge(other);
    }

    public int interval() {
        if (this.data.poll_sec > 0) {
            return this.data.poll_sec;
        }
        return 600;
    }

    public String configRoute(String remoteConfigHost) {
        String configRoute;
        if (remoteConfigHost.endsWith("/")) {
            remoteConfigHost = remoteConfigHost.substring(0, remoteConfigHost.length() - 1);
        }
        if ((configRoute = this.data.config_route) != null && !configRoute.isEmpty()) {
            return remoteConfigHost + "/" + configRoute;
        }
        return String.format(CONFIG_ROUTE_PATTERN, remoteConfigHost, API_VER, this.projectId);
    }

    public Boolean errorNotifications() {
        RemoteSettingJSON s = this.findSetting("errors");
        if (s == null) {
            return true;
        }
        return s.enabled;
    }

    public Boolean performanceStats() {
        RemoteSettingJSON s = this.findSetting("apm");
        if (s == null) {
            return true;
        }
        return s.enabled;
    }

    public String errorHost() {
        RemoteSettingJSON s = this.findSetting("errors");
        if (s == null) {
            return null;
        }
        return s.endpoint;
    }

    public String apmHost() {
        RemoteSettingJSON s = this.findSetting("apm");
        if (s == null) {
            return null;
        }
        return s.endpoint;
    }

    private RemoteSettingJSON findSetting(String name) {
        ArrayList<RemoteSettingJSON> settings = this.data.settings;
        if (settings.size() == 0) {
            return null;
        }
        for (RemoteSettingJSON s : settings) {
            if (!s.name.equals(name)) continue;
            return s;
        }
        return null;
    }
}

