/*
 * Decompiled with CFR 0.152.
 */
package io.airbrake.log4javabrake;

import io.airbrake.javabrake.Airbrake;
import io.airbrake.javabrake.Notice;
import io.airbrake.javabrake.NoticeError;
import io.airbrake.javabrake.Notifier;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class AirbrakeAppender
extends AppenderSkeleton {
    int projectId;
    String projectKey;
    String env;
    Notifier notifier;

    public AirbrakeAppender() {
        this.setThreshold((Priority)Level.ERROR);
    }

    public AirbrakeAppender(int projectId, String projectKey) {
        this();
        this.setProjectId(projectId);
        this.setProjectKey(projectKey);
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
        this.initNotifier();
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
        this.initNotifier();
    }

    public void setEnv(String env) {
        this.env = env;
    }

    void initNotifier() {
        if (this.projectId == 0 || this.projectKey == null) {
            return;
        }
        this.notifier = new Notifier(this.projectId, this.projectKey);
    }

    protected void append(LoggingEvent event) {
        Map props;
        Notice notice = AirbrakeAppender.newNotice(event);
        if (this.env != null) {
            notice.setContext("environment", (Object)this.env);
        }
        notice.setContext("severity", (Object)AirbrakeAppender.formatLevel(event.getLevel()));
        notice.setParam("threadName", (Object)event.getThreadName());
        if (event.getNDC() != null) {
            notice.setParam("ndc", (Object)event.getNDC());
        }
        if ((props = event.getProperties()).size() > 0) {
            notice.setParam("properties", (Object)props);
        }
        this.send(notice);
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    static Notice newNotice(LoggingEvent event) {
        ThrowableInformation info = event.getThrowableInformation();
        if (info != null) {
            return new Notice(info.getThrowable());
        }
        Object msg = event.getMessage();
        if (msg instanceof Throwable) {
            return new Notice((Throwable)msg);
        }
        String type = event.getLoggerName();
        String message = event.getRenderedMessage();
        StackTraceElement[] stackTrace = null;
        LocationInfo loc = event.getLocationInformation();
        if (loc != null) {
            String className = loc.getClassName();
            String method = loc.getMethodName();
            String file = loc.getFileName();
            int line = Integer.parseInt(loc.getLineNumber());
            stackTrace = new StackTraceElement[]{new StackTraceElement(className, method, file, line)};
        }
        NoticeError err = new NoticeError(type, message, stackTrace);
        ArrayList<NoticeError> errors = new ArrayList<NoticeError>();
        errors.add(err);
        return new Notice(errors);
    }

    static String formatLevel(Level level) {
        if (level.isGreaterOrEqual((Priority)Level.FATAL)) {
            return "critical";
        }
        if (level.isGreaterOrEqual((Priority)Level.ERROR)) {
            return "error";
        }
        if (level.isGreaterOrEqual((Priority)Level.WARN)) {
            return "warn";
        }
        if (level.isGreaterOrEqual((Priority)Level.INFO)) {
            return "info";
        }
        if (level.isGreaterOrEqual((Priority)Level.DEBUG)) {
            return "debug";
        }
        return "trace";
    }

    Future<Notice> send(Notice notice) {
        if (this.notifier != null) {
            return this.notifier.send(notice);
        }
        return Airbrake.send((Notice)notice);
    }
}

