/*
 * Decompiled with CFR 0.152.
 */
package io.airbrake.log4javabrake2;

import io.airbrake.javabrake.Airbrake;
import io.airbrake.javabrake.Notice;
import io.airbrake.javabrake.NoticeError;
import io.airbrake.javabrake.Notifier;
import java.util.ArrayList;
import java.util.concurrent.Future;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.message.Message;

@Plugin(name="Airbrake", category="Core", elementType="appender", printObject=true)
public class AirbrakeAppender
extends AbstractAppender {
    Notifier notifier;
    String env;

    protected AirbrakeAppender(String name, Filter filter, int projectId, String projectKey, String env) {
        super(name, filter, null, true);
        if (projectId != 0 && projectKey != null) {
            this.notifier = new Notifier(projectId, projectKey);
        }
        this.env = env;
    }

    public void append(LogEvent event) {
        Notice notice = AirbrakeAppender.newNotice(event);
        if (this.env != null) {
            notice.setContext("environment", (Object)this.env);
        }
        notice.setContext("severity", (Object)AirbrakeAppender.formatLevel(event.getLevel()));
        if (event.getContextStack() != null) {
            notice.setParam("contextStack", (Object)event.getContextStack().asList());
        }
        if (event.getContextData() != null) {
            notice.setParam("contextData", (Object)event.getContextData());
        }
        if (event.getMarker() != null) {
            notice.setParam("marker", (Object)event.getMarker().getName());
        }
        this.send(notice);
    }

    @PluginFactory
    public static AirbrakeAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="projectId") int projectId, @PluginAttribute(value="projectKey") String projectKey, @PluginAttribute(value="env") String env) {
        if (name == null) {
            LOGGER.error("No name provided for AirbrakeAppender");
            return null;
        }
        return new AirbrakeAppender(name, filter, projectId, projectKey, env);
    }

    static Notice newNotice(LogEvent event) {
        Throwable throwable = event.getThrown();
        if (throwable != null) {
            return new Notice(throwable);
        }
        Message eventMessage = event.getMessage();
        throwable = eventMessage.getThrowable();
        if (throwable != null) {
            return new Notice(throwable);
        }
        String type = event.getLoggerName();
        String message = eventMessage.getFormattedMessage();
        StackTraceElement[] stackTrace = null;
        if (event.getSource() != null) {
            stackTrace = new StackTraceElement[]{event.getSource()};
        }
        NoticeError err = new NoticeError(type, message, stackTrace);
        ArrayList<NoticeError> errors = new ArrayList<NoticeError>();
        errors.add(err);
        return new Notice(errors);
    }

    static String formatLevel(Level level) {
        if (level.isMoreSpecificThan(Level.FATAL)) {
            return "critical";
        }
        if (level.isMoreSpecificThan(Level.ERROR)) {
            return "error";
        }
        if (level.isMoreSpecificThan(Level.WARN)) {
            return "warn";
        }
        if (level.isMoreSpecificThan(Level.INFO)) {
            return "info";
        }
        if (level.isMoreSpecificThan(Level.DEBUG)) {
            return "debug";
        }
        return "trace";
    }

    Future<Notice> send(Notice notice) {
        if (this.notifier != null) {
            return this.notifier.send(notice);
        }
        return Airbrake.send((Notice)notice);
    }
}

