/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.v3.lz4;

import io.airlift.compress.v3.IncompatibleJvmException;
import java.lang.foreign.MemorySegment;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

final class UnsafeUtil {
    public static final Unsafe UNSAFE;

    private UnsafeUtil() {
    }

    public static byte[] getBase(MemorySegment segment) {
        if (segment.isNative()) {
            return null;
        }
        if (segment.isReadOnly()) {
            throw new IllegalArgumentException("MemorySegment is read-only");
        }
        Object inputBase = segment.heapBase().orElse(null);
        if (!(inputBase instanceof byte[])) {
            throw new IllegalArgumentException("MemorySegment is not backed by a byte array");
        }
        byte[] byteArray = inputBase;
        return byteArray;
    }

    public static long getAddress(MemorySegment segment) {
        if (segment.isNative()) {
            return segment.address();
        }
        return segment.address() + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET;
    }

    static {
        ByteOrder order = ByteOrder.nativeOrder();
        if (!order.equals(ByteOrder.LITTLE_ENDIAN)) {
            throw new IncompatibleJvmException(String.format("LZ4 requires a little endian platform (found %s)", order));
        }
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            throw new IncompatibleJvmException("LZ4 requires access to sun.misc.Unsafe");
        }
    }
}

