/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.v3.lz4;

import io.airlift.compress.v3.lz4.Lz4Decompressor;
import io.airlift.compress.v3.lz4.Lz4Native;
import java.lang.foreign.MemorySegment;

public final class Lz4NativeDecompressor
implements Lz4Decompressor {
    public Lz4NativeDecompressor() {
        Lz4Native.verifyEnabled();
    }

    public static boolean isEnabled() {
        return Lz4Native.isEnabled();
    }

    @Override
    public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        MemorySegment inputSegment = MemorySegment.ofArray(input).asSlice((long)inputOffset, inputLength);
        MemorySegment outputSegment = MemorySegment.ofArray(output).asSlice((long)outputOffset, maxOutputLength);
        return Lz4Native.decompress(inputSegment, inputLength, outputSegment, maxOutputLength);
    }

    @Override
    public int decompress(MemorySegment input, MemorySegment output) {
        return Lz4Native.decompress(input, Math.toIntExact(input.byteSize()), output, Math.toIntExact(output.byteSize()));
    }
}

