/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.v3.zstd;

import io.airlift.compress.v3.Compressor;
import io.airlift.compress.v3.zstd.ZstdJavaCompressor;
import io.airlift.compress.v3.zstd.ZstdNativeCompressor;
import java.lang.foreign.MemorySegment;

public interface ZstdCompressor
extends Compressor {
    @Override
    public int compress(MemorySegment var1, MemorySegment var2);

    public static ZstdCompressor create() {
        if (ZstdNativeCompressor.isEnabled()) {
            return new ZstdNativeCompressor();
        }
        return new ZstdJavaCompressor();
    }

    public static ZstdCompressor create(int compressionLevel) {
        if (ZstdNativeCompressor.isEnabled()) {
            return new ZstdNativeCompressor(compressionLevel);
        }
        if (compressionLevel != 3) {
            throw new IllegalArgumentException("Compression level different from default cannot be used for non-native Zstd compressor");
        }
        return new ZstdJavaCompressor();
    }
}

