/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.v2.lzo;

import io.airlift.compress.v2.MalformedInputException;
import io.airlift.compress.v2.lzo.UnsafeUtil;

final class LzoRawDecompressor {
    private static final int[] DEC_32_TABLE = new int[]{4, 1, 2, 1, 4, 4, 4, 4};
    private static final int[] DEC_64_TABLE = new int[]{0, 0, 0, -1, 0, 1, 2, 3};

    private LzoRawDecompressor() {
    }

    public static int decompress(Object inputBase, long inputAddress, long inputLimit, Object outputBase, long outputAddress, long outputLimit) throws MalformedInputException {
        if (inputAddress == inputLimit) {
            return 0;
        }
        long fastOutputLimit = outputLimit - 8L;
        long output = outputAddress;
        block0: for (long input = inputAddress; input < inputLimit; input += 2L) {
            boolean firstCommand = true;
            int lastLiteralLength = 0;
            while (true) {
                int literalLength;
                int matchLength;
                int matchOffset;
                int command;
                if (input >= inputLimit) {
                    throw new MalformedInputException(input - inputAddress);
                }
                if (((command = UnsafeUtil.UNSAFE.getByte(inputBase, input++) & 0xFF) & 0xF0) == 0) {
                    if (lastLiteralLength == 0) {
                        matchOffset = 0;
                        matchLength = 0;
                        literalLength = command & 0xF;
                        if (literalLength == 0) {
                            literalLength = 15;
                            int nextByte = 0;
                            while (input < inputLimit && (nextByte = UnsafeUtil.UNSAFE.getByte(inputBase, input++) & 0xFF) == 0) {
                                literalLength += 255;
                            }
                            literalLength += nextByte;
                        }
                        literalLength += 3;
                    } else if (lastLiteralLength <= 3) {
                        matchLength = 2;
                        if (input >= inputLimit) {
                            throw new MalformedInputException(input - inputAddress);
                        }
                        matchOffset = (command & 0xC) >>> 2;
                        matchOffset |= (UnsafeUtil.UNSAFE.getByte(inputBase, input++) & 0xFF) << 2;
                        literalLength = command & 3;
                    } else {
                        matchLength = 3;
                        if (input >= inputLimit) {
                            throw new MalformedInputException(input - inputAddress);
                        }
                        matchOffset = (command & 0xC) >>> 2;
                        matchOffset |= (UnsafeUtil.UNSAFE.getByte(inputBase, input++) & 0xFF) << 2;
                        matchOffset |= 0x800;
                        literalLength = command & 3;
                    }
                } else if (firstCommand) {
                    matchLength = 0;
                    matchOffset = 0;
                    literalLength = command - 17;
                } else if ((command & 0xF0) == 16) {
                    matchLength = command & 7;
                    if (matchLength == 0) {
                        matchLength = 7;
                        int nextByte = 0;
                        while (input < inputLimit && (nextByte = UnsafeUtil.UNSAFE.getByte(inputBase, input++) & 0xFF) == 0) {
                            matchLength += 255;
                        }
                        matchLength += nextByte;
                    }
                    matchLength += 2;
                    if (input + 2L > inputLimit) {
                        throw new MalformedInputException(input - inputAddress);
                    }
                    int trailer = UnsafeUtil.UNSAFE.getShort(inputBase, input) & 0xFFFF;
                    matchOffset = (command & 8) << 11;
                    if ((matchOffset += trailer >> 2) == 0) continue block0;
                    matchOffset += 16383;
                    literalLength = trailer & 3;
                } else if ((command & 0xE0) == 32) {
                    matchLength = command & 0x1F;
                    if (matchLength == 0) {
                        matchLength = 31;
                        int nextByte = 0;
                        while (input < inputLimit && (nextByte = UnsafeUtil.UNSAFE.getByte(inputBase, input++) & 0xFF) == 0) {
                            matchLength += 255;
                        }
                        matchLength += nextByte;
                    }
                    matchLength += 2;
                    if (input + 2L > inputLimit) {
                        throw new MalformedInputException(input - inputAddress);
                    }
                    int trailer = UnsafeUtil.UNSAFE.getShort(inputBase, input) & 0xFFFF;
                    input += 2L;
                    matchOffset = trailer >>> 2;
                    literalLength = trailer & 3;
                } else if ((command & 0xC0) != 0) {
                    matchLength = (command & 0xE0) >>> 5;
                    ++matchLength;
                    if (input >= inputLimit) {
                        throw new MalformedInputException(input - inputAddress);
                    }
                    matchOffset = (command & 0x1C) >>> 2;
                    matchOffset |= (UnsafeUtil.UNSAFE.getByte(inputBase, input++) & 0xFF) << 3;
                    literalLength = command & 3;
                } else {
                    String binary = LzoRawDecompressor.toBinary(command);
                    throw new MalformedInputException(input - 1L, "Invalid LZO command " + binary);
                }
                firstCommand = false;
                if (matchLength < 0) {
                    throw new MalformedInputException(input - inputAddress);
                }
                if (matchLength != 0) {
                    long matchAddress;
                    if ((matchAddress = output - (long)(++matchOffset)) < outputAddress || output + (long)matchLength > outputLimit) {
                        throw new MalformedInputException(input - inputAddress);
                    }
                    long matchOutputLimit = output + (long)matchLength;
                    if (output > fastOutputLimit) {
                        while (output < matchOutputLimit) {
                            UnsafeUtil.UNSAFE.putByte(outputBase, output++, UnsafeUtil.UNSAFE.getByte(outputBase, matchAddress++));
                        }
                    } else {
                        if (matchOffset < 8) {
                            int increment32 = DEC_32_TABLE[matchOffset];
                            int decrement64 = DEC_64_TABLE[matchOffset];
                            UnsafeUtil.UNSAFE.putByte(outputBase, output, UnsafeUtil.UNSAFE.getByte(outputBase, matchAddress));
                            UnsafeUtil.UNSAFE.putByte(outputBase, output + 1L, UnsafeUtil.UNSAFE.getByte(outputBase, matchAddress + 1L));
                            UnsafeUtil.UNSAFE.putByte(outputBase, output + 2L, UnsafeUtil.UNSAFE.getByte(outputBase, matchAddress + 2L));
                            UnsafeUtil.UNSAFE.putByte(outputBase, output + 3L, UnsafeUtil.UNSAFE.getByte(outputBase, matchAddress + 3L));
                            UnsafeUtil.UNSAFE.putInt(outputBase, output += 4L, UnsafeUtil.UNSAFE.getInt(outputBase, matchAddress += (long)increment32));
                            output += 4L;
                            matchAddress -= (long)decrement64;
                        } else {
                            UnsafeUtil.UNSAFE.putLong(outputBase, output, UnsafeUtil.UNSAFE.getLong(outputBase, matchAddress));
                            matchAddress += 8L;
                            output += 8L;
                        }
                        if (matchOutputLimit >= fastOutputLimit) {
                            if (matchOutputLimit > outputLimit) {
                                throw new MalformedInputException(input - inputAddress);
                            }
                            while (output < fastOutputLimit) {
                                UnsafeUtil.UNSAFE.putLong(outputBase, output, UnsafeUtil.UNSAFE.getLong(outputBase, matchAddress));
                                matchAddress += 8L;
                                output += 8L;
                            }
                            while (output < matchOutputLimit) {
                                UnsafeUtil.UNSAFE.putByte(outputBase, output++, UnsafeUtil.UNSAFE.getByte(outputBase, matchAddress++));
                            }
                        } else {
                            while (output < matchOutputLimit) {
                                UnsafeUtil.UNSAFE.putLong(outputBase, output, UnsafeUtil.UNSAFE.getLong(outputBase, matchAddress));
                                matchAddress += 8L;
                                output += 8L;
                            }
                        }
                    }
                    output = matchOutputLimit;
                }
                if (literalLength < 0) {
                    throw new MalformedInputException(input - inputAddress);
                }
                long literalOutputLimit = output + (long)literalLength;
                if (literalOutputLimit > fastOutputLimit || input + (long)literalLength > inputLimit - 8L) {
                    if (literalOutputLimit > outputLimit || input + (long)literalLength > inputLimit) {
                        throw new MalformedInputException(input - inputAddress);
                    }
                    UnsafeUtil.UNSAFE.copyMemory(inputBase, input, outputBase, output, literalLength);
                    input += (long)literalLength;
                    output += (long)literalLength;
                } else {
                    do {
                        UnsafeUtil.UNSAFE.putLong(outputBase, output, UnsafeUtil.UNSAFE.getLong(inputBase, input));
                        input += 8L;
                    } while ((output += 8L) < literalOutputLimit);
                    input -= output - literalOutputLimit;
                    output = literalOutputLimit;
                }
                lastLiteralLength = literalLength;
            }
        }
        return (int)(output - outputAddress);
    }

    private static String toBinary(int command) {
        String binaryString = String.format("%8s", Integer.toBinaryString(command)).replace(' ', '0');
        return "0b" + binaryString.substring(0, 4) + "_" + binaryString.substring(4);
    }
}

