/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.command;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import io.airlift.command.Context;
import io.airlift.command.ParseState;
import io.airlift.command.TypeConverter;
import io.airlift.command.model.ArgumentsMetadata;
import io.airlift.command.model.CommandGroupMetadata;
import io.airlift.command.model.CommandMetadata;
import io.airlift.command.model.GlobalMetadata;
import io.airlift.command.model.OptionMetadata;
import java.util.List;
import java.util.regex.Pattern;

public class Parser {
    private static final Pattern SHORT_OPTIONS_PATTERN = Pattern.compile("-[^-].*");
    private final GlobalMetadata metadata;

    public Parser(GlobalMetadata metadata) {
        this.metadata = metadata;
    }

    public ParseState parse(String ... params) {
        return this.parse((Iterable<String>)ImmutableList.copyOf((Object[])params));
    }

    public ParseState parse(Iterable<String> params) {
        CommandMetadata command;
        CommandGroupMetadata group;
        PeekingIterator tokens = Iterators.peekingIterator(params.iterator());
        ParseState state = ParseState.newInstance().pushContext(Context.GLOBAL);
        state = this.parseOptions((PeekingIterator<String>)tokens, state, this.metadata.getOptions());
        if (tokens.hasNext() && (group = (CommandGroupMetadata)Iterables.find(this.metadata.getCommandGroups(), (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)tokens.peek()), CommandGroupMetadata.nameGetter()), null)) != null) {
            tokens.next();
            state = state.withGroup(group).pushContext(Context.GROUP);
            state = this.parseOptions((PeekingIterator<String>)tokens, state, state.getGroup().getOptions());
        }
        List<CommandMetadata> expectedCommands = this.metadata.getDefaultGroupCommands();
        if (state.getGroup() != null) {
            expectedCommands = state.getGroup().getCommands();
        }
        if (tokens.hasNext() && (command = (CommandMetadata)Iterables.find(expectedCommands, (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)tokens.peek()), CommandMetadata.nameGetter()), null)) != null) {
            tokens.next();
            state = state.withCommand(command).pushContext(Context.COMMAND);
            while (tokens.hasNext()) {
                state = this.parseOptions((PeekingIterator<String>)tokens, state, command.getCommandOptions());
                state = this.parseArgs(state, (PeekingIterator<String>)tokens, command.getArguments());
            }
        }
        return state;
    }

    private ParseState parseOptions(PeekingIterator<String> tokens, ParseState state, List<OptionMetadata> allowedOptions) {
        while (tokens.hasNext()) {
            ParseState nextState = this.parseSimpleOption(tokens, state, allowedOptions);
            if (nextState != null) {
                state = nextState;
                continue;
            }
            nextState = this.parseLongGnuGetOpt(tokens, state, allowedOptions);
            if (nextState != null) {
                state = nextState;
                continue;
            }
            nextState = this.parseClassicGetOpt(tokens, state, allowedOptions);
            if (nextState == null) break;
            state = nextState;
        }
        return state;
    }

    private ParseState parseSimpleOption(PeekingIterator<String> tokens, ParseState state, List<OptionMetadata> allowedOptions) {
        OptionMetadata option = this.findOption(allowedOptions, (String)tokens.peek());
        if (option == null) {
            return null;
        }
        tokens.next();
        state = state.pushContext(Context.OPTION).withOption(option);
        if (option.getArity() == 0) {
            state = state.withOptionValue(option, Boolean.TRUE).popContext();
        } else if (option.getArity() == 1) {
            if (tokens.hasNext()) {
                Object value = TypeConverter.newInstance().convert(option.getTitle(), option.getJavaType(), (String)tokens.next());
                state = state.withOptionValue(option, value).popContext();
            }
        } else {
            int count;
            ImmutableList.Builder values = ImmutableList.builder();
            for (count = 0; count < option.getArity() && tokens.hasNext(); ++count) {
                values.add(TypeConverter.newInstance().convert(option.getTitle(), option.getJavaType(), (String)tokens.next()));
            }
            if (count == option.getArity()) {
                state = state.withOptionValue(option, values.build()).popContext();
            }
        }
        return state;
    }

    private ParseState parseLongGnuGetOpt(PeekingIterator<String> tokens, ParseState state, List<OptionMetadata> allowedOptions) {
        ImmutableList parts = ImmutableList.copyOf((Iterable)Splitter.on((char)'=').limit(2).split((CharSequence)tokens.peek()));
        if (parts.size() != 2) {
            return null;
        }
        OptionMetadata option = this.findOption(allowedOptions, (String)parts.get(0));
        if (option == null || option.getArity() != 1) {
            return null;
        }
        tokens.next();
        state = state.pushContext(Context.OPTION).withOption(option);
        Object value = TypeConverter.newInstance().convert(option.getTitle(), option.getJavaType(), (String)parts.get(1));
        state = state.withOption(option).withOptionValue(option, value).popContext();
        return state;
    }

    private ParseState parseClassicGetOpt(PeekingIterator<String> tokens, ParseState state, List<OptionMetadata> allowedOptions) {
        if (!SHORT_OPTIONS_PATTERN.matcher((CharSequence)tokens.peek()).matches()) {
            return null;
        }
        String remainingToken = ((String)tokens.peek()).substring(1);
        ParseState nextState = state;
        while (!remainingToken.isEmpty()) {
            char tokenCharacter = remainingToken.charAt(0);
            OptionMetadata option = this.findOption(allowedOptions, "-" + tokenCharacter);
            if (option == null) {
                return null;
            }
            nextState = nextState.pushContext(Context.OPTION).withOption(option);
            remainingToken = remainingToken.substring(1);
            if (option.getArity() == 0) {
                nextState = nextState.withOptionValue(option, Boolean.TRUE).popContext();
                continue;
            }
            if (option.getArity() == 1) {
                tokens.next();
                if (!remainingToken.isEmpty()) {
                    Object value = TypeConverter.newInstance().convert(option.getTitle(), option.getJavaType(), remainingToken);
                    nextState = nextState.withOptionValue(option, value).popContext();
                } else if (tokens.hasNext()) {
                    Object value = TypeConverter.newInstance().convert(option.getTitle(), option.getJavaType(), (String)tokens.next());
                    nextState = nextState.withOptionValue(option, value).popContext();
                }
                return nextState;
            }
            throw new UnsupportedOperationException("Short options style can not be used with option " + option.getAllowedValues());
        }
        tokens.next();
        return nextState;
    }

    private ParseState parseArgs(ParseState state, PeekingIterator<String> tokens, ArgumentsMetadata arguments) {
        if (tokens.hasNext()) {
            if (((String)tokens.peek()).equals("--")) {
                state = state.pushContext(Context.ARGS);
                tokens.next();
                while (tokens.hasNext()) {
                    state = this.parseArg(state, tokens, arguments);
                }
            } else {
                state = this.parseArg(state, tokens, arguments);
            }
        }
        return state;
    }

    private ParseState parseArg(ParseState state, PeekingIterator<String> tokens, ArgumentsMetadata arguments) {
        state = arguments != null ? state.withArgument(TypeConverter.newInstance().convert(arguments.getTitle(), arguments.getJavaType(), (String)tokens.next())) : state.withUnparsedInput((String)tokens.next());
        return state;
    }

    private OptionMetadata findOption(List<OptionMetadata> options, String param) {
        for (OptionMetadata optionMetadata : options) {
            if (!optionMetadata.getOptions().contains(param)) continue;
            return optionMetadata;
        }
        return null;
    }
}

