/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

class ColumnPrinter {
    private static final int DEFAULT_MARGIN = 2;
    private final List<List<String>> data = new ArrayList<List<String>>();
    private final List<String> columnNames = new ArrayList<String>();
    private final List<Integer> columnWidths = new ArrayList<Integer>();
    private final int margin;

    public ColumnPrinter() {
        this(2);
    }

    public ColumnPrinter(int margin) {
        this.margin = margin;
    }

    public void addColumn(String columnName) {
        this.data.add(new ArrayList());
        this.columnNames.add(columnName);
        this.columnWidths.add(columnName.length());
    }

    public void addValue(String columnName, String value) {
        this.addValue(this.columnNames.indexOf(columnName), value);
    }

    private void addValue(int columnIndex, String value) {
        Preconditions.checkElementIndex((int)columnIndex, (int)this.data.size(), (String)"columnIndex");
        this.data.get(columnIndex).add(value);
        this.columnWidths.set(columnIndex, Math.max(value.length(), this.columnWidths.get(columnIndex)));
    }

    public void print(PrintWriter out) {
        for (String line : this.generateOutput()) {
            out.println(line.trim());
        }
    }

    private List<String> generateOutput() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        List dataIterators = this.data.stream().map(Collection::iterator).collect(Collectors.toList());
        Iterator<Integer> columnWidthIterator = this.columnWidths.iterator();
        for (String columnName : this.columnNames) {
            int thisWidth = columnWidthIterator.next();
            this.printValue(buffer, columnName, thisWidth);
        }
        ColumnPrinter.pushLine(lines, buffer);
        boolean done = false;
        while (!done) {
            boolean hadValue = false;
            Iterator rowIterator = dataIterators.iterator();
            for (int width : this.columnWidths) {
                Iterator thisDataIterator = (Iterator)rowIterator.next();
                if (thisDataIterator.hasNext()) {
                    hadValue = true;
                    String value = (String)thisDataIterator.next();
                    this.printValue(buffer, value, width);
                    continue;
                }
                this.printValue(buffer, "", width);
            }
            ColumnPrinter.pushLine(lines, buffer);
            if (hadValue) continue;
            done = true;
        }
        return lines;
    }

    private static void pushLine(List<String> lines, StringBuilder workStr) {
        lines.add(workStr.toString());
        workStr.setLength(0);
    }

    private void printValue(StringBuilder str, String value, int thisWidth) {
        str.append(String.format(this.widthSpec(thisWidth), value));
    }

    private String widthSpec(int thisWidth) {
        return "%-" + (thisWidth + this.margin) + "s";
    }
}

