/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.spi.Message;
import io.airlift.bootstrap.ApplicationConfigurationException;
import io.airlift.bootstrap.BootstrapConfig;
import io.airlift.bootstrap.ColumnPrinter;
import io.airlift.bootstrap.FuzzyMatcher;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.bootstrap.LifeCycleModule;
import io.airlift.configuration.ConfigPropertyMetadata;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationInspector;
import io.airlift.configuration.ConfigurationLoader;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.configuration.TomlConfiguration;
import io.airlift.configuration.WarningsMonitor;
import io.airlift.configuration.secrets.SecretsPluginManager;
import io.airlift.configuration.secrets.SecretsResolver;
import io.airlift.configuration.secrets.env.EnvironmentVariableSecretProvider;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.log.LoggingConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class Bootstrap {
    private final String name;
    private final Logger log;
    private final List<Module> modules;
    private Map<String, String> requiredConfigurationProperties;
    private Map<String, String> optionalConfigurationProperties;
    private boolean initializeLogging = true;
    private boolean envInterpolation = true;
    private boolean quiet;
    private boolean loadSecretsPlugins;
    private boolean skipErrorReporting;
    private State state = State.UNINITIALIZED;
    private ConfigurationFactory configurationFactory;
    private SecretsResolver secretsResolver;

    public Bootstrap(String name, Module ... modules) {
        this(name, (Iterable<? extends Module>)ImmutableList.copyOf((Object[])modules));
    }

    public Bootstrap(Iterable<? extends Module> modules) {
        this("Bootstrap", modules);
    }

    public Bootstrap(Module ... modules) {
        this((Iterable<? extends Module>)ImmutableList.copyOf((Object[])modules));
    }

    public Bootstrap(String name, Iterable<? extends Module> modules) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.modules = ImmutableList.copyOf(modules);
        this.log = Logger.get((String)name);
    }

    public Bootstrap setRequiredConfigurationProperty(String key, String value) {
        if (this.requiredConfigurationProperties == null) {
            this.requiredConfigurationProperties = new TreeMap<String, String>();
        }
        this.requiredConfigurationProperties.put(key, value);
        return this;
    }

    public Bootstrap setRequiredConfigurationProperties(Map<String, String> requiredConfigurationProperties) {
        if (this.requiredConfigurationProperties == null) {
            this.requiredConfigurationProperties = new TreeMap<String, String>();
        }
        this.requiredConfigurationProperties.putAll(requiredConfigurationProperties);
        return this;
    }

    public Bootstrap setOptionalConfigurationProperty(String key, String value) {
        if (this.optionalConfigurationProperties == null) {
            this.optionalConfigurationProperties = new TreeMap<String, String>();
        }
        this.optionalConfigurationProperties.put(key, value);
        return this;
    }

    public Bootstrap setOptionalConfigurationProperties(Map<String, String> optionalConfigurationProperties) {
        if (this.optionalConfigurationProperties == null) {
            this.optionalConfigurationProperties = new TreeMap<String, String>();
        }
        this.optionalConfigurationProperties.putAll(optionalConfigurationProperties);
        return this;
    }

    public Bootstrap doNotInitializeLogging() {
        return this.withInitializeLogging(false);
    }

    public Bootstrap disableEnvInterpolation() {
        return this.withEnvInterpolation(false);
    }

    public Bootstrap quiet() {
        return this.withQuiet(true);
    }

    public Bootstrap loadSecretsPlugins() {
        return this.withLoadSecretsPlugins(true);
    }

    public Bootstrap skipErrorReporting() {
        return this.withSkipErrorReporting(true);
    }

    public Bootstrap withInitializeLogging(boolean initializeLogging) {
        this.initializeLogging = initializeLogging;
        return this;
    }

    public Bootstrap withQuiet(boolean quiet) {
        this.quiet = quiet;
        return this;
    }

    public Bootstrap withLoadSecretsPlugins(boolean load) {
        this.loadSecretsPlugins = load;
        return this;
    }

    public Bootstrap withSkipErrorReporting(boolean skip) {
        this.skipErrorReporting = skip;
        return this;
    }

    public Bootstrap withEnvInterpolation(boolean interpolate) {
        this.envInterpolation = interpolate;
        return this;
    }

    public Set<ConfigPropertyMetadata> configure() {
        Map requiredProperties;
        Preconditions.checkState((this.state == State.UNINITIALIZED ? 1 : 0) != 0, (Object)"Already configured");
        this.state = State.CONFIGURED;
        Logging logging = null;
        if (this.initializeLogging) {
            logging = Logging.initialize();
        }
        SecretsResolver secretsResolver = this.secretsResolver = this.envInterpolation ? new SecretsResolver((Map)ImmutableMap.of((Object)"env", (Object)new EnvironmentVariableSecretProvider())) : new SecretsResolver((Map)ImmutableMap.of());
        if (this.loadSecretsPlugins) {
            this.log.info("Loading secrets plugins");
            String secretsConfigFile = System.getProperty("secretsConfig");
            if (secretsConfigFile != null) {
                SecretsPluginManager secretsPluginManager = new SecretsPluginManager(TomlConfiguration.createTomlConfiguration((File)new File(secretsConfigFile)));
                secretsPluginManager.installPlugins();
                secretsPluginManager.load();
                this.secretsResolver = secretsPluginManager.getSecretsResolver();
            }
        }
        if (this.requiredConfigurationProperties == null) {
            this.log.info("Loading configuration");
            requiredProperties = Collections.emptyMap();
            String configFile = System.getProperty("config");
            if (configFile != null) {
                try {
                    requiredProperties = ConfigurationLoader.loadPropertiesFrom((String)configFile);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        } else {
            requiredProperties = this.requiredConfigurationProperties;
        }
        TreeMap<String, String> unusedProperties = new TreeMap<String, String>(requiredProperties);
        ImmutableSortedMap properties = new HashMap();
        if (this.optionalConfigurationProperties != null) {
            properties.putAll(this.optionalConfigurationProperties);
        }
        properties.putAll(requiredProperties);
        properties.putAll(ConfigurationLoader.getSystemProperties());
        ArrayList<Message> errors = new ArrayList<Message>();
        properties = ImmutableSortedMap.copyOf((Map)this.secretsResolver.getResolvedConfiguration(properties, (key, error) -> {
            unusedProperties.remove(key);
            errors.add(new Message(error.getMessage()));
        }));
        ArrayList<Message> warnings = new ArrayList<Message>();
        this.configurationFactory = new ConfigurationFactory((Map)properties, warning -> warnings.add(new Message(warning)));
        Boolean quietConfig = ((BootstrapConfig)this.configurationFactory.build(BootstrapConfig.class)).isQuiet();
        if (logging != null) {
            this.log.info("Initializing logging");
            LoggingConfiguration configuration = (LoggingConfiguration)this.configurationFactory.build(LoggingConfiguration.class);
            logging.configure(configuration);
        }
        errors.addAll(this.configurationFactory.registerConfigurationClasses(this.modules));
        errors.addAll(this.configurationFactory.validateRegisteredConfigurationProvider());
        Set usedProperties = (Set)this.configurationFactory.getUsedProperties().stream().map(ConfigPropertyMetadata::name).collect(ImmutableSet.toImmutableSet());
        unusedProperties.keySet().removeAll(usedProperties);
        for (String key2 : unusedProperties.keySet()) {
            errors.add(new Message(String.format("Configuration property '%s' was not used" + Bootstrap.suggest(key2, this.configurationFactory.getAllSeenProperties()), key2)));
        }
        if (!this.skipErrorReporting && !errors.isEmpty()) {
            throw new ApplicationConfigurationException(errors, warnings);
        }
        if (!(quietConfig != null ? quietConfig != false : this.quiet)) {
            this.logConfiguration(this.configurationFactory);
        }
        if (!this.skipErrorReporting && !warnings.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append("Configuration warnings\n");
            message.append("==========\n\n");
            message.append("Configuration should be updated:\n\n");
            for (int index = 0; index < warnings.size(); ++index) {
                message.append(String.format("%s) %s\n", index + 1, warnings.get(index)));
            }
            message.append("\n");
            message.append("==========");
            this.log.warn(message.toString());
        }
        return this.configurationFactory.getUsedProperties();
    }

    public Injector initialize() {
        Preconditions.checkState((this.state != State.INITIALIZED ? 1 : 0) != 0, (Object)"Already initialized");
        if (this.state == State.UNINITIALIZED) {
            this.configure();
        }
        this.state = State.INITIALIZED;
        ImmutableList.Builder moduleList = ImmutableList.builder();
        moduleList.add((Object)new LifeCycleModule(this.name));
        moduleList.add((Object)new ConfigurationModule(this.configurationFactory));
        moduleList.add(binder -> binder.bind(WarningsMonitor.class).toInstance(arg_0 -> ((Logger)this.log).warn(arg_0)));
        moduleList.add(Binder::disableCircularProxies);
        moduleList.add(Binder::requireExplicitBindings);
        moduleList.add(Binder::requireExactBindingAnnotations);
        moduleList.add(binder -> binder.bind(SecretsResolver.class).toInstance((Object)this.secretsResolver));
        moduleList.addAll(this.modules);
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Iterable)moduleList.build());
        ((LifeCycleManager)injector.getInstance(LifeCycleManager.class)).start();
        return injector;
    }

    private void logConfiguration(ConfigurationFactory configurationFactory) {
        if (!this.log.isInfoEnabled()) {
            return;
        }
        ColumnPrinter columnPrinter = Bootstrap.makePrinterForConfiguration(configurationFactory);
        for (String line : columnPrinter.generateOutput()) {
            this.log.info(line);
        }
    }

    private static ColumnPrinter makePrinterForConfiguration(ConfigurationFactory configurationFactory) {
        ConfigurationInspector configurationInspector = new ConfigurationInspector();
        ColumnPrinter columnPrinter = new ColumnPrinter("PROPERTY", "DEFAULT", "RUNTIME", "DESCRIPTION");
        for (ConfigurationInspector.ConfigRecord record : configurationInspector.inspect(configurationFactory)) {
            for (ConfigurationInspector.ConfigAttribute attribute : record.getAttributes()) {
                columnPrinter.addValues(attribute.getPropertyName(), attribute.getDefaultValue(), attribute.getCurrentValue(), attribute.getDescription());
            }
        }
        return columnPrinter;
    }

    private static String suggest(String key, Set<String> knownProperties) {
        List<String> suggestions = FuzzyMatcher.findSimilar(key, knownProperties, 3);
        if (suggestions.isEmpty()) {
            return "";
        }
        return ". Did you mean to use " + (switch (suggestions.size()) {
            case 3 -> "'" + suggestions.get(0) + "', '" + suggestions.get(1) + "' or '" + suggestions.get(2) + "'?";
            case 2 -> "'" + suggestions.get(0) + "' or '" + suggestions.get(1) + "'?";
            default -> "'" + suggestions.get(0) + "'?";
        });
    }

    private static enum State {
        UNINITIALIZED,
        CONFIGURED,
        INITIALIZED;

    }
}

