/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bytecode.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.BytecodeVisitor;
import io.airlift.bytecode.FieldDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.MethodGenerationContext;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.expression.ArrayLengthBytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.expression.CastBytecodeExpression;
import io.airlift.bytecode.expression.GetElementBytecodeExpression;
import io.airlift.bytecode.expression.GetFieldBytecodeExpression;
import io.airlift.bytecode.expression.InstanceOfBytecodeExpression;
import io.airlift.bytecode.expression.InvokeBytecodeExpression;
import io.airlift.bytecode.expression.PopBytecodeExpression;
import io.airlift.bytecode.expression.ReturnBytecodeExpression;
import io.airlift.bytecode.expression.SetArrayElementBytecodeExpression;
import io.airlift.bytecode.expression.SetFieldBytecodeExpression;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import org.objectweb.asm.MethodVisitor;

public abstract class BytecodeExpression
implements BytecodeNode {
    private final ParameterizedType type;

    protected BytecodeExpression(ParameterizedType type) {
        this.type = Objects.requireNonNull(type, "type is null");
    }

    public final ParameterizedType getType() {
        return this.type;
    }

    public abstract BytecodeNode getBytecode(MethodGenerationContext var1);

    protected abstract String formatOneLine();

    public final String toString() {
        return this.formatOneLine() + (this.type.getPrimitiveType() == Void.TYPE ? ";" : "");
    }

    public final BytecodeExpression getField(Class<?> declaringClass, String name) {
        return new GetFieldBytecodeExpression(this, declaringClass, name);
    }

    public final BytecodeExpression getField(String name, Class<?> type) {
        return new GetFieldBytecodeExpression(this, this.getType(), name, ParameterizedType.type(type));
    }

    public final BytecodeExpression getField(Field field) {
        return new GetFieldBytecodeExpression(this, field);
    }

    public final BytecodeExpression getField(FieldDefinition field) {
        return new GetFieldBytecodeExpression(this, field);
    }

    public final BytecodeExpression getField(ParameterizedType declaringClass, String name, ParameterizedType type) {
        return new GetFieldBytecodeExpression(this, declaringClass, name, type);
    }

    public final BytecodeExpression setField(String name, BytecodeExpression value) {
        return new SetFieldBytecodeExpression(this, this.getType(), name, value);
    }

    public final BytecodeExpression setField(Field field, BytecodeExpression value) {
        return new SetFieldBytecodeExpression(this, field, value);
    }

    public final BytecodeExpression setField(FieldDefinition field, BytecodeExpression value) {
        return new SetFieldBytecodeExpression(this, field, value);
    }

    public final BytecodeExpression cast(Class<?> type) {
        return new CastBytecodeExpression(this, ParameterizedType.type(type));
    }

    public final BytecodeExpression cast(ParameterizedType type) {
        return new CastBytecodeExpression(this, type);
    }

    public final BytecodeExpression invoke(Method method, BytecodeExpression ... parameters) {
        return this.invoke(method, (Iterable<? extends BytecodeExpression>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public final BytecodeExpression invoke(MethodDefinition method, Iterable<? extends BytecodeExpression> parameters) {
        ImmutableList params = ImmutableList.copyOf(parameters);
        Preconditions.checkArgument((method.getParameters().size() == params.size() ? 1 : 0) != 0, (String)"Expected %s params found %s", (int)method.getParameters().size(), (int)params.size());
        return this.invoke(method.getName(), method.getReturnType(), parameters);
    }

    public final BytecodeExpression invoke(Method method, Iterable<? extends BytecodeExpression> parameters) {
        return this.invoke(method.getName(), ParameterizedType.type(method.getReturnType()), parameters);
    }

    public final BytecodeExpression invoke(String methodName, Class<?> returnType, BytecodeExpression ... parameters) {
        return this.invoke(methodName, ParameterizedType.type(returnType), (Iterable<? extends BytecodeExpression>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public final BytecodeExpression invoke(String methodName, Class<?> returnType, Iterable<? extends BytecodeExpression> parameters) {
        return this.invoke(methodName, ParameterizedType.type(returnType), parameters);
    }

    public final BytecodeExpression invoke(String methodName, ParameterizedType returnType, Iterable<? extends BytecodeExpression> parameters) {
        Objects.requireNonNull(parameters, "parameters is null");
        return this.invoke(methodName, returnType, (Iterable<ParameterizedType>)ImmutableList.copyOf((Iterable)Iterables.transform(parameters, BytecodeExpression::getType)), parameters);
    }

    public final BytecodeExpression invoke(String methodName, Class<?> returnType, Iterable<? extends Class<?>> parameterTypes, BytecodeExpression ... parameters) {
        return this.invoke(methodName, ParameterizedType.type(returnType), (Iterable<ParameterizedType>)Iterables.transform(parameterTypes, ParameterizedType::type), (Iterable<? extends BytecodeExpression>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public final BytecodeExpression invoke(String methodName, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes, BytecodeExpression ... parameters) {
        return this.invoke(methodName, returnType, parameterTypes, (Iterable<? extends BytecodeExpression>)ImmutableList.copyOf((Object[])Objects.requireNonNull(parameters, "parameters is null")));
    }

    public final BytecodeExpression invoke(String methodName, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes, Iterable<? extends BytecodeExpression> parameters) {
        return InvokeBytecodeExpression.createInvoke(this, methodName, returnType, parameterTypes, parameters);
    }

    public final BytecodeExpression getElement(int index) {
        return new GetElementBytecodeExpression(this, BytecodeExpressions.constantInt(index));
    }

    public final BytecodeExpression getElement(BytecodeExpression index) {
        return new GetElementBytecodeExpression(this, index);
    }

    public final BytecodeExpression setElement(int index, BytecodeExpression value) {
        return new SetArrayElementBytecodeExpression(this, BytecodeExpressions.constantInt(index), value);
    }

    public final BytecodeExpression setElement(BytecodeExpression index, BytecodeExpression value) {
        return new SetArrayElementBytecodeExpression(this, index, value);
    }

    public final BytecodeExpression length() {
        return new ArrayLengthBytecodeExpression(this);
    }

    public final BytecodeExpression ret() {
        return new ReturnBytecodeExpression(this);
    }

    public final BytecodeExpression pop() {
        if (this.getType().getPrimitiveType() == Void.TYPE) {
            return this;
        }
        return new PopBytecodeExpression(this);
    }

    @Override
    public final void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
        this.getBytecode(generationContext).accept(visitor, generationContext);
    }

    @Override
    public final <T> T accept(BytecodeNode parent, BytecodeVisitor<T> visitor) {
        return visitor.visitBytecodeExpression(parent, this);
    }

    public BytecodeExpression instanceOf(Class<?> type) {
        return InstanceOfBytecodeExpression.instanceOf(this, type);
    }
}

