/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bytecode.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.FieldDefinition;
import io.airlift.bytecode.MethodGenerationContext;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.expression.BytecodeExpression;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

class SetFieldBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression instance;
    private final ParameterizedType declaringClass;
    private final String name;
    private final BytecodeExpression value;
    private final ParameterizedType fieldType;

    public SetFieldBytecodeExpression(@Nullable BytecodeExpression instance, Class<?> declaringClass, String name, BytecodeExpression value) {
        this(instance, SetFieldBytecodeExpression.getDeclaredField(declaringClass, name), value);
    }

    public SetFieldBytecodeExpression(@Nullable BytecodeExpression instance, Field field, BytecodeExpression value) {
        this(instance, ParameterizedType.type(Objects.requireNonNull(field, "field is null").getDeclaringClass()), field.getName(), value, ParameterizedType.type(field.getType()));
        boolean isStatic = Modifier.isStatic(field.getModifiers());
        if (instance == null) {
            Preconditions.checkArgument((boolean)isStatic, (String)"Field is not static: %s", (Object)field);
        } else {
            Preconditions.checkArgument((!isStatic ? 1 : 0) != 0, (String)"Field is static: %s", (Object)field);
        }
    }

    public SetFieldBytecodeExpression(@Nullable BytecodeExpression instance, FieldDefinition field, BytecodeExpression value) {
        this(instance, Objects.requireNonNull(field, "field is null").getDeclaringClass().getType(), field.getName(), value, field.getType());
        if (instance == null) {
            Preconditions.checkArgument((boolean)field.getAccess().contains((Object)Access.STATIC), (String)"Field is not static: %s", (Object)field);
        } else {
            Preconditions.checkArgument((!field.getAccess().contains((Object)Access.STATIC) ? 1 : 0) != 0, (String)"Field is static: %s", (Object)field);
        }
    }

    public SetFieldBytecodeExpression(@Nullable BytecodeExpression instance, ParameterizedType declaringClass, String name, BytecodeExpression value) {
        this(instance, declaringClass, name, value, value.getType());
    }

    public SetFieldBytecodeExpression(@Nullable BytecodeExpression instance, ParameterizedType declaringClass, String name, BytecodeExpression value, ParameterizedType fieldType) {
        super(ParameterizedType.type(Void.TYPE));
        if (instance != null) {
            Preconditions.checkArgument((!instance.getType().isPrimitive() ? 1 : 0) != 0, (String)"Type %s does not have fields", (Object)instance.getType());
        }
        this.instance = instance;
        this.declaringClass = Objects.requireNonNull(declaringClass, "declaringClass is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.fieldType = Objects.requireNonNull(fieldType, "fieldType is null");
        this.value = Objects.requireNonNull(value, "value is null");
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        if (this.instance == null) {
            return new BytecodeBlock().append(this.value.getBytecode(generationContext)).putStaticField(this.declaringClass, this.name, this.fieldType);
        }
        return new BytecodeBlock().append(this.instance.getBytecode(generationContext)).append(this.value.getBytecode(generationContext)).putField(this.declaringClass, this.name, this.fieldType);
    }

    @Override
    protected String formatOneLine() {
        if (this.instance == null) {
            return this.declaringClass.getSimpleName() + "." + this.name + " = " + this.value;
        }
        return this.instance + "." + this.name + " = " + this.value;
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        ImmutableList.Builder children = ImmutableList.builder();
        if (this.instance != null) {
            children.add((Object)this.instance);
        }
        children.add((Object)this.value);
        return children.build();
    }

    private static Field getDeclaredField(Class<?> declaringClass, String name) {
        Objects.requireNonNull(declaringClass, "declaringClass is null");
        Objects.requireNonNull(name, "name is null");
        try {
            return declaringClass.getField(name);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(String.format("Class %s does not have a '%s' field", declaringClass.getName(), name));
        }
    }
}

