/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.common.annotations.Beta;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Message;
import com.google.inject.spi.ProviderInstanceBinding;
import io.airlift.configuration.ConfigDefaults;
import io.airlift.configuration.ConfigDefaultsHolder;
import io.airlift.configuration.ConfigurationMetadata;
import io.airlift.configuration.ConfigurationProvider;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.ElementsIterator;
import io.airlift.configuration.InvalidConfigurationException;
import io.airlift.configuration.Problems;
import io.airlift.configuration.WarningsMonitor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.bval.jsr.ApacheValidationProvider;
import org.apache.bval.jsr.ApacheValidatorConfiguration;

public class ConfigurationFactory {
    private static final Validator VALIDATOR;
    private final Map<String, String> properties;
    private final Problems.Monitor monitor;
    private final ConcurrentMap<ConfigurationProvider<?>, Object> instanceCache = new ConcurrentHashMap();
    private final Set<String> usedProperties = Sets.newConcurrentHashSet();
    private final Set<ConfigurationProvider<?>> registeredProviders = Sets.newConcurrentHashSet();
    private final ListMultimap<Key<?>, ConfigDefaultsHolder<?>> registeredDefaultConfigs = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    private final LoadingCache<Class<?>, ConfigurationMetadata<?>> metadataCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, ConfigurationMetadata<?>>(){

        public ConfigurationMetadata<?> load(Class<?> configClass) {
            return ConfigurationMetadata.getConfigurationMetadata(configClass, ConfigurationFactory.this.monitor);
        }
    });

    public ConfigurationFactory(Map<String, String> properties) {
        this(properties, Problems.NULL_MONITOR);
    }

    ConfigurationFactory(Map<String, String> properties, Problems.Monitor monitor) {
        this.monitor = monitor;
        this.properties = ImmutableMap.copyOf(properties);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Beta
    public void consumeProperty(String property) {
        Preconditions.checkNotNull((Object)property, (Object)"property is null");
        this.usedProperties.add(property);
    }

    public Set<String> getUsedProperties() {
        return ImmutableSortedSet.copyOf(this.usedProperties);
    }

    @Beta
    public void registerConfigurationClasses(Module module) {
        List<ConfigurationProvider<?>> providers = ConfigurationFactory.getAllProviders(module);
        providers.stream().forEach(provider -> provider.setConfigurationFactory(this));
        this.registeredProviders.addAll(providers);
    }

    Iterable<ConfigurationProvider<?>> getConfigurationProviders() {
        return ImmutableList.copyOf(this.registeredProviders);
    }

    <T> void registerConfigDefaults(ConfigDefaultsHolder<T> holder) {
        this.registeredDefaultConfigs.put(holder.getConfigKey(), holder);
    }

    private <T> ConfigDefaults<T> getConfigDefaults(Key<T> key) {
        List defaults = this.registeredDefaultConfigs.get(key).stream().map(holder -> holder).sorted().map(ConfigDefaultsHolder::getConfigDefaults).collect(Collectors.toList());
        return ConfigDefaults.configDefaults(defaults);
    }

    <T> T getDefaultConfig(Key<T> key) {
        ConfigurationMetadata<T> configurationMetadata = this.getMetadata(key.getTypeLiteral().getRawType());
        configurationMetadata.getProblems().throwIfHasErrors();
        T instance = this.newInstance(configurationMetadata);
        ConfigDefaults<T> configDefaults = this.getConfigDefaults(key);
        configDefaults.setDefaults(instance);
        return instance;
    }

    public <T> T build(Class<T> configClass) {
        return this.build(configClass, null);
    }

    public <T> T build(Class<T> configClass, String prefix) {
        return this.build(configClass, prefix, ConfigDefaults.noDefaults()).getInstance();
    }

    <T> T build(ConfigurationProvider<T> configurationProvider, WarningsMonitor warningsMonitor) {
        T existingValue;
        Preconditions.checkNotNull(configurationProvider, (Object)"configurationProvider");
        this.registeredProviders.add(configurationProvider);
        T instance = this.getCachedInstance(configurationProvider);
        if (instance != null) {
            return instance;
        }
        ConfigurationHolder<T> holder = this.build(configurationProvider.getConfigClass(), configurationProvider.getPrefix(), this.getConfigDefaults(configurationProvider.getKey()));
        instance = holder.getInstance();
        if (warningsMonitor != null) {
            for (Message message : holder.getProblems().getWarnings()) {
                warningsMonitor.onWarning(message.toString());
            }
        }
        if ((existingValue = this.putCachedInstance(configurationProvider, instance)) != null) {
            return existingValue;
        }
        return instance;
    }

    private <T> T getCachedInstance(ConfigurationProvider<T> configurationProvider) {
        return (T)this.instanceCache.get(configurationProvider);
    }

    private <T> T putCachedInstance(ConfigurationProvider<T> configurationProvider, T instance) {
        return (T)this.instanceCache.putIfAbsent(configurationProvider, instance);
    }

    private <T> ConfigurationHolder<T> build(Class<T> configClass, String prefix, ConfigDefaults<T> configDefaults) {
        if (configClass == null) {
            throw new NullPointerException("configClass is null");
        }
        if (prefix == null) {
            prefix = "";
        } else if (!prefix.isEmpty()) {
            prefix = prefix + ".";
        }
        ConfigurationMetadata<T> configurationMetadata = this.getMetadata(configClass);
        configurationMetadata.getProblems().throwIfHasErrors();
        T instance = this.newInstance(configurationMetadata);
        configDefaults.setDefaults(instance);
        Problems problems = new Problems(this.monitor);
        for (ConfigurationMetadata.AttributeMetadata attribute : configurationMetadata.getAttributes().values()) {
            try {
                this.setConfigProperty(instance, attribute, prefix, problems);
            }
            catch (InvalidConfigurationException e) {
                problems.addError(e.getCause(), e.getMessage(), new Object[0]);
            }
        }
        if (configClass.isAnnotationPresent(DefunctConfig.class)) {
            for (String value : configClass.getAnnotation(DefunctConfig.class).value()) {
                if (value.isEmpty() || this.properties.get(prefix + (String)value) == null) continue;
                problems.addError("Defunct property '%s' (class [%s]) cannot be configured.", value, configClass.toString());
            }
        }
        for (ConstraintViolation violation : VALIDATOR.validate(instance, new Class[0])) {
            String propertyFieldName = violation.getPropertyPath().toString();
            String attributeName = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, propertyFieldName);
            ConfigurationMetadata.AttributeMetadata attribute = configurationMetadata.getAttributes().get(attributeName);
            if (attribute != null && attribute.getInjectionPoint() != null) {
                String propertyName = attribute.getInjectionPoint().getProperty();
                if (!prefix.isEmpty()) {
                    propertyName = prefix + "." + propertyName;
                }
                problems.addError("Invalid configuration property %s: %s (for class %s.%s)", propertyName, violation.getMessage(), configClass.getName(), violation.getPropertyPath());
                continue;
            }
            problems.addError("Invalid configuration property with prefix '%s': %s (for class %s.%s)", prefix, violation.getMessage(), configClass.getName(), violation.getPropertyPath());
        }
        problems.throwIfHasErrors();
        return new ConfigurationHolder(instance, problems);
    }

    private <T> ConfigurationMetadata<T> getMetadata(Class<T> configClass) {
        try {
            return (ConfigurationMetadata)this.metadataCache.getUnchecked(configClass);
        }
        catch (UncheckedExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    private <T> T newInstance(ConfigurationMetadata<T> configurationMetadata) {
        try {
            return configurationMetadata.getConstructor().newInstance(new Object[0]);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException && e.getCause() != null) {
                e = e.getCause();
            }
            throw Problems.exceptionFor(e, "Error creating instance of configuration class [%s]", configurationMetadata.getConfigClass().getName());
        }
    }

    private <T> void setConfigProperty(T instance, ConfigurationMetadata.AttributeMetadata attribute, String prefix, Problems problems) throws InvalidConfigurationException {
        ConfigurationMetadata.InjectionPointMetaData injectionPoint = this.findOperativeInjectionPoint(attribute, prefix, problems);
        if (injectionPoint == null) {
            return;
        }
        if (injectionPoint.getSetter().isAnnotationPresent(Deprecated.class)) {
            problems.addWarning("Configuration property '%s' is deprecated and should not be used", injectionPoint.getProperty());
        }
        Object value = this.getInjectedValue(injectionPoint, prefix);
        try {
            injectionPoint.getSetter().invoke(instance, value);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException && e.getCause() != null) {
                e = e.getCause();
            }
            throw new InvalidConfigurationException(e, "Error invoking configuration method [%s]", injectionPoint.getSetter().toGenericString());
        }
    }

    private ConfigurationMetadata.InjectionPointMetaData findOperativeInjectionPoint(ConfigurationMetadata.AttributeMetadata attribute, String prefix, Problems problems) throws ConfigurationException {
        ConfigurationMetadata.InjectionPointMetaData operativeInjectionPoint = attribute.getInjectionPoint();
        String operativeName = null;
        String operativeValue = null;
        if (operativeInjectionPoint != null) {
            operativeName = prefix + operativeInjectionPoint.getProperty();
            operativeValue = this.properties.get(operativeName);
        }
        for (ConfigurationMetadata.InjectionPointMetaData injectionPoint : attribute.getLegacyInjectionPoints()) {
            String fullName = prefix + injectionPoint.getProperty();
            String value = this.properties.get(fullName);
            if (value == null) continue;
            String replacement = "deprecated.";
            if (attribute.getInjectionPoint() != null) {
                replacement = String.format("replaced. Use '%s' instead.", prefix + attribute.getInjectionPoint().getProperty());
            }
            problems.addWarning("Configuration property '%s' has been " + replacement, fullName);
            if (operativeValue == null) {
                operativeInjectionPoint = injectionPoint;
                operativeValue = value;
                operativeName = fullName;
                continue;
            }
            if (value.equals(operativeValue)) continue;
            problems.addError("Value for property '%s' (=%s) conflicts with property '%s' (=%s)", fullName, value, operativeName, operativeValue);
        }
        problems.throwIfHasErrors();
        if (operativeValue == null) {
            return null;
        }
        return operativeInjectionPoint;
    }

    private Object getInjectedValue(ConfigurationMetadata.InjectionPointMetaData injectionPoint, String prefix) throws InvalidConfigurationException {
        String name = prefix + injectionPoint.getProperty();
        String value = this.properties.get(name);
        if (value == null) {
            return null;
        }
        Class<?> propertyType = injectionPoint.getSetter().getParameterTypes()[0];
        Object finalValue = ConfigurationFactory.coerce(propertyType, value);
        if (finalValue == null) {
            throw new InvalidConfigurationException(String.format("Could not coerce value '%s' to %s (property '%s') in order to call [%s]", value, propertyType.getName(), injectionPoint.getProperty(), injectionPoint.getSetter().toGenericString()), new Object[0]);
        }
        this.usedProperties.add(name);
        return finalValue;
    }

    private static Object coerce(Class<?> type, String value) {
        if (type.isPrimitive() && value == null) {
            return null;
        }
        try {
            if (String.class.isAssignableFrom(type)) {
                return value;
            }
            if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
                return Boolean.valueOf(value);
            }
            if (Byte.class.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type)) {
                return Byte.valueOf(value);
            }
            if (Short.class.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type)) {
                return Short.valueOf(value);
            }
            if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
                return Integer.valueOf(value);
            }
            if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
                return Long.valueOf(value);
            }
            if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
                return Float.valueOf(value);
            }
            if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
                return Double.valueOf(value);
            }
        }
        catch (Exception ignored) {
            return null;
        }
        try {
            Method fromString = type.getMethod("fromString", String.class);
            if (fromString.getReturnType().isAssignableFrom(type)) {
                return fromString.invoke(null, value);
            }
        }
        catch (Throwable fromString) {
            // empty catch block
        }
        try {
            Method valueOf = type.getMethod("valueOf", String.class);
            if (valueOf.getReturnType().isAssignableFrom(type)) {
                return valueOf.invoke(null, value);
            }
        }
        catch (Throwable valueOf) {
            // empty catch block
        }
        try {
            Constructor<?> constructor = type.getConstructor(String.class);
            return constructor.newInstance(value);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static List<ConfigurationProvider<?>> getAllProviders(Module ... modules) {
        final ArrayList providers = Lists.newArrayList();
        ElementsIterator elementsIterator = new ElementsIterator(modules);
        for (Element element : elementsIterator) {
            element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(){

                public <T> Void visit(Binding<T> binding) {
                    ProviderInstanceBinding providerInstanceBinding;
                    Provider provider;
                    if (binding instanceof ProviderInstanceBinding && (provider = (providerInstanceBinding = (ProviderInstanceBinding)binding).getProviderInstance()) instanceof ConfigurationProvider) {
                        ConfigurationProvider configurationProvider = (ConfigurationProvider)provider;
                        providers.add(configurationProvider);
                    }
                    return null;
                }
            });
        }
        return providers;
    }

    static {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(null);
            VALIDATOR = ((ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure()).buildValidatorFactory().getValidator();
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    private static class ConfigurationHolder<T> {
        private final T instance;
        private final Problems problems;

        private ConfigurationHolder(T instance, Problems problems) {
            this.instance = instance;
            this.problems = problems;
        }

        public T getInstance() {
            return this.instance;
        }

        public Problems getProblems() {
            return this.problems;
        }
    }
}

