/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public final class ConfigurationLoader {
    private ConfigurationLoader() {
    }

    public static Map<String, String> loadProperties() throws IOException {
        TreeMap<String, String> result = new TreeMap<String, String>();
        String configFile = System.getProperty("config");
        if (configFile != null) {
            result.putAll(ConfigurationLoader.loadPropertiesFrom(configFile));
        }
        result.putAll(ConfigurationLoader.getSystemProperties());
        return ImmutableSortedMap.copyOf(result);
    }

    public static Map<String, String> loadPropertiesFrom(String path) throws IOException {
        Properties properties = new Properties();
        try (FileReader reader = new FileReader(new File(path));){
            properties.load(reader);
        }
        return Maps.fromProperties((Properties)properties);
    }

    public static Map<String, String> getSystemProperties() {
        return Maps.fromProperties((Properties)System.getProperties());
    }
}

