/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.inject.Key;
import java.util.Objects;
import java.util.Optional;

public record ConfigurationBinding<T>(Key<T> key, Class<T> configClass, Optional<String> prefix) {
    public ConfigurationBinding {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(configClass, "configClass");
        Objects.requireNonNull(prefix, "prefix is null");
        Preconditions.checkArgument((!prefix.isPresent() || !prefix.get().isEmpty() ? 1 : 0) != 0, (Object)"prefix is empty");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationBinding that = (ConfigurationBinding)o;
        return this.key.equals(that.key);
    }

    @Override
    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("type", this.configClass).add("qualifier", Optional.ofNullable(this.key.getAnnotationType()).map(Class::getSimpleName).orElse(null)).add("prefix", this.prefix.orElse(null)).toString();
    }
}

