/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration.secrets;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.spi.secrets.SecretProvider;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SecretsResolver {
    private static final Pattern PATTERN = Pattern.compile("\\$\\{([a-zA-Z][a-zA-Z0-9_-]*):(?<key>[^}]+?)}");
    private final Function<String, SecretProvider> secretProvidersFactory;

    public SecretsResolver(Map<String, SecretProvider> secretProviders) {
        this(arg_0 -> ((ImmutableMap)ImmutableMap.copyOf(secretProviders)).get(arg_0));
    }

    public SecretsResolver(Function<String, SecretProvider> secretProvidersFactory) {
        this.secretProvidersFactory = Objects.requireNonNull(secretProvidersFactory, "secretProvidersFactory is null");
    }

    public Map<String, String> getResolvedConfiguration(Map<String, String> properties) {
        return this.getResolvedConfiguration(properties, (propertyKey, throwable) -> {
            throw new RuntimeException(throwable.getMessage());
        });
    }

    public Map<String, String> getResolvedConfiguration(Map<String, String> properties, BiConsumer<String, Throwable> onError) {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)properties.size());
        properties.forEach((propertyKey, propertyValue) -> {
            try {
                builder.put(propertyKey, (Object)this.resolveConfiguration((String)propertyValue));
            }
            catch (RuntimeException exception) {
                onError.accept((String)propertyKey, exception);
            }
        });
        return builder.buildOrThrow();
    }

    private String resolveConfiguration(String configurationValue) {
        StringBuilder replacedPropertyValue = new StringBuilder();
        Matcher matcher = PATTERN.matcher(configurationValue);
        while (matcher.find()) {
            String secretProviderName = matcher.group(1).toLowerCase(Locale.ENGLISH);
            String keyName = matcher.group(2);
            matcher.appendReplacement(replacedPropertyValue, Matcher.quoteReplacement(this.resolveSecret(secretProviderName, keyName)));
        }
        matcher.appendTail(replacedPropertyValue);
        return replacedPropertyValue.toString();
    }

    public String resolveSecret(String secretProviderName, String keyName) {
        SecretProvider secretProvider = this.secretProvidersFactory.apply(secretProviderName);
        Preconditions.checkArgument((secretProvider != null ? 1 : 0) != 0, (String)"No secret provider for key '%s'", (Object)secretProviderName);
        return secretProvider.resolveSecretValue(keyName);
    }
}

