/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigurationAwareModule;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.function.Predicate;

public class ConditionalModule<T>
extends AbstractConfigurationAwareModule {
    private final Key<T> key;
    private final Class<T> config;
    @Nullable
    private final String prefix;
    private final Predicate<T> predicate;
    private final Module module;

    @Deprecated
    public static <T> Module installModuleIf(Class<T> config, Predicate<T> predicate, Module module, Module otherwise) {
        return ConditionalModule.conditionalModule(config, predicate, module, otherwise);
    }

    @Deprecated
    public static <T> Module installModuleIf(Class<T> config, Predicate<T> predicate, Module module) {
        return ConditionalModule.conditionalModule(config, predicate, module);
    }

    public static <T> Module conditionalModule(Class<T> config, Predicate<T> predicate, Module module, Module otherwise) {
        return ConfigurationAwareModule.combine(ConditionalModule.conditionalModule(config, predicate, module), ConditionalModule.conditionalModule(config, predicate.negate(), otherwise));
    }

    public static <T> Module conditionalModule(Class<T> config, String prefix, Predicate<T> predicate, Module module, Module otherwise) {
        return ConfigurationAwareModule.combine(ConditionalModule.conditionalModule(config, prefix, predicate, module), ConditionalModule.conditionalModule(config, prefix, predicate.negate(), otherwise));
    }

    public static <T> Module conditionalModule(Class<T> config, Predicate<T> predicate, Module module) {
        return ConditionalModule.conditionalModule(config, null, predicate, module);
    }

    public static <T> Module conditionalModule(Class<T> config, String prefix, Predicate<T> predicate, Module module) {
        return new ConditionalModule<T>(Key.get(config), config, prefix, predicate, module);
    }

    public static <T> Module conditionalModule(Key<T> key, Class<T> config, String prefix, Predicate<T> predicate, Module module) {
        return new ConditionalModule<T>(key, config, prefix, predicate, module);
    }

    private ConditionalModule(Key<T> key, Class<T> config, String prefix, Predicate<T> predicate, Module module) {
        this.key = Objects.requireNonNull(key, "key is null");
        this.config = Objects.requireNonNull(config, "config is null");
        this.prefix = prefix;
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
        this.module = Objects.requireNonNull(module, "module is null");
    }

    @Override
    protected void setup(Binder binder) {
        if (this.predicate.test(this.buildConfigObject(this.key, this.config, this.prefix))) {
            this.install(this.module);
        }
    }
}

