/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public final class ConfigurationLoader {
    private ConfigurationLoader() {
    }

    @Deprecated
    public static Map<String, String> loadProperties() throws IOException {
        return ConfigurationLoader.loadProperties(true);
    }

    public static Map<String, String> loadProperties(boolean useSystemProperties) throws IOException {
        TreeMap<String, String> result = new TreeMap<String, String>();
        String configFile = System.getProperty("config");
        if (configFile != null) {
            result.putAll(ConfigurationLoader.loadPropertiesFrom(configFile));
        }
        if (useSystemProperties) {
            result.putAll(ConfigurationLoader.getSystemProperties());
        }
        return ImmutableSortedMap.copyOf(result);
    }

    public static Map<String, String> loadPropertiesFrom(String path) throws IOException {
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(path);){
            properties.load(inputStream);
        }
        return (Map)Maps.fromProperties((Properties)properties).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((String)entry.getValue()).trim()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getSystemProperties() {
        Properties systemProperties;
        Properties properties = systemProperties = System.getProperties();
        synchronized (properties) {
            return Maps.fromProperties((Properties)systemProperties);
        }
    }
}

