/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.dbpool;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigBinder;
import io.airlift.dbpool.MySqlDataSource;
import io.airlift.dbpool.MySqlDataSourceConfig;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.client.ServiceTypes;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.weakref.jmx.guice.MBeanModule;

public class MySqlDataSourceModule
extends MBeanModule {
    private final Class<? extends Annotation> annotation;
    private final List<Class<? extends Annotation>> aliases;
    private final String type;

    @SafeVarargs
    public MySqlDataSourceModule(String type, Class<? extends Annotation> annotation, Class<? extends Annotation> ... aliases) {
        if (annotation == null) {
            throw new NullPointerException("annotation is null");
        }
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        this.annotation = annotation;
        this.type = type;
        this.aliases = aliases != null ? ImmutableList.copyOf((Object[])aliases) : Collections.emptyList();
    }

    public void configureMBeans() {
        ConfigBinder.configBinder((Binder)this.binder()).bindConfig(MySqlDataSourceConfig.class, this.annotation, this.type);
        DiscoveryBinder.discoveryBinder((Binder)this.binder()).bindSelector(this.type);
        this.bind(DataSource.class).annotatedWith(this.annotation).toProvider((Provider)new MySqlDataSourceProvider(this.type, this.annotation)).in(Scopes.SINGLETON);
        this.export(DataSource.class).annotatedWith(this.annotation).withGeneratedName();
        Key key = Key.get(DataSource.class, this.annotation);
        for (Class<? extends Annotation> alias : this.aliases) {
            this.bind(DataSource.class).annotatedWith(alias).to(key);
        }
    }

    private static class MySqlDataSourceProvider
    implements Provider<MySqlDataSource> {
        private final String type;
        private final Class<? extends Annotation> annotation;
        private Injector injector;

        private MySqlDataSourceProvider(String type, Class<? extends Annotation> annotation) {
            this.type = type;
            this.annotation = annotation;
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        public MySqlDataSource get() {
            MySqlDataSourceConfig config = (MySqlDataSourceConfig)this.injector.getInstance(Key.get(MySqlDataSourceConfig.class, this.annotation));
            ServiceSelector serviceSelector = (ServiceSelector)this.injector.getInstance(Key.get(ServiceSelector.class, (Annotation)ServiceTypes.serviceType((String)this.type)));
            return new MySqlDataSource(serviceSelector, config);
        }
    }
}

