/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.dbpool;

import io.airlift.dbpool.ManagedDataSource;
import io.airlift.units.Duration;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Deque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

abstract class PooledDataSource
extends ManagedDataSource {
    private final AtomicBoolean disposed = new AtomicBoolean();
    private final Deque<PooledConnection> pool = new LinkedBlockingDeque<PooledConnection>();

    PooledDataSource(ConnectionPoolDataSource dataSource, int maxConnections, Duration maxConnectionWait) {
        super(maxConnections, maxConnectionWait);
    }

    public void dispose() {
        this.disposed.set(true);
        PooledConnection pooledConnection = this.pool.poll();
        while (pooledConnection != null) {
            try {
                pooledConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            pooledConnection = this.pool.poll();
        }
    }

    @Override
    protected Connection createConnection() throws SQLException {
        this.assertNotDisposed();
        PooledConnection pooledConnection = this.pool.pollLast();
        if (pooledConnection != null) {
            return this.prepareConnection(pooledConnection);
        }
        return super.createConnection();
    }

    @Override
    protected void connectionReturned(PooledConnection pooledConnection, long checkoutTime) {
        if (this.disposed.get() || this.getConnectionsActive() + (long)this.pool.size() > (long)this.getMaxConnections()) {
            super.connectionReturned(pooledConnection, checkoutTime);
        } else {
            this.pool.addLast(pooledConnection);
        }
    }

    private void assertNotDisposed() throws SQLException {
        if (this.disposed.get()) {
            throw new SQLException(this.getClass().getSimpleName() + " has been disposed");
        }
    }
}

